/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.vibe.platform.server.vertx2;

import java.nio.ByteBuffer;
import org.atmosphere.vibe.platform.Data;
import org.atmosphere.vibe.platform.server.AbstractServerWebSocket;
import org.vertx.java.core.Handler;
import org.vertx.java.core.VoidHandler;
import org.vertx.java.core.buffer.Buffer;
import org.vertx.java.core.http.ServerWebSocket;

public class VertxServerWebSocket
extends AbstractServerWebSocket {
    private final ServerWebSocket socket;
    private String uri;

    public VertxServerWebSocket(ServerWebSocket socket) {
        this.socket = socket;
        ((ServerWebSocket)((ServerWebSocket)socket.closeHandler((Handler)new VoidHandler(){

            protected void handle() {
                VertxServerWebSocket.this.closeActions.fire();
            }
        })).exceptionHandler((Handler)new Handler<Throwable>(){

            public void handle(Throwable throwable) {
                VertxServerWebSocket.this.errorActions.fire((Object)throwable);
            }
        })).dataHandler((Handler)new Handler<Buffer>(){

            public void handle(Buffer buffer) {
                VertxServerWebSocket.this.messageActions.fire((Object)new Data(buffer.toString()));
            }
        });
    }

    public String uri() {
        if (this.uri == null) {
            this.uri = this.socket.path();
            if (this.socket.query() != null) {
                this.uri = this.uri + "?" + this.socket.query();
            }
        }
        return this.uri;
    }

    protected void doClose() {
        this.socket.close();
    }

    protected void doSend(String data) {
        this.socket.writeTextFrame(data);
    }

    protected void doSend(ByteBuffer byteBuffer) {
        this.socket.writeBinaryFrame(new Buffer().setBytes(0, byteBuffer));
    }

    public <T> T unwrap(Class<T> clazz) {
        return ServerWebSocket.class.isAssignableFrom(clazz) ? (T)clazz.cast(this.socket) : null;
    }
}

