/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.vibe.platform.server.vertx2;

import java.nio.ByteBuffer;
import org.atmosphere.vibe.platform.server.AbstractServerWebSocket;
import org.vertx.java.core.Handler;
import org.vertx.java.core.VoidHandler;
import org.vertx.java.core.buffer.Buffer;
import org.vertx.java.core.http.ServerWebSocket;
import org.vertx.java.core.http.WebSocketFrame;
import org.vertx.java.core.http.impl.ws.WebSocketFrameInternal;

public class VertxServerWebSocket
extends AbstractServerWebSocket {
    private final ServerWebSocket socket;

    public VertxServerWebSocket(ServerWebSocket socket) {
        this.socket = socket;
        ((ServerWebSocket)((ServerWebSocket)socket.closeHandler((Handler)new VoidHandler(){

            protected void handle() {
                VertxServerWebSocket.this.closeActions.fire();
            }
        })).exceptionHandler((Handler)new Handler<Throwable>(){

            public void handle(Throwable throwable) {
                VertxServerWebSocket.this.errorActions.fire((Object)throwable);
            }
        })).frameHandler((Handler)new Handler<WebSocketFrame>(){

            public void handle(WebSocketFrame f) {
                WebSocketFrameInternal frame = (WebSocketFrameInternal)f;
                switch (frame.type()) {
                    case TEXT: {
                        VertxServerWebSocket.this.textActions.fire((Object)frame.textData());
                        break;
                    }
                    case BINARY: {
                        VertxServerWebSocket.this.binaryActions.fire((Object)frame.getBinaryData().nioBuffer());
                        break;
                    }
                }
            }
        });
    }

    public String uri() {
        return this.socket.uri();
    }

    protected void doClose() {
        this.socket.close();
    }

    protected void doSend(String data) {
        this.socket.writeTextFrame(data);
    }

    protected void doSend(ByteBuffer byteBuffer) {
        this.socket.writeBinaryFrame(new Buffer().setBytes(0, byteBuffer));
    }

    public <T> T unwrap(Class<T> clazz) {
        return ServerWebSocket.class.isAssignableFrom(clazz) ? (T)clazz.cast(this.socket) : null;
    }
}

