/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.vibe.platform.server;

import java.nio.ByteBuffer;
import org.atmosphere.vibe.platform.Action;
import org.atmosphere.vibe.platform.Actions;
import org.atmosphere.vibe.platform.Data;
import org.atmosphere.vibe.platform.SimpleActions;
import org.atmosphere.vibe.platform.server.ServerWebSocket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractServerWebSocket
implements ServerWebSocket {
    protected final Actions<Data> messageActions = new SimpleActions<Data>();
    protected final Actions<Throwable> errorActions = new SimpleActions<Throwable>(new Actions.Options().once(true).memory(true));
    protected final Actions<Void> closeActions = new SimpleActions<Void>(new Actions.Options().once(true).memory(true));
    private final Logger logger = LoggerFactory.getLogger(AbstractServerWebSocket.class);
    private State state = State.OPEN;

    public AbstractServerWebSocket() {
        this.errorActions.add(new Action<Throwable>(){

            @Override
            public void on(Throwable throwable) {
                AbstractServerWebSocket.this.logger.trace("{} has received a throwable {}", (Object)AbstractServerWebSocket.this, (Object)throwable);
                AbstractServerWebSocket.this.close();
            }
        });
        this.closeActions.add(new Action<Void>(){

            @Override
            public void on(Void reason) {
                AbstractServerWebSocket.this.logger.trace("{} has been closed due to the reason {}", (Object)AbstractServerWebSocket.this, (Object)reason);
                AbstractServerWebSocket.this.state = State.CLOSED;
                AbstractServerWebSocket.this.messageActions.disable();
            }
        });
    }

    @Override
    public ServerWebSocket close() {
        this.logger.trace("{} has started to close the connection", (Object)this);
        if (this.state != State.CLOSING && this.state != State.CLOSED) {
            this.state = State.CLOSING;
            this.doClose();
        }
        return this;
    }

    protected abstract void doClose();

    @Override
    public ServerWebSocket send(String data) {
        this.logger.trace("{} sends a text message {}", (Object)this, (Object)data);
        this.doSend(data);
        return this;
    }

    @Override
    public ServerWebSocket send(ByteBuffer byteBuffer) {
        if (this.logger.isTraceEnabled() && byteBuffer.hasArray()) {
            this.logger.trace("{} sends a text message {}", (Object)this, (Object)new String(byteBuffer.array()));
        }
        this.doSend(byteBuffer);
        return this;
    }

    protected abstract void doSend(ByteBuffer var1);

    protected abstract void doSend(String var1);

    @Override
    public ServerWebSocket messageAction(Action<Data> action) {
        this.messageActions.add(action);
        return this;
    }

    @Override
    public ServerWebSocket errorAction(Action<Throwable> action) {
        this.errorActions.add(action);
        return this;
    }

    @Override
    public ServerWebSocket closeAction(Action<Void> action) {
        this.closeActions.add(action);
        return this;
    }

    static enum State {
        CONNECTING,
        OPEN,
        CLOSING,
        CLOSED;

    }
}

