/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.vibe.platform.server;

import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.List;
import org.atmosphere.vibe.platform.Action;
import org.atmosphere.vibe.platform.Actions;
import org.atmosphere.vibe.platform.Data;
import org.atmosphere.vibe.platform.HttpStatus;
import org.atmosphere.vibe.platform.SimpleActions;
import org.atmosphere.vibe.platform.VoidAction;
import org.atmosphere.vibe.platform.server.ServerHttpExchange;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractServerHttpExchange
implements ServerHttpExchange {
    private boolean read;
    private boolean ended;
    protected final Actions<Data> bodyActions = new SimpleActions<Data>(new Actions.Options().once(true).memory(true));
    protected final Actions<Void> closeActions = new SimpleActions<Void>(new Actions.Options().once(true).memory(true));
    protected final Actions<Throwable> errorActions = new SimpleActions<Throwable>();
    private final Logger logger = LoggerFactory.getLogger(AbstractServerHttpExchange.class);

    public AbstractServerHttpExchange() {
        this.errorActions.add(new Action<Throwable>(){

            @Override
            public void on(Throwable throwable) {
                AbstractServerHttpExchange.this.logger.trace("{} has received a throwable {}", (Object)AbstractServerHttpExchange.this, (Object)throwable);
            }
        });
        this.closeActions.add(new VoidAction(){

            @Override
            public void on() {
                AbstractServerHttpExchange.this.logger.trace("{} has been closed", (Object)AbstractServerHttpExchange.this);
                AbstractServerHttpExchange.this.bodyActions.disable();
                AbstractServerHttpExchange.this.errorActions.disable();
            }
        });
    }

    @Override
    public String header(String name) {
        List<String> headers = this.headers(name);
        return headers != null && headers.size() > 0 ? headers.get(0) : null;
    }

    @Override
    public ServerHttpExchange bodyAction(Action<Data> action) {
        if (!this.read) {
            this.read = true;
            this.readBody();
        }
        this.bodyActions.add(action);
        if (this.ended) {
            this.bodyActions.add(new Action<Data>(){

                @Override
                public void on(Data object) {
                    AbstractServerHttpExchange.this.closeActions.fire();
                }
            });
        }
        return this;
    }

    protected abstract void readBody();

    @Override
    public final ServerHttpExchange setHeader(String name, Iterable<String> value) {
        Iterator<String> iterator = value.iterator();
        StringBuilder builder = new StringBuilder(iterator.next());
        while (iterator.hasNext()) {
            builder.append(", ").append(iterator.next());
        }
        return this.setHeader(name, builder.toString());
    }

    @Override
    public ServerHttpExchange setHeader(String name, String value) {
        this.logger.trace("{} sets a response header {} to {}", new Object[]{this, name, value});
        this.doSetHeader(name, value);
        return this;
    }

    protected abstract void doSetHeader(String var1, String var2);

    @Override
    public ServerHttpExchange write(String data) {
        this.logger.trace("{} sends a text chunk {}", (Object)this, (Object)data);
        this.doWrite(data);
        return this;
    }

    protected abstract void doWrite(String var1);

    @Override
    public ServerHttpExchange write(ByteBuffer byteBuffer) {
        this.logger.trace("{} sends a binary chunk {}", (Object)this, (Object)byteBuffer);
        this.doWrite(byteBuffer);
        return this;
    }

    protected abstract void doWrite(ByteBuffer var1);

    @Override
    public ServerHttpExchange end() {
        this.logger.trace("{} has started to close the connection", (Object)this);
        if (!this.ended) {
            this.ended = true;
            this.doEnd();
            if (this.read) {
                this.closeActions.fire();
            }
        }
        return this;
    }

    protected abstract void doEnd();

    @Override
    public ServerHttpExchange end(String data) {
        return this.write(data).end();
    }

    @Override
    public ServerHttpExchange end(ByteBuffer data) {
        return this.write(data).end();
    }

    @Override
    public ServerHttpExchange setStatus(HttpStatus status) {
        this.logger.trace("{} sets a response status, {}", (Object)this, (Object)status);
        this.doSetStatus(status);
        return this;
    }

    protected abstract void doSetStatus(HttpStatus var1);

    @Override
    public ServerHttpExchange closeAction(Action<Void> action) {
        this.closeActions.add(action);
        return this;
    }

    @Override
    public ServerHttpExchange errorAction(Action<Throwable> action) {
        this.errorActions.add(action);
        return this;
    }
}

