/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.vibe.platform.test.server;

import java.net.ServerSocket;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CountDownLatch;
import org.atmosphere.vibe.platform.Action;
import org.atmosphere.vibe.platform.Data;
import org.atmosphere.vibe.platform.HttpStatus;
import org.atmosphere.vibe.platform.VoidAction;
import org.atmosphere.vibe.platform.server.ServerHttpExchange;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.api.ContentProvider;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.client.util.StringContentProvider;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpMethod;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;

public abstract class ServerHttpExchangeTestTemplate {
    @Rule
    public Timeout globalTimeout = new Timeout(10000);
    protected Performer performer;
    protected int port;

    @Before
    public void before() throws Exception {
        this.performer = new Performer();
        try (ServerSocket serverSocket = new ServerSocket(0);){
            this.port = serverSocket.getLocalPort();
        }
        this.startServer();
    }

    @After
    public void after() throws Exception {
        this.stopServer();
    }

    protected abstract void startServer() throws Exception;

    protected abstract void stopServer() throws Exception;

    @Test
    public void uri() {
        this.performer.serverAction(new Action<ServerHttpExchange>(){

            public void on(ServerHttpExchange http) {
                Assert.assertThat((Object)http.uri(), (Matcher)Matchers.is((Object)"/test?hello=there"));
                ServerHttpExchangeTestTemplate.this.performer.start();
            }
        }).send("/test?hello=there");
    }

    @Test
    public void method() {
        this.performer.serverAction(new Action<ServerHttpExchange>(){

            public void on(ServerHttpExchange http) {
                Assert.assertThat((Object)http.method(), (Matcher)Matchers.is((Object)"POST"));
                ServerHttpExchangeTestTemplate.this.performer.start();
            }
        }).send(new Action<Request>(){

            public void on(Request req) {
                req.method(HttpMethod.POST);
            }
        });
    }

    @Test
    public void header() {
        this.performer.serverAction(new Action<ServerHttpExchange>(){

            public void on(ServerHttpExchange http) {
                Assert.assertThat((Object)http.headerNames(), (Matcher)Matchers.either((Matcher)Matchers.hasItems((Object[])new String[]{"a", "b"})).or(Matchers.hasItems((Object[])new String[]{"A", "B"})));
                Assert.assertThat((Object)http.header("A"), (Matcher)Matchers.is((Object)"A"));
                Assert.assertThat((Object)http.header("B"), (Matcher)Matchers.is((Object)"B1"));
                Assert.assertThat((Object)http.headers("A"), (Matcher)Matchers.contains((Object[])new String[]{"A"}));
                Assert.assertThat((Object)http.headers("B"), (Matcher)Matchers.contains((Object[])new String[]{"B1", "B2"}));
                ServerHttpExchangeTestTemplate.this.performer.start();
            }
        }).send(new Action<Request>(){

            public void on(Request req) {
                req.header("A", "A").header("B", "B1").header("B", "B2");
            }
        });
    }

    @Test
    public void bodyAction() {
        this.performer.serverAction(new Action<ServerHttpExchange>(){

            public void on(ServerHttpExchange http) {
                http.bodyAction((Action)new Action<Data>(){

                    public void on(Data data) {
                        Assert.assertThat((Object)data.as(String.class), (Matcher)Matchers.is((Object)"A Breath Clad In Happiness"));
                        ServerHttpExchangeTestTemplate.this.performer.start();
                    }
                });
            }
        }).send(new Action<Request>(){

            public void on(Request req) {
                req.content((ContentProvider)new StringContentProvider("A Breath Clad In Happiness"));
            }
        });
    }

    @Test
    public void bodyAction_charset() {
        this.performer.serverAction(new Action<ServerHttpExchange>(){

            public void on(ServerHttpExchange http) {
                http.bodyAction((Action)new Action<Data>(){

                    public void on(Data data) {
                        Assert.assertThat((Object)data.as(String.class), (Matcher)Matchers.is((Object)"\ud76c\ub9dd\uc744 \uc783\uace0 \uc4f0\ub7ec\uc838 \uac00\ub3c4 \uc5b8\uc820\uac00 \ub2e4\uc2dc \ub418\ub3cc\uc544\uc628\ub2e4"));
                        ServerHttpExchangeTestTemplate.this.performer.start();
                    }
                });
            }
        }).send(new Action<Request>(){

            public void on(Request req) {
                req.content((ContentProvider)new StringContentProvider("\ud76c\ub9dd\uc744 \uc783\uace0 \uc4f0\ub7ec\uc838 \uac00\ub3c4 \uc5b8\uc820\uac00 \ub2e4\uc2dc \ub418\ub3cc\uc544\uc628\ub2e4"), "text/plain; charset=utf-8");
            }
        });
    }

    @Test
    public void setHeader() {
        this.performer.serverAction(new Action<ServerHttpExchange>(){

            public void on(ServerHttpExchange http) {
                http.setHeader("A", "A").setHeader("B", Arrays.asList("B1", "B2")).close();
            }
        }).responseListener((Response.Listener)new Response.Listener.Adapter(){

            public void onSuccess(Response res) {
                HttpFields headers = res.getHeaders();
                Assert.assertThat((Object)headers.getFieldNamesCollection(), (Matcher)Matchers.hasItems((Object[])new String[]{"A", "B"}));
                Assert.assertThat((Object)headers.get("A"), (Matcher)Matchers.is((Object)"A"));
                Assert.assertThat((Object)headers.get("B"), (Matcher)Matchers.is((Object)"B1, B2"));
                ServerHttpExchangeTestTemplate.this.performer.start();
            }
        }).send();
    }

    @Test
    public void write_text() {
        this.performer.serverAction(new Action<ServerHttpExchange>(){

            public void on(ServerHttpExchange http) {
                http.write("X").write("Y").write("Z").close();
            }
        }).responseListener((Response.Listener)new Response.Listener.Adapter(){
            List<String> chunks = new ArrayList<String>();

            public void onContent(Response response, ByteBuffer content) {
                byte[] bytes = new byte[content.remaining()];
                content.get(bytes);
                this.chunks.add(new String(bytes, Charset.forName("ISO-8859-1")));
            }

            public void onSuccess(Response response) {
                Assert.assertThat(this.chunks, (Matcher)Matchers.contains((Object[])new String[]{"X", "Y", "Z"}));
                ServerHttpExchangeTestTemplate.this.performer.start();
            }
        }).send();
    }

    @Test
    public void write_binary() {
        this.performer.serverAction(new Action<ServerHttpExchange>(){

            public void on(ServerHttpExchange http) {
                http.write(ByteBuffer.wrap(new byte[]{0}).asReadOnlyBuffer()).write(ByteBuffer.wrap(new byte[]{1})).write(ByteBuffer.wrap(new byte[]{2})).close();
            }
        }).responseListener((Response.Listener)new Response.Listener.Adapter(){
            List<byte[]> chunks = new ArrayList<byte[]>();

            public void onContent(Response response, ByteBuffer content) {
                byte[] bytes = new byte[content.remaining()];
                content.get(bytes);
                this.chunks.add(bytes);
            }

            public void onSuccess(Response response) {
                Assert.assertThat(this.chunks, (Matcher)Matchers.contains((Object[])new byte[][]{{0}, {1}, {2}}));
                ServerHttpExchangeTestTemplate.this.performer.start();
            }
        }).send();
    }

    @Test
    public void close() {
        this.performer.serverAction(new Action<ServerHttpExchange>(){

            public void on(ServerHttpExchange http) {
                http.close();
            }
        }).responseListener((Response.Listener)new Response.Listener.Adapter(){

            public void onSuccess(Response response) {
                ServerHttpExchangeTestTemplate.this.performer.start();
            }
        }).send();
    }

    @Test
    public void close_with_text_data() {
        this.performer.serverAction(new Action<ServerHttpExchange>(){

            public void on(ServerHttpExchange http) {
                http.close("Out of existence");
            }
        }).responseListener((Response.Listener)new Response.Listener.Adapter(){
            String body;

            public void onContent(Response response, ByteBuffer content) {
                byte[] bytes = new byte[content.remaining()];
                content.get(bytes);
                this.body = new String(bytes, Charset.forName("ISO-8859-1"));
            }

            public void onSuccess(Response response) {
                Assert.assertThat((Object)this.body, (Matcher)Matchers.is((Object)"Out of existence"));
                ServerHttpExchangeTestTemplate.this.performer.start();
            }
        }).send();
    }

    @Test
    public void close_with_binary_data() {
        this.performer.serverAction(new Action<ServerHttpExchange>(){

            public void on(ServerHttpExchange http) {
                http.close(ByteBuffer.wrap(new byte[]{0, 1, 2}));
            }
        }).responseListener((Response.Listener)new Response.Listener.Adapter(){
            byte[] body;

            public void onContent(Response response, ByteBuffer content) {
                this.body = new byte[content.remaining()];
                content.get(this.body);
            }

            public void onSuccess(Response response) {
                Assert.assertThat((Object)this.body, (Matcher)Matchers.is((Object)new byte[]{0, 1, 2}));
                ServerHttpExchangeTestTemplate.this.performer.start();
            }
        }).send();
    }

    @Test
    public void setStatus() {
        this.performer.serverAction(new Action<ServerHttpExchange>(){

            public void on(ServerHttpExchange http) {
                http.setStatus(HttpStatus.NOT_FOUND).close();
            }
        }).responseListener((Response.Listener)new Response.Listener.Adapter(){

            public void onSuccess(Response response) {
                Assert.assertThat((Object)response.getStatus(), (Matcher)Matchers.is((Object)404));
                ServerHttpExchangeTestTemplate.this.performer.start();
            }
        }).send();
    }

    @Test
    public void closeAction_by_server() {
        this.performer.serverAction(new Action<ServerHttpExchange>(){

            public void on(ServerHttpExchange http) {
                http.close().closeAction((Action)new VoidAction(){

                    public void on() {
                        ServerHttpExchangeTestTemplate.this.performer.start();
                    }
                });
            }
        }).send();
    }

    @Test
    public void closeAction_by_client() {
        this.performer.serverAction(new Action<ServerHttpExchange>(){

            public void on(ServerHttpExchange http) {
                http.closeAction((Action)new VoidAction(){

                    public void on() {
                        ServerHttpExchangeTestTemplate.this.performer.start();
                    }
                });
            }
        }).send(new Action<Request>(){

            public void on(final Request req) {
                new Timer(true).schedule(new TimerTask(){

                    @Override
                    public void run() {
                        req.abort((Throwable)new RuntimeException());
                    }
                }, 1000L);
            }
        });
    }

    protected class Performer {
        CountDownLatch latch = new CountDownLatch(1);
        Request.Listener requestListener = new Request.Listener.Adapter();
        Response.Listener responseListener = new Response.Listener.Adapter();
        Action<ServerHttpExchange> serverAction = new Action<ServerHttpExchange>(){

            public void on(ServerHttpExchange object) {
            }
        };

        protected Performer() {
        }

        public Performer requestListener(Request.Listener requestListener) {
            this.requestListener = requestListener;
            return this;
        }

        public Performer responseListener(Response.Listener responseListener) {
            this.responseListener = responseListener;
            return this;
        }

        public Action<ServerHttpExchange> serverAction() {
            return this.serverAction;
        }

        public Performer serverAction(Action<ServerHttpExchange> serverAction) {
            this.serverAction = serverAction;
            return this;
        }

        public Performer send() {
            return this.send("/test");
        }

        public Performer send(Action<Request> requestAction) {
            return this.send("/test", requestAction);
        }

        public Performer send(String uri) {
            return this.send(uri, null);
        }

        public Performer send(String uri, Action<Request> requestAction) {
            HttpClient client = new HttpClient();
            try {
                client.start();
                Request req = client.newRequest("http://localhost:" + ServerHttpExchangeTestTemplate.this.port + uri);
                if (requestAction != null) {
                    requestAction.on((Object)req);
                }
                req.listener(this.requestListener).send((Response.CompleteListener)this.responseListener);
                this.latch.await();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                try {
                    client.stop();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            return this;
        }

        public Performer start() {
            this.latch.countDown();
            return this;
        }
    }
}

