/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.vibe.platform.test.server;

import java.net.ServerSocket;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.concurrent.CountDownLatch;
import org.atmosphere.vibe.platform.Action;
import org.atmosphere.vibe.platform.VoidAction;
import org.atmosphere.vibe.platform.server.ServerWebSocket;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.WebSocketAdapter;
import org.eclipse.jetty.websocket.api.WebSocketListener;
import org.eclipse.jetty.websocket.api.WriteCallback;
import org.eclipse.jetty.websocket.client.WebSocketClient;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;

public abstract class ServerWebSocketTestTemplate {
    @Rule
    public Timeout globalTimeout = new Timeout(10000);
    protected Performer performer;
    protected int port;

    @Before
    public void before() throws Exception {
        this.performer = new Performer();
        try (ServerSocket serverSocket = new ServerSocket(0);){
            this.port = serverSocket.getLocalPort();
        }
        this.startServer();
    }

    @After
    public void after() throws Exception {
        this.stopServer();
    }

    protected abstract void startServer() throws Exception;

    protected abstract void stopServer() throws Exception;

    @Test
    public void uri() {
        this.performer.serverAction(new Action<ServerWebSocket>(){

            public void on(ServerWebSocket ws) {
                Assert.assertThat((Object)ws.uri(), (Matcher)Matchers.is((Object)"/test?hello=there"));
                ServerWebSocketTestTemplate.this.performer.start();
            }
        }).connect("/test?hello=there");
    }

    @Test
    public void close() {
        this.performer.clientListener((WebSocketListener)new WebSocketAdapter(){

            public void onWebSocketClose(int statusCode, String reason) {
                ServerWebSocketTestTemplate.this.performer.start();
            }
        }).serverAction(new Action<ServerWebSocket>(){

            public void on(ServerWebSocket ws) {
                ws.close();
            }
        }).connect();
    }

    @Test
    public void close_idempotent() {
        this.performer.clientListener((WebSocketListener)new WebSocketAdapter(){

            public void onWebSocketClose(int statusCode, String reason) {
                ServerWebSocketTestTemplate.this.performer.start();
            }
        }).serverAction(new Action<ServerWebSocket>(){

            public void on(ServerWebSocket ws) {
                ws.close().close();
            }
        }).connect();
    }

    @Test
    public void send_text() {
        this.performer.clientListener((WebSocketListener)new WebSocketAdapter(){

            public void onWebSocketText(String message) {
                Assert.assertThat((Object)message, (Matcher)Matchers.is((Object)"A Will Remains in the Ashes"));
                ServerWebSocketTestTemplate.this.performer.start();
            }
        }).serverAction(new Action<ServerWebSocket>(){

            public void on(ServerWebSocket ws) {
                ws.send("A Will Remains in the Ashes");
            }
        }).connect();
    }

    @Test
    public void send_binary() {
        this.performer.clientListener((WebSocketListener)new WebSocketAdapter(){

            public void onWebSocketBinary(byte[] payload, int offset, int len) {
                Assert.assertThat((Object)payload, (Matcher)Matchers.is((Object)new byte[]{0, 1, 2}));
                ServerWebSocketTestTemplate.this.performer.start();
            }
        }).serverAction(new Action<ServerWebSocket>(){

            public void on(ServerWebSocket ws) {
                ws.send(ByteBuffer.wrap(new byte[]{0, 1, 2}).asReadOnlyBuffer());
            }
        }).connect();
    }

    @Test
    public void send_text_and_binary() {
        this.performer.clientListener((WebSocketListener)new WebSocketAdapter(){
            boolean done;

            public void onWebSocketText(String message) {
                Assert.assertThat((Object)message, (Matcher)Matchers.is((Object)"A Will Remains in the Ashes"));
                if (this.done) {
                    ServerWebSocketTestTemplate.this.performer.start();
                } else {
                    this.done = true;
                }
            }

            public void onWebSocketBinary(byte[] payload, int offset, int len) {
                Assert.assertThat((Object)payload, (Matcher)Matchers.is((Object)new byte[]{0, 1, 2}));
                if (this.done) {
                    ServerWebSocketTestTemplate.this.performer.start();
                } else {
                    this.done = true;
                }
            }
        }).serverAction(new Action<ServerWebSocket>(){

            public void on(ServerWebSocket ws) {
                ws.send("A Will Remains in the Ashes").send(ByteBuffer.wrap(new byte[]{0, 1, 2}));
            }
        }).connect();
    }

    @Test
    public void textAction() {
        this.performer.clientListener((WebSocketListener)new WebSocketAdapter(){

            public void onWebSocketConnect(Session sess) {
                sess.getRemote().sendString("A road of winds the water builds", new WriteCallback(){

                    public void writeSuccess() {
                        Assert.assertThat((Object)true, (Matcher)Matchers.is((Object)true));
                    }

                    public void writeFailed(Throwable x) {
                        Assert.assertThat((Object)true, (Matcher)Matchers.is((Object)false));
                    }
                });
            }
        }).serverAction(new Action<ServerWebSocket>(){

            public void on(ServerWebSocket ws) {
                ws.textAction((Action)new Action<String>(){

                    public void on(String data) {
                        Assert.assertThat((Object)data, (Matcher)Matchers.is((Object)"A road of winds the water builds"));
                        ServerWebSocketTestTemplate.this.performer.start();
                    }
                });
            }
        }).connect();
    }

    @Test
    public void binaryAction() {
        this.performer.clientListener((WebSocketListener)new WebSocketAdapter(){

            public void onWebSocketConnect(Session sess) {
                sess.getRemote().sendBytes(ByteBuffer.wrap(new byte[]{0, 1, 2}), new WriteCallback(){

                    public void writeSuccess() {
                        Assert.assertThat((Object)true, (Matcher)Matchers.is((Object)true));
                    }

                    public void writeFailed(Throwable x) {
                        Assert.assertThat((Object)true, (Matcher)Matchers.is((Object)false));
                    }
                });
            }
        }).serverAction(new Action<ServerWebSocket>(){

            public void on(ServerWebSocket ws) {
                ws.binaryAction((Action)new Action<ByteBuffer>(){

                    public void on(ByteBuffer data) {
                        Assert.assertThat((Object)data, (Matcher)Matchers.is((Object)ByteBuffer.wrap(new byte[]{0, 1, 2})));
                        ServerWebSocketTestTemplate.this.performer.start();
                    }
                });
            }
        }).connect();
    }

    @Test
    public void textAction_and_binaryAction() {
        this.performer.clientListener((WebSocketListener)new WebSocketAdapter(){

            public void onWebSocketConnect(Session sess) {
                sess.getRemote().sendString("A road of winds the water builds", new WriteCallback(){

                    public void writeSuccess() {
                        Assert.assertThat((Object)true, (Matcher)Matchers.is((Object)true));
                    }

                    public void writeFailed(Throwable x) {
                        Assert.assertThat((Object)true, (Matcher)Matchers.is((Object)false));
                    }
                });
                sess.getRemote().sendBytes(ByteBuffer.wrap(new byte[]{0, 1, 2}), new WriteCallback(){

                    public void writeSuccess() {
                        Assert.assertThat((Object)true, (Matcher)Matchers.is((Object)true));
                    }

                    public void writeFailed(Throwable x) {
                        Assert.assertThat((Object)true, (Matcher)Matchers.is((Object)false));
                    }
                });
            }
        }).serverAction(new Action<ServerWebSocket>(){
            boolean done;

            public void on(ServerWebSocket ws) {
                ws.textAction((Action)new Action<String>(){

                    public void on(String data) {
                        Assert.assertThat((Object)data, (Matcher)Matchers.is((Object)"A road of winds the water builds"));
                        if (done) {
                            ServerWebSocketTestTemplate.this.performer.start();
                        } else {
                            done = true;
                        }
                    }
                }).binaryAction((Action)new Action<ByteBuffer>(){

                    public void on(ByteBuffer data) {
                        Assert.assertThat((Object)data, (Matcher)Matchers.is((Object)ByteBuffer.wrap(new byte[]{0, 1, 2})));
                        if (done) {
                            ServerWebSocketTestTemplate.this.performer.start();
                        } else {
                            done = true;
                        }
                    }
                });
            }
        }).connect();
    }

    @Test
    public void closeAction_by_server() {
        this.performer.serverAction(new Action<ServerWebSocket>(){

            public void on(ServerWebSocket ws) {
                ws.close().closeAction((Action)new VoidAction(){

                    public void on() {
                        ServerWebSocketTestTemplate.this.performer.start();
                    }
                });
            }
        }).connect();
    }

    @Test
    public void closeAction_by_client() {
        this.performer.clientListener((WebSocketListener)new WebSocketAdapter(){

            public void onWebSocketConnect(Session sess) {
                sess.close();
            }
        }).serverAction(new Action<ServerWebSocket>(){

            public void on(ServerWebSocket ws) {
                ws.closeAction((Action)new VoidAction(){

                    public void on() {
                        ServerWebSocketTestTemplate.this.performer.start();
                    }
                });
            }
        }).connect();
    }

    protected class Performer {
        CountDownLatch latch = new CountDownLatch(1);
        WebSocketListener clientListener = new WebSocketAdapter();
        Action<ServerWebSocket> serverAction = new Action<ServerWebSocket>(){

            public void on(ServerWebSocket object) {
            }
        };

        protected Performer() {
        }

        public Performer clientListener(WebSocketListener clientListener) {
            this.clientListener = clientListener;
            return this;
        }

        public Action<ServerWebSocket> serverAction() {
            return this.serverAction;
        }

        public Performer serverAction(Action<ServerWebSocket> serverAction) {
            this.serverAction = serverAction;
            return this;
        }

        public Performer connect() {
            return this.connect("/test");
        }

        public Performer connect(String uri) {
            WebSocketClient client = new WebSocketClient();
            try {
                client.start();
                client.connect((Object)this.clientListener, URI.create("ws://localhost:" + ServerWebSocketTestTemplate.this.port + uri));
                this.latch.await();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                try {
                    client.stop();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            return this;
        }

        public Performer start() {
            this.latch.countDown();
            return this;
        }
    }
}

