/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.vibe.server;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.nio.CharBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.atmosphere.vibe.platform.Action;
import org.atmosphere.vibe.platform.Actions;
import org.atmosphere.vibe.platform.ConcurrentActions;
import org.atmosphere.vibe.platform.Data;
import org.atmosphere.vibe.platform.HttpStatus;
import org.atmosphere.vibe.platform.VoidAction;
import org.atmosphere.vibe.platform.Wrapper;
import org.atmosphere.vibe.platform.server.ServerHttpExchange;
import org.atmosphere.vibe.platform.server.ServerWebSocket;
import org.atmosphere.vibe.server.Sentence;
import org.atmosphere.vibe.server.Server;
import org.atmosphere.vibe.server.ServerSocket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultServer
implements Server {
    private final Logger log = LoggerFactory.getLogger(DefaultServer.class);
    private ConcurrentMap<String, DefaultServerSocket> sockets = new ConcurrentHashMap<String, DefaultServerSocket>();
    private Actions<ServerSocket> socketActions = new ConcurrentActions();
    private Action<ServerHttpExchange> httpAction = new Action<ServerHttpExchange>(){

        public void on(final ServerHttpExchange http) {
            final Map params = DefaultServer.this.parseURI(http.uri());
            block4 : switch (http.method()) {
                case "GET": {
                    this.setNocache(http);
                    this.setCors(http);
                    switch ((String)params.get("when")) {
                        case "open": {
                            switch ((String)params.get("transport")) {
                                case "sse": 
                                case "streamxhr": 
                                case "streamxdr": 
                                case "streamiframe": {
                                    DefaultServer.this.socketActions.fire((Object)new DefaultServerSocket(new StreamTransport(params, http)));
                                    break block4;
                                }
                                case "longpollajax": 
                                case "longpollxdr": 
                                case "longpolljsonp": {
                                    DefaultServer.this.socketActions.fire((Object)new DefaultServerSocket(new LongpollTransport(params, http)));
                                    break block4;
                                }
                            }
                            DefaultServer.this.log.error("Transport, {}, is not supported", params.get("transport"));
                            http.setStatus(HttpStatus.NOT_IMPLEMENTED).close();
                            break block4;
                        }
                        case "poll": {
                            String id = (String)params.get("id");
                            DefaultServerSocket socket = (DefaultServerSocket)DefaultServer.this.sockets.get(id);
                            if (socket != null) {
                                Transport transport = socket.transport;
                                if (transport instanceof LongpollTransport) {
                                    ((LongpollTransport)transport).refresh(http);
                                    break block4;
                                }
                                DefaultServer.this.log.error("Non-long polling transport#{} sent poll request", (Object)id);
                                http.setStatus(HttpStatus.INTERNAL_SERVER_ERROR).close();
                                break block4;
                            }
                            DefaultServer.this.log.error("Long polling transport#{} is not found in poll request", (Object)id);
                            http.setStatus(HttpStatus.INTERNAL_SERVER_ERROR).close();
                            break block4;
                        }
                        case "abort": {
                            String id = (String)params.get("id");
                            ServerSocket socket = (ServerSocket)DefaultServer.this.sockets.get(id);
                            if (socket != null) {
                                socket.close();
                            }
                            http.setHeader("content-type", "text/javascript; charset=utf-8").close();
                            break block4;
                        }
                    }
                    DefaultServer.this.log.error("when, {}, is not supported", params.get("when"));
                    http.setStatus(HttpStatus.NOT_IMPLEMENTED).close();
                    break;
                }
                case "POST": {
                    this.setNocache(http);
                    this.setCors(http);
                    http.bodyAction((Action)new Action<Data>(){

                        public void on(Data body) {
                            String data = ((String)body.as(String.class)).substring("data=".length());
                            String id = (String)params.get("id");
                            DefaultServerSocket socket = (DefaultServerSocket)DefaultServer.this.sockets.get(id);
                            if (socket != null) {
                                Transport transport = socket.transport;
                                if (transport instanceof HttpTransport) {
                                    transport.messageActions.fire((Object)data);
                                } else {
                                    DefaultServer.this.log.error("Non-HTTP socket#{} receives a POST message", (Object)id);
                                    http.setStatus(HttpStatus.INTERNAL_SERVER_ERROR);
                                }
                            } else {
                                DefaultServer.this.log.error("A POST message arrived but no socket#{} is found", (Object)id);
                                http.setStatus(HttpStatus.INTERNAL_SERVER_ERROR);
                            }
                            http.close();
                        }
                    });
                    break;
                }
                default: {
                    DefaultServer.this.log.error("HTTP method, {}, is not supported", (Object)http.method());
                    http.setStatus(HttpStatus.METHOD_NOT_ALLOWED).close();
                }
            }
        }

        private void setNocache(ServerHttpExchange http) {
            http.setHeader("cache-control", "no-cache, no-store, must-revalidate").setHeader("pragma", "no-cache").setHeader("expires", "0");
        }

        private void setCors(ServerHttpExchange http) {
            String origin = http.header("origin");
            http.setHeader("access-control-allow-origin", origin != null ? origin : "*").setHeader("access-control-allow-credentials", "true");
        }
    };
    private Action<ServerWebSocket> websocketAction = new Action<ServerWebSocket>(){

        public void on(ServerWebSocket ws) {
            Map params = DefaultServer.this.parseURI(ws.uri());
            DefaultServer.this.socketActions.fire((Object)new DefaultServerSocket(new WebSocketTransport(params, ws)));
        }
    };
    static final String text2KB = CharBuffer.allocate(2048).toString().replace('\u0000', ' ');

    private Map<String, String> parseURI(String uri) {
        String[] params;
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        String query = URI.create(uri).getQuery();
        if (query == null || query.equals("")) {
            return map;
        }
        for (String param : params = query.split("&")) {
            try {
                String[] pair = param.split("=", 2);
                String name = URLDecoder.decode(pair[0], "UTF-8");
                if (name == "") continue;
                map.put(name, pair.length > 1 ? URLDecoder.decode(pair[1], "UTF-8") : "");
            }
            catch (UnsupportedEncodingException e) {
                // empty catch block
            }
        }
        return Collections.unmodifiableMap(map);
    }

    private Map<String, Object> parseEvent(String text) {
        try {
            return (Map)new ObjectMapper().readValue(text, (TypeReference)new TypeReference<Map<String, Object>>(){});
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private String stringifyEvent(Map<String, Object> event) {
        try {
            return new ObjectMapper().writeValueAsString(event);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Sentence all() {
        return new Sentence(new Action<Action<ServerSocket>>(){

            public void on(Action<ServerSocket> action) {
                DefaultServer.this.all(action);
            }
        });
    }

    @Override
    public Server all(Action<ServerSocket> action) {
        for (ServerSocket socket : this.sockets.values()) {
            action.on((Object)socket);
        }
        return this;
    }

    @Override
    public Sentence byId(final String id) {
        return new Sentence(new Action<Action<ServerSocket>>(){

            public void on(Action<ServerSocket> action) {
                DefaultServer.this.byId(id, action);
            }
        });
    }

    @Override
    public Server byId(String id, Action<ServerSocket> action) {
        ServerSocket socket = (ServerSocket)this.sockets.get(id);
        if (socket != null) {
            action.on((Object)socket);
        }
        return this;
    }

    @Override
    public Sentence byTag(final String ... names) {
        return new Sentence(new Action<Action<ServerSocket>>(){

            public void on(Action<ServerSocket> action) {
                DefaultServer.this.byTag(names, action);
            }
        });
    }

    @Override
    public Server byTag(String name, Action<ServerSocket> action) {
        return this.byTag(new String[]{name}, action);
    }

    @Override
    public Server byTag(String[] names, Action<ServerSocket> action) {
        List<String> nameList = Arrays.asList(names);
        for (ServerSocket socket : this.sockets.values()) {
            if (!socket.tags().containsAll(nameList)) continue;
            action.on((Object)socket);
        }
        return this;
    }

    @Override
    public Server socketAction(Action<ServerSocket> action) {
        this.socketActions.add(action);
        return this;
    }

    @Override
    public Action<ServerHttpExchange> httpAction() {
        return this.httpAction;
    }

    @Override
    public Action<ServerWebSocket> websocketAction() {
        return this.websocketAction;
    }

    private class DefaultServerSocket
    implements ServerSocket {
        final Transport transport;
        AtomicInteger eventId = new AtomicInteger();
        Set<String> tags = new CopyOnWriteArraySet<String>();
        ConcurrentMap<String, Actions<Object>> actionsMap = new ConcurrentHashMap<String, Actions<Object>>();
        ConcurrentMap<String, Map<String, Action<Object>>> callbacksMap = new ConcurrentHashMap<String, Map<String, Action<Object>>>();

        DefaultServerSocket(Transport transport) {
            this.transport = transport;
            transport.closeActions.add((Action)new VoidAction(){

                public void on() {
                    DefaultServer.this.sockets.remove(DefaultServerSocket.this.id());
                    Actions closeActions = (Actions)DefaultServerSocket.this.actionsMap.get("close");
                    if (closeActions != null) {
                        closeActions.fire();
                    }
                }
            });
            transport.messageActions.add((Action)new Action<String>(){

                public void on(String text) {
                    final Map event = DefaultServer.this.parseEvent(text);
                    Actions actions = (Actions)DefaultServerSocket.this.actionsMap.get(event.get("type"));
                    if (actions != null) {
                        if (((Boolean)event.get("reply")).booleanValue()) {
                            actions.fire((Object)new ServerSocket.Reply<Object>(){
                                AtomicBoolean sent = new AtomicBoolean();

                                @Override
                                public Object data() {
                                    return event.get("data");
                                }

                                @Override
                                public void resolve() {
                                    this.resolve(null);
                                }

                                @Override
                                public void resolve(Object value) {
                                    this.sendReply(value, false);
                                }

                                @Override
                                public void reject() {
                                    this.reject(null);
                                }

                                @Override
                                public void reject(Object value) {
                                    this.sendReply(value, true);
                                }

                                private void sendReply(Object value, boolean exception) {
                                    if (this.sent.compareAndSet(false, true)) {
                                        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
                                        result.put("id", event.get("id"));
                                        result.put("data", value);
                                        result.put("exception", exception);
                                        DefaultServerSocket.this.send("reply", result);
                                    }
                                }
                            });
                        } else {
                            actions.fire(event.get("data"));
                        }
                    }
                }
            });
            this.on("reply", new Action<Map<String, Object>>(){

                public void on(Map<String, Object> info) {
                    Map cbs = (Map)DefaultServerSocket.this.callbacksMap.remove(info.get("id"));
                    Action action = (Boolean)info.get("exception") != false ? (Action)cbs.get("rejected") : (Action)cbs.get("resolved");
                    action.on(info.get("data"));
                }
            });
            try {
                new HeartbeatHelper(Long.valueOf(transport.params.get("heartbeat")));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            DefaultServer.this.sockets.put(this.id(), this);
        }

        @Override
        public String id() {
            return this.transport.params.get("id");
        }

        @Override
        public String uri() {
            return this.transport.uri();
        }

        @Override
        public Set<String> tags() {
            return this.tags;
        }

        @Override
        public <T> ServerSocket on(String event, Action<T> action) {
            ConcurrentActions value;
            ConcurrentActions actions = (ConcurrentActions)this.actionsMap.get(event);
            if (actions == null && (actions = this.actionsMap.putIfAbsent(event, (Actions<Object>)(value = new ConcurrentActions()))) == null) {
                actions = value;
            }
            actions.add(action);
            return this;
        }

        @Override
        public <T> ServerSocket off(String event, Action<T> action) {
            Actions actions = (Actions)this.actionsMap.get(event);
            if (actions != null) {
                actions.remove(action);
            }
            return this;
        }

        @Override
        public ServerSocket send(String event) {
            return this.send(event, null);
        }

        @Override
        public ServerSocket send(String event, Object data) {
            return this.send(event, data, null);
        }

        @Override
        public <T> ServerSocket send(String type, Object data, Action<T> resolved) {
            return this.send(type, data, resolved, null);
        }

        @Override
        public <T, U> ServerSocket send(String type, Object data, Action<T> resolved, Action<U> rejected) {
            String id = "" + this.eventId.incrementAndGet();
            LinkedHashMap<String, Object> event = new LinkedHashMap<String, Object>();
            event.put("id", id);
            event.put("type", type);
            event.put("data", data);
            event.put("reply", resolved != null || rejected != null);
            String text = DefaultServer.this.stringifyEvent(event);
            this.transport.send(text);
            if (resolved != null || rejected != null) {
                LinkedHashMap<String, Object> cbs = new LinkedHashMap<String, Object>();
                cbs.put("resolved", resolved);
                cbs.put("rejected", rejected);
                this.callbacksMap.put(id, cbs);
            }
            return this;
        }

        @Override
        public ServerSocket close() {
            this.transport.close();
            return this;
        }

        @Override
        public ServerSocket tag(String ... names) {
            this.tags.addAll(Arrays.asList(names));
            return this;
        }

        @Override
        public ServerSocket untag(String ... names) {
            this.tags.removeAll(Arrays.asList(names));
            return this;
        }

        public <T> T unwrap(Class<T> clazz) {
            return (T)this.transport.unwrap(clazz);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.id() == null ? 0 : this.id().hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            DefaultServerSocket other = (DefaultServerSocket)obj;
            return !(this.id() == null ? other.id() != null : !this.id().equals(other.id()));
        }

        class HeartbeatHelper {
            final long delay;
            AtomicReference<Timer> timer = new AtomicReference();

            HeartbeatHelper(long delay) {
                this.delay = delay;
                this.timer.set(this.createTimer());
                DefaultServerSocket.this.on("heartbeat", new VoidAction(){

                    public void on() {
                        HeartbeatHelper.this.timer.getAndSet(HeartbeatHelper.this.createTimer()).cancel();
                        DefaultServerSocket.this.send("heartbeat");
                    }
                });
                DefaultServerSocket.this.on("close", new VoidAction(){

                    public void on() {
                        HeartbeatHelper.this.timer.get().cancel();
                    }
                });
            }

            Timer createTimer() {
                Timer timer = new Timer(true);
                timer.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        DefaultServerSocket.this.close();
                    }
                }, this.delay);
                return timer;
            }
        }
    }

    private class LongpollTransport
    extends HttpTransport {
        AtomicReference<ServerHttpExchange> httpRef;
        AtomicBoolean aborted;
        AtomicBoolean ended;
        AtomicBoolean written;
        Set<String> buffer;
        AtomicReference<Timer> closeTimer;

        LongpollTransport(Map<String, String> params, ServerHttpExchange http) {
            super(params, http);
            this.httpRef = new AtomicReference();
            this.aborted = new AtomicBoolean();
            this.ended = new AtomicBoolean();
            this.written = new AtomicBoolean();
            this.buffer = new CopyOnWriteArraySet<String>();
            this.closeTimer = new AtomicReference();
            this.refresh(http);
        }

        void refresh(ServerHttpExchange http) {
            final Map parameters = DefaultServer.this.parseURI(http.uri());
            http.closeAction((Action)new VoidAction(){

                public void on() {
                    LongpollTransport.this.ended.set(true);
                    if (((String)parameters.get("when")).equals("poll") && !LongpollTransport.this.written.get()) {
                        LongpollTransport.this.closeActions.fire();
                    } else {
                        Timer timer = new Timer(true);
                        timer.schedule(new TimerTask(){

                            @Override
                            public void run() {
                                LongpollTransport.this.closeActions.fire();
                            }
                        }, 2000L);
                        LongpollTransport.this.closeTimer.set(timer);
                    }
                }
            }).setHeader("content-type", "text/" + (((String)this.params.get("transport")).equals("longpolljsonp") ? "javascript" : "plain") + "; charset=utf-8");
            if (((String)parameters.get("when")).equals("open")) {
                http.close();
            } else {
                this.httpRef.set(http);
                this.ended.set(false);
                this.written.set(false);
                Timer timer = this.closeTimer.getAndSet(null);
                if (timer != null) {
                    timer.cancel();
                }
                if (this.aborted.get()) {
                    http.close();
                    return;
                }
                if (parameters.containsKey("lastEventIds")) {
                    String[] lastEventIds;
                    for (String eventId : lastEventIds = ((String)parameters.get("lastEventIds")).split(",")) {
                        for (String message : this.buffer) {
                            if (!eventId.equals(this.findEventId(message))) continue;
                            this.buffer.remove(message);
                        }
                    }
                    if (!this.buffer.isEmpty()) {
                        Iterator<String> iterator = this.buffer.iterator();
                        String string = iterator.next();
                        while (iterator.hasNext()) {
                            string = string + "," + iterator.next();
                        }
                        this.send("[" + string + "]");
                    }
                }
            }
        }

        private String findEventId(String text) {
            Matcher matcher = Pattern.compile("\"id\":\"([^\"]+)\"").matcher(text);
            matcher.find();
            return matcher.group(1);
        }

        @Override
        synchronized void send(String data) {
            ServerHttpExchange http;
            if (!data.startsWith("[")) {
                this.buffer.add(data);
            }
            if ((http = (ServerHttpExchange)this.httpRef.getAndSet(null)) != null && !this.ended.get()) {
                String payload;
                this.written.set(true);
                if (((String)this.params.get("transport")).equals("longpolljsonp")) {
                    try {
                        payload = (String)this.params.get("callback") + "(" + new ObjectMapper().writeValueAsString((Object)data) + ");";
                    }
                    catch (JsonProcessingException e) {
                        throw new RuntimeException(e);
                    }
                } else {
                    payload = data;
                }
                http.close(payload);
            }
        }

        @Override
        synchronized void close() {
            this.aborted.set(true);
            ServerHttpExchange http = this.httpRef.getAndSet(null);
            if (http != null && !this.ended.get()) {
                http.close();
            }
        }
    }

    private class StreamTransport
    extends HttpTransport {
        StreamTransport(Map<String, String> params, ServerHttpExchange http) {
            super(params, http);
            http.closeAction((Action)new VoidAction(){

                public void on() {
                    StreamTransport.this.closeActions.fire();
                }
            }).setHeader("content-type", "text/" + (params.get("transport").equals("sse") ? "event-stream" : "plain") + "; charset=utf-8").write(text2KB + "\n");
        }

        @Override
        synchronized void send(String data) {
            String payload = "data: " + data + "\n\n";
            this.http.write(payload);
        }

        @Override
        synchronized void close() {
            this.http.close();
        }
    }

    private abstract class HttpTransport
    extends Transport {
        final ServerHttpExchange http;

        HttpTransport(Map<String, String> params, ServerHttpExchange http) {
            super(params);
            this.http = http;
        }

        @Override
        String uri() {
            return this.http.uri();
        }

        public <T> T unwrap(Class<T> clazz) {
            return (T)this.http.unwrap(clazz);
        }
    }

    private class WebSocketTransport
    extends Transport {
        final ServerWebSocket ws;

        WebSocketTransport(Map<String, String> params, ServerWebSocket ws) {
            super(params);
            this.ws = ws;
            ws.closeAction((Action)new VoidAction(){

                public void on() {
                    WebSocketTransport.this.closeActions.fire();
                }
            }).messageAction((Action)new Action<Data>(){

                public void on(Data data) {
                    WebSocketTransport.this.messageActions.fire(data.as(String.class));
                }
            });
        }

        @Override
        String uri() {
            return this.ws.uri();
        }

        @Override
        synchronized void send(String data) {
            this.ws.send(data);
        }

        @Override
        synchronized void close() {
            this.ws.close();
        }

        public <T> T unwrap(Class<T> clazz) {
            return (T)this.ws.unwrap(clazz);
        }
    }

    private abstract class Transport
    implements Wrapper {
        final Map<String, String> params;
        Actions<String> messageActions = new ConcurrentActions();
        Actions<Void> closeActions = new ConcurrentActions();

        Transport(Map<String, String> params) {
            this.params = params;
        }

        abstract String uri();

        abstract void send(String var1);

        abstract void close();
    }
}

