/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.vibe;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.atmosphere.vibe.HeartbeatFailedException;
import org.atmosphere.vibe.Sentence;
import org.atmosphere.vibe.Server;
import org.atmosphere.vibe.ServerSocket;
import org.atmosphere.vibe.platform.action.Action;
import org.atmosphere.vibe.platform.action.Actions;
import org.atmosphere.vibe.platform.action.ConcurrentActions;
import org.atmosphere.vibe.platform.action.VoidAction;
import org.atmosphere.vibe.platform.http.HttpStatus;
import org.atmosphere.vibe.platform.http.ServerHttpExchange;
import org.atmosphere.vibe.platform.ws.ServerWebSocket;
import org.atmosphere.vibe.transport.ServerTransport;
import org.atmosphere.vibe.transport.http.BaseHttpServerTransport;
import org.atmosphere.vibe.transport.http.HttpLongpollServerTransport;
import org.atmosphere.vibe.transport.http.HttpStreamServerTransport;
import org.atmosphere.vibe.transport.ws.WebSocketServerTransport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultServer
implements Server {
    private final Logger log = LoggerFactory.getLogger(DefaultServer.class);
    private Set<ServerSocket> sockets = new CopyOnWriteArraySet<ServerSocket>();
    private int heartbeat = 20000;
    private int _heartbeat = 5000;
    private Actions<ServerSocket> socketActions = new ConcurrentActions().add((Action)new Action<ServerSocket>(){

        public void on(ServerSocket s) {
            final DefaultServerSocket socket = (DefaultServerSocket)s;
            DefaultServer.this.sockets.add(socket);
            socket.on("close", new VoidAction(){

                public void on() {
                    DefaultServer.this.sockets.remove(socket);
                }
            });
            socket.setHeartbeat(DefaultServer.this.heartbeat);
        }
    });
    private Action<ServerTransport> transportAction = new Action<ServerTransport>(){

        public void on(ServerTransport transport) {
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
            map.put("heartbeat", "" + DefaultServer.this.heartbeat);
            map.put("_heartbeat", "" + DefaultServer.this._heartbeat);
            DefaultServer.this.socketActions.fire((Object)new DefaultServerSocket(transport, map));
        }
    };
    private Action<ServerHttpExchange> httpAction = new Action<ServerHttpExchange>(){
        Map<String, BaseHttpServerTransport> transports = new ConcurrentHashMap<String, BaseHttpServerTransport>();

        public void on(final ServerHttpExchange http) {
            final Map<String, String> params = BaseHttpServerTransport.parseQuery(http.uri());
            block4 : switch (http.method()) {
                case "GET": {
                    this.setNocache(http);
                    this.setCors(http);
                    switch (params.get("when")) {
                        case "open": {
                            String transportName = params.get("transport");
                            final BaseHttpServerTransport transport = this.createTransport(transportName, http);
                            if (transport != null) {
                                this.transports.put(transport.id(), transport);
                                transport.closeAction((Action<Void>)new VoidAction(){

                                    public void on() {
                                        transports.remove(transport.id());
                                    }
                                });
                                DefaultServer.this.transportAction.on((Object)transport);
                                break block4;
                            }
                            DefaultServer.this.log.error("Transport, {}, is not implemented", (Object)transportName);
                            http.setStatus(HttpStatus.NOT_IMPLEMENTED).end();
                            break block4;
                        }
                        case "poll": {
                            String id = params.get("id");
                            BaseHttpServerTransport transport = this.transports.get(id);
                            if (transport != null && transport instanceof HttpLongpollServerTransport) {
                                ((HttpLongpollServerTransport)transport).refresh(http);
                                break block4;
                            }
                            DefaultServer.this.log.error("Long polling transport#{} is not found", (Object)id);
                            http.setStatus(HttpStatus.INTERNAL_SERVER_ERROR).end();
                            break block4;
                        }
                        case "abort": {
                            String id = params.get("id");
                            BaseHttpServerTransport transport = this.transports.get(id);
                            if (transport != null) {
                                transport.close();
                            }
                            http.setHeader("content-type", "text/javascript; charset=utf-8").end();
                            break block4;
                        }
                    }
                    DefaultServer.this.log.error("when, {}, is not supported", (Object)params.get("when"));
                    http.setStatus(HttpStatus.NOT_IMPLEMENTED).end();
                    break;
                }
                case "POST": {
                    this.setNocache(http);
                    this.setCors(http);
                    http.bodyAction((Action)new Action<String>(){

                        public void on(String body) {
                            String data = body.substring("data=".length());
                            String id = (String)params.get("id");
                            BaseHttpServerTransport transport = transports.get(id);
                            if (transport != null) {
                                transport.handleText(data);
                            } else {
                                DefaultServer.this.log.error("A POST message arrived but no transport#{} is found", (Object)id);
                                http.setStatus(HttpStatus.INTERNAL_SERVER_ERROR);
                            }
                            http.end();
                        }
                    }).read();
                    break;
                }
                default: {
                    DefaultServer.this.log.error("HTTP method, {}, is not supported", (Object)http.method());
                    http.setStatus(HttpStatus.METHOD_NOT_ALLOWED).end();
                }
            }
        }

        private void setNocache(ServerHttpExchange http) {
            http.setHeader("cache-control", "no-cache, no-store, must-revalidate").setHeader("pragma", "no-cache").setHeader("expires", "0");
        }

        private void setCors(ServerHttpExchange http) {
            String origin = http.header("origin");
            http.setHeader("access-control-allow-origin", origin != null ? origin : "*").setHeader("access-control-allow-credentials", "true");
        }

        private BaseHttpServerTransport createTransport(String transportName, ServerHttpExchange http) {
            switch (transportName) {
                case "stream": {
                    return new HttpStreamServerTransport(http);
                }
                case "longpoll": {
                    return new HttpLongpollServerTransport(http);
                }
            }
            return null;
        }
    };
    private Action<ServerWebSocket> wsAction = new Action<ServerWebSocket>(){

        public void on(ServerWebSocket ws) {
            DefaultServer.this.transportAction.on((Object)new WebSocketServerTransport(ws));
        }
    };

    @Override
    public Sentence all() {
        return new Sentence(new Action<Action<ServerSocket>>(){

            public void on(Action<ServerSocket> action) {
                DefaultServer.this.all(action);
            }
        });
    }

    @Override
    public Server all(Action<ServerSocket> action) {
        for (ServerSocket socket : this.sockets) {
            action.on((Object)socket);
        }
        return this;
    }

    @Override
    public Sentence byTag(final String ... names) {
        return new Sentence(new Action<Action<ServerSocket>>(){

            public void on(Action<ServerSocket> action) {
                DefaultServer.this.byTag(names, action);
            }
        });
    }

    @Override
    public Server byTag(String name, Action<ServerSocket> action) {
        return this.byTag(new String[]{name}, action);
    }

    @Override
    public Server byTag(String[] names, Action<ServerSocket> action) {
        List<String> nameList = Arrays.asList(names);
        for (ServerSocket socket : this.sockets) {
            if (!socket.tags().containsAll(nameList)) continue;
            action.on((Object)socket);
        }
        return this;
    }

    @Override
    public Server socketAction(Action<ServerSocket> action) {
        this.socketActions.add(action);
        return this;
    }

    @Override
    public Action<ServerHttpExchange> httpAction() {
        return this.httpAction;
    }

    @Override
    public Action<ServerWebSocket> wsAction() {
        return this.wsAction;
    }

    public void setHeartbeat(int heartbeat) {
        this.heartbeat = heartbeat;
    }

    public void set_heartbeat(int _heartbeat) {
        this._heartbeat = _heartbeat;
    }

    private static class DefaultServerSocket
    implements ServerSocket {
        final ServerTransport transport;
        ObjectMapper mapper = new ObjectMapper();
        AtomicInteger eventId = new AtomicInteger();
        Set<String> tags = new CopyOnWriteArraySet<String>();
        ConcurrentMap<String, Actions<Object>> actionsMap = new ConcurrentHashMap<String, Actions<Object>>();
        ConcurrentMap<String, Map<String, Action<Object>>> callbacksMap = new ConcurrentHashMap<String, Map<String, Action<Object>>>();
        AtomicReference<Timer> heartbeatTimer = new AtomicReference();

        DefaultServerSocket(ServerTransport transport, Map<String, String> query) {
            this.transport = transport;
            this.actionsMap.put("error", (Actions<Object>)new ConcurrentActions());
            transport.errorAction(new Action<Throwable>(){

                public void on(Throwable throwable) {
                    ((Actions)DefaultServerSocket.this.actionsMap.get("error")).fire((Object)throwable);
                }
            });
            this.actionsMap.put("close", (Actions<Object>)new ConcurrentActions(new Actions.Options().once(true).memory(true)));
            transport.closeAction((Action<Void>)new VoidAction(){

                public void on() {
                    ((Actions)DefaultServerSocket.this.actionsMap.get("close")).fire();
                }
            });
            transport.textAction(new Action<String>(){

                public void on(String text) {
                    final Map<String, Object> event = DefaultServerSocket.this.parseEvent(text);
                    Actions actions = (Actions)DefaultServerSocket.this.actionsMap.get(event.get("type"));
                    if (actions != null) {
                        if (((Boolean)event.get("reply")).booleanValue()) {
                            final AtomicBoolean sent = new AtomicBoolean();
                            actions.fire((Object)new ServerSocket.Reply<Object>(){

                                @Override
                                public Object data() {
                                    return event.get("data");
                                }

                                @Override
                                public void resolve() {
                                    this.resolve(null);
                                }

                                @Override
                                public void resolve(Object value) {
                                    this.sendReply(value, false);
                                }

                                @Override
                                public void reject() {
                                    this.reject(null);
                                }

                                @Override
                                public void reject(Object value) {
                                    this.sendReply(value, true);
                                }

                                private void sendReply(Object value, boolean exception) {
                                    if (sent.compareAndSet(false, true)) {
                                        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
                                        result.put("id", event.get("id"));
                                        result.put("data", value);
                                        result.put("exception", exception);
                                        DefaultServerSocket.this.send("reply", result);
                                    }
                                }
                            });
                        } else {
                            actions.fire(event.get("data"));
                        }
                    }
                }
            });
            this.on("reply", new Action<Map<String, Object>>(){

                public void on(Map<String, Object> info) {
                    Map callbacks = (Map)DefaultServerSocket.this.callbacksMap.remove(info.get("id"));
                    Action action = (Boolean)info.get("exception") != false ? (Action)callbacks.get("rejected") : (Action)callbacks.get("resolved");
                    action.on(info.get("data"));
                }
            });
            transport.send("?" + BaseHttpServerTransport.formatQuery(query));
        }

        @Override
        public String uri() {
            return this.transport.uri();
        }

        @Override
        public Set<String> tags() {
            return this.tags;
        }

        @Override
        public <T> ServerSocket on(String event, Action<T> action) {
            ConcurrentActions value;
            ConcurrentActions actions = (ConcurrentActions)this.actionsMap.get(event);
            if (actions == null && (actions = this.actionsMap.putIfAbsent(event, (Actions<Object>)(value = new ConcurrentActions()))) == null) {
                actions = value;
            }
            actions.add(action);
            return this;
        }

        @Override
        public ServerSocket closeAction(Action<Void> action) {
            return this.on("close", action);
        }

        @Override
        public ServerSocket errorAction(Action<Throwable> action) {
            return this.on("error", action);
        }

        @Override
        public <T> ServerSocket off(String event, Action<T> action) {
            Actions actions = (Actions)this.actionsMap.get(event);
            if (actions != null) {
                actions.remove(action);
            }
            return this;
        }

        @Override
        public ServerSocket send(String event) {
            return this.send(event, null);
        }

        @Override
        public ServerSocket send(String event, Object data) {
            return this.send(event, data, null);
        }

        @Override
        public <T> ServerSocket send(String type, Object data, Action<T> resolved) {
            return this.send(type, data, resolved, null);
        }

        @Override
        public <T, U> ServerSocket send(String type, Object data, Action<T> resolved, Action<U> rejected) {
            String id = "" + this.eventId.incrementAndGet();
            LinkedHashMap<String, Object> event = new LinkedHashMap<String, Object>();
            event.put("id", id);
            event.put("type", type);
            event.put("data", data);
            event.put("reply", resolved != null || rejected != null);
            String text = this.stringifyEvent(event);
            this.transport.send(text);
            if (resolved != null || rejected != null) {
                LinkedHashMap<String, Object> cbs = new LinkedHashMap<String, Object>();
                cbs.put("resolved", resolved);
                cbs.put("rejected", rejected);
                this.callbacksMap.put(id, cbs);
            }
            return this;
        }

        @Override
        public void close() {
            this.transport.close();
        }

        @Override
        public ServerSocket tag(String ... names) {
            this.tags.addAll(Arrays.asList(names));
            return this;
        }

        @Override
        public ServerSocket untag(String ... names) {
            this.tags.removeAll(Arrays.asList(names));
            return this;
        }

        @Override
        public <T> T unwrap(Class<T> clazz) {
            return ServerTransport.class.isAssignableFrom(clazz) ? (T)clazz.cast(this.transport) : null;
        }

        Map<String, Object> parseEvent(String text) {
            try {
                return (Map)this.mapper.readValue(text, (TypeReference)new TypeReference<Map<String, Object>>(){});
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        String stringifyEvent(Map<String, Object> event) {
            try {
                return this.mapper.writeValueAsString(event);
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
        }

        void setHeartbeat(final int heartbeat) {
            this.heartbeatTimer.set(this.createCloseTimer(heartbeat));
            this.on("heartbeat", (Action)new VoidAction(){

                public void on() {
                    DefaultServerSocket.this.heartbeatTimer.getAndSet(DefaultServerSocket.this.createCloseTimer(heartbeat)).cancel();
                    DefaultServerSocket.this.send("heartbeat");
                }
            });
            this.on("close", (Action)new VoidAction(){

                public void on() {
                    DefaultServerSocket.this.heartbeatTimer.get().cancel();
                }
            });
        }

        Timer createCloseTimer(int heartbeat) {
            Timer timer = new Timer(true);
            timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    ((Actions)DefaultServerSocket.this.actionsMap.get("error")).fire((Object)new HeartbeatFailedException());
                    DefaultServerSocket.this.close();
                }
            }, heartbeat);
            return timer;
        }
    }
}

