/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.vibe.transport.http;

import java.nio.CharBuffer;
import java.util.LinkedHashMap;
import org.atmosphere.vibe.platform.action.Action;
import org.atmosphere.vibe.platform.action.VoidAction;
import org.atmosphere.vibe.platform.http.ServerHttpExchange;
import org.atmosphere.vibe.transport.http.BaseHttpServerTransport;

public class HttpStreamServerTransport
extends BaseHttpServerTransport {
    private static final String text2KB = CharBuffer.allocate(2048).toString().replace('\u0000', ' ');

    public HttpStreamServerTransport(ServerHttpExchange http) {
        super(http);
        LinkedHashMap<String, String> query = new LinkedHashMap<String, String>();
        query.put("id", this.id);
        http.finishAction((Action)new VoidAction(){

            public void on() {
                HttpStreamServerTransport.this.closeActions.fire();
            }
        }).errorAction((Action)new Action<Throwable>(){

            public void on(Throwable throwable) {
                HttpStreamServerTransport.this.errorActions.fire((Object)throwable);
            }
        }).closeAction((Action)new VoidAction(){

            public void on() {
                HttpStreamServerTransport.this.closeActions.fire();
            }
        }).setHeader("content-type", "text/" + ("true".equals(this.params.get("sse")) ? "event-stream" : "plain") + "; charset=utf-8").write(text2KB + "\ndata: ?" + HttpStreamServerTransport.formatQuery(query) + "\n\n");
    }

    @Override
    public synchronized void doSend(String data) {
        String payload = "";
        for (String line : data.split("\r\n|\r|\n")) {
            payload = payload + "data: " + line + "\n";
        }
        payload = payload + "\n";
        this.http.write(payload);
    }

    @Override
    public synchronized void doClose() {
        this.http.end();
    }
}

