/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.vibe.transport.ws;

import org.atmosphere.vibe.platform.action.Action;
import org.atmosphere.vibe.platform.action.Actions;
import org.atmosphere.vibe.platform.action.ConcurrentActions;
import org.atmosphere.vibe.platform.action.VoidAction;
import org.atmosphere.vibe.platform.ws.ServerWebSocket;
import org.atmosphere.vibe.transport.BaseServerTransport;
import org.atmosphere.vibe.transport.ServerTransport;
import org.atmosphere.vibe.transport.TransportServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketTransportServer
implements TransportServer<ServerWebSocket> {
    private final Logger log = LoggerFactory.getLogger(WebSocketTransportServer.class);
    private Actions<ServerTransport> transportActions = new ConcurrentActions().add((Action)new Action<ServerTransport>(){

        public void on(final ServerTransport transport) {
            WebSocketTransportServer.this.log.trace("{}'s request has opened", (Object)transport);
            transport.closeAction((Action<Void>)new VoidAction(){

                public void on() {
                    WebSocketTransportServer.this.log.trace("{}'s request has been closed", (Object)transport);
                }
            });
        }
    });

    public void on(ServerWebSocket ws) {
        this.transportActions.fire((Object)new DefaultTransport(ws));
    }

    public WebSocketTransportServer transportAction(Action<ServerTransport> action) {
        this.transportActions.add(action);
        return this;
    }

    private static class DefaultTransport
    extends BaseServerTransport {
        private final ServerWebSocket ws;

        public DefaultTransport(ServerWebSocket ws) {
            this.ws = ws;
            ws.errorAction((Action)new Action<Throwable>(){

                public void on(Throwable throwable) {
                    DefaultTransport.this.errorActions.fire((Object)throwable);
                }
            }).closeAction((Action)new VoidAction(){

                public void on() {
                    DefaultTransport.this.closeActions.fire();
                }
            }).textAction((Action)new Action<String>(){

                public void on(String data) {
                    DefaultTransport.this.textActions.fire((Object)data);
                }
            });
        }

        @Override
        public String uri() {
            return this.ws.uri();
        }

        @Override
        public synchronized void doSend(String data) {
            this.ws.send(data);
        }

        @Override
        public synchronized void doClose() {
            this.ws.close();
        }

        @Override
        public <T> T unwrap(Class<T> clazz) {
            return ServerWebSocket.class.isAssignableFrom(clazz) ? (T)clazz.cast(this.ws) : null;
        }
    }
}

