/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.vibe;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.atmosphere.vibe.HeartbeatFailedException;
import org.atmosphere.vibe.Sentence;
import org.atmosphere.vibe.Server;
import org.atmosphere.vibe.ServerSocket;
import org.atmosphere.vibe.platform.action.Action;
import org.atmosphere.vibe.platform.action.Actions;
import org.atmosphere.vibe.platform.action.ConcurrentActions;
import org.atmosphere.vibe.platform.action.VoidAction;
import org.atmosphere.vibe.transport.ServerTransport;
import org.atmosphere.vibe.transport.http.HttpTransportServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultServer
implements Server {
    private final Logger log = LoggerFactory.getLogger(DefaultServer.class);
    private Set<ServerSocket> sockets = new CopyOnWriteArraySet<ServerSocket>();
    private int heartbeat = 20000;
    private int _heartbeat = 5000;
    private Actions<ServerSocket> socketActions = new ConcurrentActions().add((Action)new Action<ServerSocket>(){

        public void on(final ServerSocket socket) {
            DefaultServer.this.log.trace("{}'s request has opened", (Object)socket);
            DefaultServer.this.sockets.add(socket);
            socket.closeAction((Action<Void>)new VoidAction(){

                public void on() {
                    DefaultServer.this.log.trace("{}'s request has been closed", (Object)socket);
                    DefaultServer.this.sockets.remove(socket);
                }
            });
        }
    });

    public void on(ServerTransport transport) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("heartbeat", "" + this.heartbeat);
        map.put("_heartbeat", "" + this._heartbeat);
        this.socketActions.fire((Object)new DefaultServerSocket(transport, map));
    }

    @Override
    public Sentence all() {
        return new Sentence(new Action<Action<ServerSocket>>(){

            public void on(Action<ServerSocket> action) {
                DefaultServer.this.all(action);
            }
        });
    }

    @Override
    public Server all(Action<ServerSocket> action) {
        for (ServerSocket socket : this.sockets) {
            action.on((Object)socket);
        }
        return this;
    }

    @Override
    public Sentence byTag(final String ... names) {
        return new Sentence(new Action<Action<ServerSocket>>(){

            public void on(Action<ServerSocket> action) {
                DefaultServer.this.byTag(names, action);
            }
        });
    }

    @Override
    public Server byTag(String name, Action<ServerSocket> action) {
        return this.byTag(new String[]{name}, action);
    }

    @Override
    public Server byTag(String[] names, Action<ServerSocket> action) {
        List<String> nameList = Arrays.asList(names);
        for (ServerSocket socket : this.sockets) {
            if (!socket.tags().containsAll(nameList)) continue;
            action.on((Object)socket);
        }
        return this;
    }

    @Override
    public Server socketAction(Action<ServerSocket> action) {
        this.socketActions.add(action);
        return this;
    }

    public void setHeartbeat(int heartbeat) {
        this.heartbeat = heartbeat;
    }

    public void set_heartbeat(int _heartbeat) {
        this._heartbeat = _heartbeat;
    }

    private static class DefaultServerSocket
    implements ServerSocket {
        private final ServerTransport transport;
        private ObjectMapper mapper = new ObjectMapper();
        private AtomicInteger eventId = new AtomicInteger();
        private Set<String> tags = new CopyOnWriteArraySet<String>();
        private ConcurrentMap<String, Actions<Object>> actionsMap = new ConcurrentHashMap<String, Actions<Object>>();
        private ConcurrentMap<String, Map<String, Action<Object>>> callbacksMap = new ConcurrentHashMap<String, Map<String, Action<Object>>>();
        private AtomicReference<Timer> heartbeatTimer = new AtomicReference();

        public DefaultServerSocket(ServerTransport transport, Map<String, String> query) {
            this.transport = transport;
            this.actionsMap.put("error", (Actions<Object>)new ConcurrentActions());
            transport.errorAction(new Action<Throwable>(){

                public void on(Throwable throwable) {
                    ((Actions)DefaultServerSocket.this.actionsMap.get("error")).fire((Object)throwable);
                }
            });
            this.actionsMap.put("close", (Actions<Object>)new ConcurrentActions(new Actions.Options().once(true).memory(true)));
            transport.closeAction((Action<Void>)new VoidAction(){

                public void on() {
                    ((Actions)DefaultServerSocket.this.actionsMap.get("close")).fire();
                }
            });
            transport.textAction(new Action<String>(){

                public void on(String text) {
                    final Map event = DefaultServerSocket.this.parseEvent(text);
                    Actions actions = (Actions)DefaultServerSocket.this.actionsMap.get(event.get("type"));
                    if (actions != null) {
                        if (((Boolean)event.get("reply")).booleanValue()) {
                            final AtomicBoolean sent = new AtomicBoolean();
                            actions.fire((Object)new ServerSocket.Reply<Object>(){

                                @Override
                                public Object data() {
                                    return event.get("data");
                                }

                                @Override
                                public void resolve() {
                                    this.resolve(null);
                                }

                                @Override
                                public void resolve(Object value) {
                                    this.sendReply(value, false);
                                }

                                @Override
                                public void reject() {
                                    this.reject(null);
                                }

                                @Override
                                public void reject(Object value) {
                                    this.sendReply(value, true);
                                }

                                private void sendReply(Object value, boolean exception) {
                                    if (sent.compareAndSet(false, true)) {
                                        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
                                        result.put("id", event.get("id"));
                                        result.put("data", value);
                                        result.put("exception", exception);
                                        DefaultServerSocket.this.send("reply", result);
                                    }
                                }
                            });
                        } else {
                            actions.fire(event.get("data"));
                        }
                    }
                }
            });
            this.on("reply", new Action<Map<String, Object>>(){

                public void on(Map<String, Object> info) {
                    Map callbacks = (Map)DefaultServerSocket.this.callbacksMap.remove(info.get("id"));
                    Action action = (Boolean)info.get("exception") != false ? (Action)callbacks.get("rejected") : (Action)callbacks.get("resolved");
                    action.on(info.get("data"));
                }
            });
            final int heartbeat = Integer.parseInt(query.get("heartbeat"));
            this.heartbeatTimer.set(this.createCloseTimer(heartbeat));
            this.on("heartbeat", (Action)new VoidAction(){

                public void on() {
                    DefaultServerSocket.this.heartbeatTimer.getAndSet(DefaultServerSocket.this.createCloseTimer(heartbeat)).cancel();
                    DefaultServerSocket.this.send("heartbeat");
                }
            });
            this.on("close", (Action)new VoidAction(){

                public void on() {
                    ((Timer)DefaultServerSocket.this.heartbeatTimer.get()).cancel();
                }
            });
            transport.send("?" + HttpTransportServer.formatQuery(query));
        }

        @Override
        public String uri() {
            return this.transport.uri();
        }

        @Override
        public Set<String> tags() {
            return this.tags;
        }

        @Override
        public <T> ServerSocket on(String event, Action<T> action) {
            ConcurrentActions value;
            ConcurrentActions actions = (ConcurrentActions)this.actionsMap.get(event);
            if (actions == null && (actions = this.actionsMap.putIfAbsent(event, (Actions<Object>)(value = new ConcurrentActions()))) == null) {
                actions = value;
            }
            actions.add(action);
            return this;
        }

        @Override
        public ServerSocket closeAction(Action<Void> action) {
            return this.on("close", action);
        }

        @Override
        public ServerSocket errorAction(Action<Throwable> action) {
            return this.on("error", action);
        }

        @Override
        public <T> ServerSocket off(String event, Action<T> action) {
            Actions actions = (Actions)this.actionsMap.get(event);
            if (actions != null) {
                actions.remove(action);
            }
            return this;
        }

        @Override
        public ServerSocket send(String event) {
            return this.send(event, null);
        }

        @Override
        public ServerSocket send(String event, Object data) {
            return this.send(event, data, null);
        }

        @Override
        public <T> ServerSocket send(String type, Object data, Action<T> resolved) {
            return this.send(type, data, resolved, null);
        }

        @Override
        public <T, U> ServerSocket send(String type, Object data, Action<T> resolved, Action<U> rejected) {
            String id = "" + this.eventId.incrementAndGet();
            LinkedHashMap<String, Object> event = new LinkedHashMap<String, Object>();
            event.put("id", id);
            event.put("type", type);
            event.put("data", data);
            event.put("reply", resolved != null || rejected != null);
            String text = this.stringifyEvent(event);
            this.transport.send(text);
            if (resolved != null || rejected != null) {
                LinkedHashMap<String, Object> cbs = new LinkedHashMap<String, Object>();
                cbs.put("resolved", resolved);
                cbs.put("rejected", rejected);
                this.callbacksMap.put(id, cbs);
            }
            return this;
        }

        @Override
        public void close() {
            this.transport.close();
        }

        @Override
        public ServerSocket tag(String ... names) {
            this.tags.addAll(Arrays.asList(names));
            return this;
        }

        @Override
        public ServerSocket untag(String ... names) {
            this.tags.removeAll(Arrays.asList(names));
            return this;
        }

        @Override
        public <T> T unwrap(Class<T> clazz) {
            return ServerTransport.class.isAssignableFrom(clazz) ? (T)clazz.cast(this.transport) : null;
        }

        private Map<String, Object> parseEvent(String text) {
            try {
                return (Map)this.mapper.readValue(text, (TypeReference)new TypeReference<Map<String, Object>>(){});
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        private String stringifyEvent(Map<String, Object> event) {
            try {
                return this.mapper.writeValueAsString(event);
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
        }

        private Timer createCloseTimer(int heartbeat) {
            Timer timer = new Timer(true);
            timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    ((Actions)DefaultServerSocket.this.actionsMap.get("error")).fire((Object)new HeartbeatFailedException());
                    DefaultServerSocket.this.close();
                }
            }, heartbeat);
            return timer;
        }
    }
}

