/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.vibe;

import java.io.Serializable;
import org.atmosphere.vibe.AbstractServerSocket;
import org.atmosphere.vibe.ServerSocket;
import org.atmosphere.vibe.platform.action.Action;

public class Sentence
implements AbstractServerSocket<Sentence> {
    private final Action<Action<ServerSocket>> serverAction;

    Sentence(Action<Action<ServerSocket>> serverAction) {
        this.serverAction = serverAction;
    }

    @Override
    public Sentence send(String event) {
        return this.send(event, null);
    }

    @Override
    public Sentence send(String event, Object data) {
        this.execute(new SendAction(event, data));
        return this;
    }

    @Override
    public void close() {
        this.execute(new CloseAction());
    }

    @Override
    public Sentence tag(String ... names) {
        this.execute(new TagAction(names));
        return this;
    }

    @Override
    public Sentence untag(String ... names) {
        this.execute(new UntagAction(names));
        return this;
    }

    private void execute(Action<ServerSocket> action) {
        this.serverAction.on(action);
    }

    private static class UntagAction
    implements SerializableAction<ServerSocket> {
        private static final long serialVersionUID = -4173842573981245930L;
        private final String[] names;

        public UntagAction(String[] names) {
            this.names = names;
        }

        public void on(ServerSocket socket) {
            socket.untag(this.names);
        }
    }

    private static class TagAction
    implements SerializableAction<ServerSocket> {
        private static final long serialVersionUID = -7789207688974771161L;
        private final String[] names;

        public TagAction(String[] names) {
            this.names = names;
        }

        public void on(ServerSocket socket) {
            socket.tag(this.names);
        }
    }

    private static class CloseAction
    implements SerializableAction<ServerSocket> {
        private static final long serialVersionUID = 8154281469036373698L;

        private CloseAction() {
        }

        public void on(ServerSocket socket) {
            socket.close();
        }
    }

    private static class SendAction
    implements SerializableAction<ServerSocket> {
        private static final long serialVersionUID = 2178442626501531717L;
        private final String event;
        private final Object data;

        SendAction(String event, Object data) {
            this.event = event;
            this.data = data;
        }

        public void on(ServerSocket socket) {
            socket.send(this.event, this.data);
        }
    }

    private static interface SerializableAction<T>
    extends Action<T>,
    Serializable {
    }
}

