/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.vibe.server;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.atmosphere.vibe.platform.Action;
import org.atmosphere.vibe.platform.Actions;
import org.atmosphere.vibe.platform.ConcurrentActions;
import org.atmosphere.vibe.server.DefaultServer;
import org.atmosphere.vibe.server.Server;
import org.atmosphere.vibe.server.ServerSocket;

public class ClusteredServer
extends DefaultServer {
    private Actions<Map<String, Object>> publishActions = new ConcurrentActions();
    private Action<Map<String, Object>> messageAction = new Action<Map<String, Object>>(){

        public void on(Map<String, Object> map) {
            String methodName = (String)map.get("method");
            Object[] args = (Object[])map.get("args");
            switch (methodName) {
                case "all": {
                    ClusteredServer.access$001(ClusteredServer.this, (Action)args[0]);
                    break;
                }
                case "byId": {
                    ClusteredServer.access$101(ClusteredServer.this, (String)args[0], (Action)args[1]);
                    break;
                }
                case "byTag": {
                    ClusteredServer.access$201(ClusteredServer.this, (String[])args[0], (Action)args[1]);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Illegal method name in processing message: " + methodName);
                }
            }
        }
    };

    @Override
    public Server all(Action<ServerSocket> action) {
        this.publishMessage("all", action);
        return this;
    }

    @Override
    public Server byId(String id, Action<ServerSocket> action) {
        this.publishMessage("byId", id, action);
        return this;
    }

    @Override
    public Server byTag(String[] names, Action<ServerSocket> action) {
        this.publishMessage("byTag", names, action);
        return this;
    }

    private void publishMessage(String method, Object ... args) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("method", method);
        map.put("args", args);
        this.publishActions.fire(Collections.unmodifiableMap(map));
    }

    public Server publishAction(Action<Map<String, Object>> action) {
        this.publishActions.add(action);
        return this;
    }

    public Action<Map<String, Object>> messageAction() {
        return this.messageAction;
    }

    static /* synthetic */ Server access$001(ClusteredServer x0, Action x1) {
        return super.all((Action<ServerSocket>)x1);
    }

    static /* synthetic */ Server access$101(ClusteredServer x0, String x1, Action x2) {
        return super.byId(x1, (Action<ServerSocket>)x2);
    }

    static /* synthetic */ Server access$201(ClusteredServer x0, String[] x1, Action x2) {
        return super.byTag(x1, (Action<ServerSocket>)x2);
    }
}

