/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.vibe.server;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.CharBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.atmosphere.vibe.platform.Action;
import org.atmosphere.vibe.platform.Actions;
import org.atmosphere.vibe.platform.ConcurrentActions;
import org.atmosphere.vibe.platform.HttpStatus;
import org.atmosphere.vibe.platform.VoidAction;
import org.atmosphere.vibe.platform.Wrapper;
import org.atmosphere.vibe.platform.server.ServerHttpExchange;
import org.atmosphere.vibe.platform.server.ServerWebSocket;
import org.atmosphere.vibe.server.HeartbeatFailedException;
import org.atmosphere.vibe.server.Sentence;
import org.atmosphere.vibe.server.Server;
import org.atmosphere.vibe.server.ServerSocket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultServer
implements Server {
    private final Logger log = LoggerFactory.getLogger(DefaultServer.class);
    private Set<ServerSocket> sockets = new CopyOnWriteArraySet<ServerSocket>();
    private int heartbeat = 20000;
    private int _heartbeat = 5000;
    private Actions<ServerSocket> socketActions = new ConcurrentActions().add((Action)new Action<ServerSocket>(){

        public void on(ServerSocket s) {
            final DefaultServerSocket socket = (DefaultServerSocket)s;
            DefaultServer.this.sockets.add(socket);
            socket.on("close", new VoidAction(){

                public void on() {
                    DefaultServer.this.sockets.remove(socket);
                }
            });
            socket.setHeartbeat(DefaultServer.this.heartbeat);
        }
    });
    private Action<Transport> transportAction = new Action<Transport>(){

        public void on(Transport transport) {
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
            map.put("heartbeat", "" + DefaultServer.this.heartbeat);
            map.put("_heartbeat", "" + DefaultServer.this._heartbeat);
            DefaultServer.this.socketActions.fire((Object)new DefaultServerSocket(transport, map));
        }
    };
    private Map<String, HttpTransport> httpTransports = new ConcurrentHashMap<String, HttpTransport>();
    private Action<ServerHttpExchange> httpAction = new Action<ServerHttpExchange>(){

        public void on(final ServerHttpExchange http) {
            final Map params = DefaultServer.parseQuery(http.uri());
            block4 : switch (http.method()) {
                case "GET": {
                    this.setNocache(http);
                    this.setCors(http);
                    switch ((String)params.get("when")) {
                        case "open": {
                            String transportName = (String)params.get("transport");
                            final HttpTransport transport = this.createTransport(transportName, http);
                            if (transport != null) {
                                DefaultServer.this.httpTransports.put(transport.id, transport);
                                transport.closeActions.add((Action)new VoidAction(){

                                    public void on() {
                                        DefaultServer.this.httpTransports.remove(transport.id);
                                    }
                                });
                                DefaultServer.this.transportAction.on((Object)transport);
                                break block4;
                            }
                            DefaultServer.this.log.error("Transport, {}, is not implemented", (Object)transportName);
                            http.setStatus(HttpStatus.NOT_IMPLEMENTED).end();
                            break block4;
                        }
                        case "poll": {
                            String id = (String)params.get("id");
                            HttpTransport transport = (HttpTransport)DefaultServer.this.httpTransports.get(id);
                            if (transport != null && transport instanceof LongpollTransport) {
                                ((LongpollTransport)transport).refresh(http);
                                break block4;
                            }
                            DefaultServer.this.log.error("Long polling transport#{} is not found", (Object)id);
                            http.setStatus(HttpStatus.INTERNAL_SERVER_ERROR).end();
                            break block4;
                        }
                        case "abort": {
                            String id = (String)params.get("id");
                            HttpTransport transport = (HttpTransport)DefaultServer.this.httpTransports.get(id);
                            if (transport != null) {
                                transport.close();
                            }
                            http.setHeader("content-type", "text/javascript; charset=utf-8").end();
                            break block4;
                        }
                    }
                    DefaultServer.this.log.error("when, {}, is not supported", params.get("when"));
                    http.setStatus(HttpStatus.NOT_IMPLEMENTED).end();
                    break;
                }
                case "POST": {
                    this.setNocache(http);
                    this.setCors(http);
                    http.bodyAction((Action)new Action<String>(){

                        public void on(String body) {
                            String data = body.substring("data=".length());
                            String id = (String)params.get("id");
                            HttpTransport transport = (HttpTransport)DefaultServer.this.httpTransports.get(id);
                            if (transport != null) {
                                transport.messageActions.fire((Object)data);
                            } else {
                                DefaultServer.this.log.error("A POST message arrived but no transport#{} is found", (Object)id);
                                http.setStatus(HttpStatus.INTERNAL_SERVER_ERROR);
                            }
                            http.end();
                        }
                    }).read();
                    break;
                }
                default: {
                    DefaultServer.this.log.error("HTTP method, {}, is not supported", (Object)http.method());
                    http.setStatus(HttpStatus.METHOD_NOT_ALLOWED).end();
                }
            }
        }

        private void setNocache(ServerHttpExchange http) {
            http.setHeader("cache-control", "no-cache, no-store, must-revalidate").setHeader("pragma", "no-cache").setHeader("expires", "0");
        }

        private void setCors(ServerHttpExchange http) {
            String origin = http.header("origin");
            http.setHeader("access-control-allow-origin", origin != null ? origin : "*").setHeader("access-control-allow-credentials", "true");
        }

        private HttpTransport createTransport(String transportName, ServerHttpExchange http) {
            switch (transportName) {
                case "stream": {
                    return new StreamTransport(http);
                }
                case "longpoll": {
                    return new LongpollTransport(http);
                }
            }
            return null;
        }
    };
    private Action<ServerWebSocket> wsAction = new Action<ServerWebSocket>(){

        public void on(ServerWebSocket ws) {
            DefaultServer.this.transportAction.on((Object)new WebSocketTransport(ws));
        }
    };

    @Override
    public Sentence all() {
        return new Sentence(new Action<Action<ServerSocket>>(){

            public void on(Action<ServerSocket> action) {
                DefaultServer.this.all(action);
            }
        });
    }

    @Override
    public Server all(Action<ServerSocket> action) {
        for (ServerSocket socket : this.sockets) {
            action.on((Object)socket);
        }
        return this;
    }

    @Override
    public Sentence byTag(final String ... names) {
        return new Sentence(new Action<Action<ServerSocket>>(){

            public void on(Action<ServerSocket> action) {
                DefaultServer.this.byTag(names, action);
            }
        });
    }

    @Override
    public Server byTag(String name, Action<ServerSocket> action) {
        return this.byTag(new String[]{name}, action);
    }

    @Override
    public Server byTag(String[] names, Action<ServerSocket> action) {
        List<String> nameList = Arrays.asList(names);
        for (ServerSocket socket : this.sockets) {
            if (!socket.tags().containsAll(nameList)) continue;
            action.on((Object)socket);
        }
        return this;
    }

    @Override
    public Server socketAction(Action<ServerSocket> action) {
        this.socketActions.add(action);
        return this;
    }

    @Override
    public Action<ServerHttpExchange> httpAction() {
        return this.httpAction;
    }

    @Override
    public Action<ServerWebSocket> wsAction() {
        return this.wsAction;
    }

    public void setHeartbeat(int heartbeat) {
        this.heartbeat = heartbeat;
    }

    public void set_heartbeat(int _heartbeat) {
        this._heartbeat = _heartbeat;
    }

    private static Map<String, String> parseQuery(String uri) {
        String[] params;
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        String query = URI.create(uri).getQuery();
        if (query == null || query.equals("")) {
            return Collections.unmodifiableMap(map);
        }
        for (String param : params = query.split("&")) {
            try {
                String[] pair = param.split("=", 2);
                String name = URLDecoder.decode(pair[0], "UTF-8");
                if (name.equals("")) continue;
                map.put(name, pair.length > 1 ? URLDecoder.decode(pair[1], "UTF-8") : "");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return Collections.unmodifiableMap(map);
    }

    private static String stringifyQuery(Map<String, String> params) {
        StringBuilder query = new StringBuilder();
        for (Map.Entry<String, String> entry : params.entrySet()) {
            try {
                query.append(URLEncoder.encode(entry.getKey(), "UTF-8")).append("=").append(URLEncoder.encode(entry.getValue(), "UTF-8")).append("&");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return query.deleteCharAt(query.length() - 1).toString();
    }

    private static class DefaultServerSocket
    implements ServerSocket {
        final Transport transport;
        ObjectMapper mapper = new ObjectMapper();
        AtomicInteger eventId = new AtomicInteger();
        Set<String> tags = new CopyOnWriteArraySet<String>();
        ConcurrentMap<String, Actions<Object>> actionsMap = new ConcurrentHashMap<String, Actions<Object>>();
        ConcurrentMap<String, Map<String, Action<Object>>> callbacksMap = new ConcurrentHashMap<String, Map<String, Action<Object>>>();
        AtomicReference<Timer> heartbeatTimer = new AtomicReference();

        DefaultServerSocket(Transport transport, Map<String, String> map) {
            this.transport = transport;
            this.actionsMap.put("error", (Actions<Object>)new ConcurrentActions());
            transport.errorActions.add((Action)new Action<Throwable>(){

                public void on(Throwable throwable) {
                    ((Actions)DefaultServerSocket.this.actionsMap.get("error")).fire((Object)throwable);
                }
            });
            this.actionsMap.put("close", (Actions<Object>)new ConcurrentActions(new Actions.Options().once(true).memory(true)));
            transport.closeActions.add((Action)new VoidAction(){

                public void on() {
                    ((Actions)DefaultServerSocket.this.actionsMap.get("close")).fire();
                }
            });
            transport.messageActions.add((Action)new Action<String>(){

                public void on(String text) {
                    final Map<String, Object> event = DefaultServerSocket.this.parseEvent(text);
                    Actions actions = (Actions)DefaultServerSocket.this.actionsMap.get(event.get("type"));
                    if (actions != null) {
                        if (((Boolean)event.get("reply")).booleanValue()) {
                            final AtomicBoolean sent = new AtomicBoolean();
                            actions.fire((Object)new ServerSocket.Reply<Object>(){

                                @Override
                                public Object data() {
                                    return event.get("data");
                                }

                                @Override
                                public void resolve() {
                                    this.resolve(null);
                                }

                                @Override
                                public void resolve(Object value) {
                                    this.sendReply(value, false);
                                }

                                @Override
                                public void reject() {
                                    this.reject(null);
                                }

                                @Override
                                public void reject(Object value) {
                                    this.sendReply(value, true);
                                }

                                private void sendReply(Object value, boolean exception) {
                                    if (sent.compareAndSet(false, true)) {
                                        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
                                        result.put("id", event.get("id"));
                                        result.put("data", value);
                                        result.put("exception", exception);
                                        DefaultServerSocket.this.send("reply", result);
                                    }
                                }
                            });
                        } else {
                            actions.fire(event.get("data"));
                        }
                    }
                }
            });
            this.on("reply", new Action<Map<String, Object>>(){

                public void on(Map<String, Object> info) {
                    Map cbs = (Map)DefaultServerSocket.this.callbacksMap.remove(info.get("id"));
                    Action action = (Boolean)info.get("exception") != false ? (Action)cbs.get("rejected") : (Action)cbs.get("resolved");
                    action.on(info.get("data"));
                }
            });
            transport.handshake(map);
        }

        @Override
        public String uri() {
            return this.transport.uri();
        }

        @Override
        public Set<String> tags() {
            return this.tags;
        }

        @Override
        public <T> ServerSocket on(String event, Action<T> action) {
            ConcurrentActions value;
            ConcurrentActions actions = (ConcurrentActions)this.actionsMap.get(event);
            if (actions == null && (actions = this.actionsMap.putIfAbsent(event, (Actions<Object>)(value = new ConcurrentActions()))) == null) {
                actions = value;
            }
            actions.add(action);
            return this;
        }

        @Override
        public ServerSocket closeAction(Action<Void> action) {
            return this.on("close", action);
        }

        @Override
        public ServerSocket errorAction(Action<Throwable> action) {
            return this.on("error", action);
        }

        @Override
        public <T> ServerSocket off(String event, Action<T> action) {
            Actions actions = (Actions)this.actionsMap.get(event);
            if (actions != null) {
                actions.remove(action);
            }
            return this;
        }

        @Override
        public ServerSocket send(String event) {
            return this.send(event, null);
        }

        @Override
        public ServerSocket send(String event, Object data) {
            return this.send(event, data, null);
        }

        @Override
        public <T> ServerSocket send(String type, Object data, Action<T> resolved) {
            return this.send(type, data, resolved, null);
        }

        @Override
        public <T, U> ServerSocket send(String type, Object data, Action<T> resolved, Action<U> rejected) {
            String id = "" + this.eventId.incrementAndGet();
            LinkedHashMap<String, Object> event = new LinkedHashMap<String, Object>();
            event.put("id", id);
            event.put("type", type);
            event.put("data", data);
            event.put("reply", resolved != null || rejected != null);
            String text = this.stringifyEvent(event);
            this.transport.send(text);
            if (resolved != null || rejected != null) {
                LinkedHashMap<String, Object> cbs = new LinkedHashMap<String, Object>();
                cbs.put("resolved", resolved);
                cbs.put("rejected", rejected);
                this.callbacksMap.put(id, cbs);
            }
            return this;
        }

        @Override
        public void close() {
            this.transport.close();
        }

        @Override
        public ServerSocket tag(String ... names) {
            this.tags.addAll(Arrays.asList(names));
            return this;
        }

        @Override
        public ServerSocket untag(String ... names) {
            this.tags.removeAll(Arrays.asList(names));
            return this;
        }

        public <T> T unwrap(Class<T> clazz) {
            return (T)this.transport.unwrap(clazz);
        }

        Map<String, Object> parseEvent(String text) {
            try {
                return (Map)this.mapper.readValue(text, (TypeReference)new TypeReference<Map<String, Object>>(){});
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        String stringifyEvent(Map<String, Object> event) {
            try {
                return this.mapper.writeValueAsString(event);
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
        }

        void setHeartbeat(final int heartbeat) {
            this.heartbeatTimer.set(this.createCloseTimer(heartbeat));
            this.on("heartbeat", (Action)new VoidAction(){

                public void on() {
                    DefaultServerSocket.this.heartbeatTimer.getAndSet(DefaultServerSocket.this.createCloseTimer(heartbeat)).cancel();
                    DefaultServerSocket.this.send("heartbeat");
                }
            });
            this.on("close", (Action)new VoidAction(){

                public void on() {
                    DefaultServerSocket.this.heartbeatTimer.get().cancel();
                }
            });
        }

        Timer createCloseTimer(int heartbeat) {
            Timer timer = new Timer(true);
            timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    ((Actions)DefaultServerSocket.this.actionsMap.get("error")).fire((Object)new HeartbeatFailedException());
                    DefaultServerSocket.this.close();
                }
            }, heartbeat);
            return timer;
        }
    }

    private static class LongpollTransport
    extends HttpTransport {
        AtomicReference<ServerHttpExchange> httpRef = new AtomicReference();
        AtomicBoolean aborted = new AtomicBoolean();
        AtomicBoolean completed = new AtomicBoolean();
        AtomicBoolean written = new AtomicBoolean();
        AtomicReference<Timer> closeTimer = new AtomicReference();
        AtomicInteger msgId = new AtomicInteger();
        Map<String, String> cache = new ConcurrentHashMap<String, String>();
        ObjectMapper mapper = new ObjectMapper();

        LongpollTransport(ServerHttpExchange http) {
            super(http);
            this.refresh(http);
        }

        void refresh(ServerHttpExchange http) {
            block3: {
                final Map parameters = DefaultServer.parseQuery(http.uri());
                http.read().closeAction((Action)new VoidAction(){

                    public void on() {
                        LongpollTransport.this.completed.set(true);
                        if (((String)parameters.get("when")).equals("poll") && !LongpollTransport.this.written.get()) {
                            LongpollTransport.this.closeActions.fire();
                        } else {
                            Timer timer = new Timer(true);
                            timer.schedule(new TimerTask(){

                                @Override
                                public void run() {
                                    LongpollTransport.this.closeActions.fire();
                                }
                            }, 2000L);
                            LongpollTransport.this.closeTimer.set(timer);
                        }
                    }
                }).setHeader("content-type", "text/" + ("true".equals(this.params.get("jsonp")) ? "javascript" : "plain") + "; charset=utf-8");
                this.httpRef.set(http);
                if (!((String)parameters.get("when")).equals("poll")) break block3;
                this.completed.set(false);
                this.written.set(false);
                Timer timer = this.closeTimer.getAndSet(null);
                if (timer != null) {
                    timer.cancel();
                }
                if (this.aborted.get()) {
                    http.end();
                    return;
                }
                this.cache.remove(parameters.get("lastMsgId"));
                Iterator<String> i$ = this.cache.values().iterator();
                if (i$.hasNext()) {
                    String item = i$.next();
                    this.send(item, true);
                }
            }
        }

        @Override
        synchronized void send(String data) {
            this.send(data, false);
        }

        synchronized void send(String data, boolean noCache) {
            ServerHttpExchange http;
            if (!noCache) {
                String id = "" + this.msgId.incrementAndGet();
                data = id + "|" + data;
                this.cache.put(id, data);
            }
            if ((http = (ServerHttpExchange)this.httpRef.getAndSet(null)) != null && !this.completed.get()) {
                String payload;
                this.written.set(true);
                if ("true".equals(this.params.get("jsonp"))) {
                    try {
                        payload = (String)this.params.get("callback") + "(" + this.mapper.writeValueAsString((Object)data) + ");";
                    }
                    catch (JsonProcessingException e) {
                        throw new RuntimeException(e);
                    }
                } else {
                    payload = data;
                }
                http.end(payload);
            }
        }

        @Override
        synchronized void close() {
            this.aborted.set(true);
            ServerHttpExchange http = this.httpRef.getAndSet(null);
            if (http != null && !this.completed.get()) {
                http.end();
            }
        }
    }

    private static class StreamTransport
    extends HttpTransport {
        static final String text2KB = CharBuffer.allocate(2048).toString().replace('\u0000', ' ');

        StreamTransport(ServerHttpExchange http) {
            super(http);
            http.read().closeAction((Action)new VoidAction(){

                public void on() {
                    StreamTransport.this.closeActions.fire();
                }
            }).setHeader("content-type", "text/" + ("true".equals(this.params.get("sse")) ? "event-stream" : "plain") + "; charset=utf-8").write(text2KB + "\n");
        }

        @Override
        synchronized void send(String data) {
            String payload = "";
            for (String datum : data.split("\r\n|\r|\n")) {
                payload = payload + "data: " + datum + "\n";
            }
            payload = payload + "\n";
            this.http.write(payload);
        }

        @Override
        synchronized void close() {
            this.http.end();
        }
    }

    private static abstract class HttpTransport
    extends Transport {
        final String id = UUID.randomUUID().toString();
        final ServerHttpExchange http;
        final Map<String, String> params;

        HttpTransport(ServerHttpExchange http) {
            this.params = DefaultServer.parseQuery(http.uri());
            this.http = http;
            http.errorAction((Action)new Action<Throwable>(){

                public void on(Throwable throwable) {
                    HttpTransport.this.errorActions.fire((Object)throwable);
                }
            });
        }

        @Override
        String uri() {
            return this.http.uri();
        }

        @Override
        synchronized void handshake(Map<String, String> map) {
            map.put("id", this.id);
            super.handshake(map);
        }

        public <T> T unwrap(Class<T> clazz) {
            return (T)this.http.unwrap(clazz);
        }
    }

    private static class WebSocketTransport
    extends Transport {
        final ServerWebSocket ws;

        WebSocketTransport(ServerWebSocket ws) {
            this.ws = ws;
            ws.errorAction((Action)new Action<Throwable>(){

                public void on(Throwable throwable) {
                    WebSocketTransport.this.errorActions.fire((Object)throwable);
                }
            }).closeAction((Action)new VoidAction(){

                public void on() {
                    WebSocketTransport.this.closeActions.fire();
                }
            }).textAction((Action)new Action<String>(){

                public void on(String data) {
                    WebSocketTransport.this.messageActions.fire((Object)data);
                }
            });
        }

        @Override
        String uri() {
            return this.ws.uri();
        }

        @Override
        synchronized void send(String data) {
            this.ws.send(data);
        }

        @Override
        synchronized void close() {
            this.ws.close();
        }

        public <T> T unwrap(Class<T> clazz) {
            return (T)this.ws.unwrap(clazz);
        }
    }

    private static abstract class Transport
    implements Wrapper {
        Actions<String> messageActions = new ConcurrentActions();
        Actions<Throwable> errorActions = new ConcurrentActions();
        Actions<Void> closeActions = new ConcurrentActions(new Actions.Options().once(true).memory(true));

        private Transport() {
        }

        abstract String uri();

        abstract void send(String var1);

        abstract void close();

        synchronized void handshake(Map<String, String> map) {
            this.send("?" + DefaultServer.stringifyQuery(map));
        }
    }
}

