/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.vibe.transport.http;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import org.atmosphere.vibe.platform.http.ServerHttpExchange;
import org.atmosphere.vibe.transport.BaseServerTransport;

public abstract class BaseHttpServerTransport
extends BaseServerTransport {
    protected final String id = UUID.randomUUID().toString();
    protected final ServerHttpExchange http;
    protected final Map<String, String> params;

    public BaseHttpServerTransport(ServerHttpExchange http) {
        this.params = BaseHttpServerTransport.parseQuery(http.uri());
        this.http = http;
    }

    public String id() {
        return this.id;
    }

    @Override
    public String uri() {
        return this.http.uri();
    }

    public void handleText(String text) {
        this.textActions.fire((Object)text);
    }

    @Override
    public <T> T unwrap(Class<T> clazz) {
        return (T)this.http.unwrap(clazz);
    }

    public static Map<String, String> parseQuery(String uri) {
        String[] params;
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        String query = URI.create(uri).getQuery();
        if (query == null || query.equals("")) {
            return Collections.unmodifiableMap(map);
        }
        for (String param : params = query.split("&")) {
            try {
                String[] pair = param.split("=", 2);
                String name = URLDecoder.decode(pair[0], "UTF-8");
                if (name.equals("")) continue;
                map.put(name, pair.length > 1 ? URLDecoder.decode(pair[1], "UTF-8") : "");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return Collections.unmodifiableMap(map);
    }

    public static String formatQuery(Map<String, String> params) {
        StringBuilder query = new StringBuilder();
        for (Map.Entry<String, String> entry : params.entrySet()) {
            try {
                query.append(URLEncoder.encode(entry.getKey(), "UTF-8")).append("=").append(URLEncoder.encode(entry.getValue(), "UTF-8")).append("&");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return query.deleteCharAt(query.length() - 1).toString();
    }
}

