/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.vibe.transport.http;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.atmosphere.vibe.platform.action.Action;
import org.atmosphere.vibe.platform.action.VoidAction;
import org.atmosphere.vibe.platform.http.ServerHttpExchange;
import org.atmosphere.vibe.transport.http.BaseHttpServerTransport;

public class HttpLongpollServerTransport
extends BaseHttpServerTransport {
    private AtomicReference<ServerHttpExchange> httpRef = new AtomicReference();
    private AtomicBoolean aborted = new AtomicBoolean();
    private AtomicBoolean completed = new AtomicBoolean();
    private AtomicBoolean written = new AtomicBoolean();
    private AtomicReference<Timer> closeTimer = new AtomicReference();
    private AtomicInteger msgId = new AtomicInteger();
    private Map<String, String> cache = new ConcurrentHashMap<String, String>();
    private ObjectMapper mapper = new ObjectMapper();
    private String jsonpCallback;

    public HttpLongpollServerTransport(ServerHttpExchange http) {
        super(http);
        this.refresh(http);
        if ("true".equals(this.params.get("jsonp"))) {
            this.jsonpCallback = (String)this.params.get("callback");
        }
        LinkedHashMap<String, String> query = new LinkedHashMap<String, String>();
        query.put("id", this.id);
        ((ServerHttpExchange)this.httpRef.getAndSet(null)).end(this.formatMessage("?" + HttpLongpollServerTransport.formatQuery(query)));
    }

    public void refresh(ServerHttpExchange http) {
        block3: {
            final Map<String, String> parameters = HttpLongpollServerTransport.parseQuery(http.uri());
            http.read().errorAction((Action)new Action<Throwable>(){

                public void on(Throwable throwable) {
                    HttpLongpollServerTransport.this.errorActions.fire((Object)throwable);
                }
            }).closeAction((Action)new VoidAction(){

                public void on() {
                    HttpLongpollServerTransport.this.completed.set(true);
                    if (((String)parameters.get("when")).equals("poll") && !HttpLongpollServerTransport.this.written.get()) {
                        HttpLongpollServerTransport.this.closeActions.fire();
                    } else {
                        Timer timer = new Timer(true);
                        timer.schedule(new TimerTask(){

                            @Override
                            public void run() {
                                HttpLongpollServerTransport.this.closeActions.fire();
                            }
                        }, 2000L);
                        HttpLongpollServerTransport.this.closeTimer.set(timer);
                    }
                }
            }).setHeader("content-type", "text/" + (this.jsonpCallback != null ? "javascript" : "plain") + "; charset=utf-8");
            this.httpRef.set(http);
            if (!parameters.get("when").equals("poll")) break block3;
            this.completed.set(false);
            this.written.set(false);
            Timer timer = this.closeTimer.getAndSet(null);
            if (timer != null) {
                timer.cancel();
            }
            if (this.aborted.get()) {
                http.end();
                return;
            }
            this.cache.remove(parameters.get("lastMsgId"));
            Iterator<String> i$ = this.cache.values().iterator();
            if (i$.hasNext()) {
                String item = i$.next();
                this.send(item, true);
            }
        }
    }

    @Override
    public void doSend(String data) {
        this.send(data, false);
    }

    private void send(String data, boolean noCache) {
        ServerHttpExchange http;
        if (!noCache) {
            String id = "" + this.msgId.incrementAndGet();
            data = id + "|" + data;
            this.cache.put(id, data);
        }
        if ((http = (ServerHttpExchange)this.httpRef.getAndSet(null)) != null && !this.completed.get()) {
            this.written.set(true);
            http.end(this.formatMessage(data));
        }
    }

    private String formatMessage(String data) {
        if (this.jsonpCallback != null) {
            try {
                return this.jsonpCallback + "(" + this.mapper.writeValueAsString((Object)data) + ");";
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
        }
        return data;
    }

    @Override
    public void doClose() {
        this.aborted.set(true);
        ServerHttpExchange http = this.httpRef.getAndSet(null);
        if (http != null && !this.completed.get()) {
            http.end();
        }
    }
}

