/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.wasync.impl;

import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.atmosphere.wasync.Future;
import org.atmosphere.wasync.Socket;
import org.atmosphere.wasync.impl.DefaultSocket;

public class DefaultFuture
implements Future {
    private final DefaultSocket socket;
    private CountDownLatch latch = new CountDownLatch(1);
    private final AtomicBoolean done = new AtomicBoolean(false);
    protected long time = -1L;
    protected TimeUnit tu;
    protected TimeoutException te = null;

    public DefaultFuture(DefaultSocket socket) {
        this.socket = socket;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        this.latch.countDown();
        return true;
    }

    @Override
    public boolean isCancelled() {
        return this.latch.getCount() == 0L;
    }

    @Override
    public boolean isDone() {
        return this.done.get();
    }

    @Override
    public Future done() {
        this.done.set(true);
        this.latch.countDown();
        return this;
    }

    protected void reset() {
        this.done.set(false);
        this.latch = new CountDownLatch(1);
    }

    @Override
    public Socket get() throws InterruptedException, ExecutionException {
        this.latch.await();
        return this.socket;
    }

    @Override
    public Socket get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        this.time = timeout;
        this.tu = unit;
        if (!this.latch.await(timeout, unit) || this.te != null) {
            throw this.te;
        }
        return this.socket;
    }

    protected Socket socket() {
        return this.socket;
    }

    @Override
    public Future fire(Object data) throws IOException {
        this.reset();
        this.socket.internalSocket().write(this.socket.request(), data);
        return this;
    }
}

