/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.wasync.impl;

import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.ListenableFuture;
import com.ning.http.client.Response;
import com.ning.http.client.websocket.WebSocket;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import org.atmosphere.wasync.Encoder;
import org.atmosphere.wasync.Event;
import org.atmosphere.wasync.FunctionWrapper;
import org.atmosphere.wasync.Future;
import org.atmosphere.wasync.Options;
import org.atmosphere.wasync.Request;
import org.atmosphere.wasync.impl.AtmosphereRequest;
import org.atmosphere.wasync.impl.DefaultFuture;
import org.atmosphere.wasync.impl.DefaultSocket;
import org.atmosphere.wasync.transport.TransportsUtil;
import org.atmosphere.wasync.util.ReaderInputStream;
import org.atmosphere.wasync.util.TypeResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SocketRuntime {
    private static final Logger logger = LoggerFactory.getLogger(SocketRuntime.class);
    protected final WebSocket webSocket;
    protected final Options options;
    protected final DefaultFuture rootFuture;
    protected final List<FunctionWrapper> functions;

    public SocketRuntime(WebSocket webSocket, Options options, DefaultFuture rootFuture, List<FunctionWrapper> functions) {
        this.webSocket = webSocket;
        this.options = options;
        this.rootFuture = rootFuture;
        this.functions = functions;
    }

    public SocketRuntime(Options options, DefaultFuture rootFuture, List<FunctionWrapper> functions) {
        this(null, options, rootFuture, functions);
    }

    public DefaultFuture future() {
        return this.rootFuture;
    }

    protected Object invokeEncoder(List<Encoder<? extends Object, ?>> encoders, Object instanceType) {
        for (Encoder<Object, ?> e : encoders) {
            Class<?>[] typeArguments = TypeResolver.resolveArguments(e.getClass(), Encoder.class);
            if (typeArguments.length <= 0 || !typeArguments[0].isAssignableFrom(instanceType.getClass())) continue;
            instanceType = e.encode(instanceType);
        }
        return instanceType;
    }

    public Future write(Request request, Object data) throws IOException {
        Object object = this.invokeEncoder(request.encoders(), data);
        if (this.webSocket != null) {
            this.webSocketWrite(request, object, data);
        } else {
            try {
                Response r = (Response)this.httpWrite(request, object, data).get(this.rootFuture.time, this.rootFuture.tu);
                String m = r.getResponseBody();
                if (!m.isEmpty()) {
                    TransportsUtil.invokeFunction(request.decoders(), this.functions, String.class, m, Event.MESSAGE.name(), request.functionResolver());
                }
            }
            catch (TimeoutException t) {
                logger.trace("AHC Timeout", t);
                this.rootFuture.te = t;
            }
            catch (Throwable t) {
                logger.error("", t);
            }
        }
        return this.rootFuture.done();
    }

    public void webSocketWrite(Request request, Object object, Object data) throws IOException {
        if (InputStream.class.isAssignableFrom(object.getClass())) {
            InputStream is = (InputStream)object;
            ByteArrayOutputStream bs = new ByteArrayOutputStream();
            byte[] buffer = new byte[8192];
            int n = 0;
            while (-1 != (n = is.read(buffer))) {
                bs.write(buffer, 0, n);
            }
            this.webSocket.sendMessage(bs.toByteArray());
        } else if (Reader.class.isAssignableFrom(object.getClass())) {
            Reader is = (Reader)object;
            StringWriter bs = new StringWriter();
            char[] chars = new char[8192];
            int n = 0;
            while (-1 != (n = is.read(chars))) {
                bs.write(chars, 0, n);
            }
            this.webSocket.sendTextMessage(bs.getBuffer().toString());
        } else if (String.class.isAssignableFrom(object.getClass())) {
            this.webSocket.sendTextMessage(object.toString());
        } else if (byte[].class.isAssignableFrom(object.getClass())) {
            this.webSocket.sendMessage((byte[])object);
        } else {
            throw new IllegalStateException("No Encoder for " + data);
        }
    }

    public ListenableFuture<Response> httpWrite(Request request, Object object, Object data) throws IOException {
        if (AtmosphereRequest.class.isAssignableFrom(request.getClass())) {
            request.queryString().put("X-Atmosphere-Transport", Arrays.asList("polling"));
            request.queryString().remove("X-atmo-protocol");
        }
        AsyncHttpClient.BoundRequestBuilder b = (AsyncHttpClient.BoundRequestBuilder)((AsyncHttpClient.BoundRequestBuilder)this.options.runtime().preparePost(request.uri()).setHeaders((Map)request.headers()).setQueryParameters(DefaultSocket.decodeQueryString(request))).setMethod(Request.METHOD.POST.name());
        if (InputStream.class.isAssignableFrom(object.getClass())) {
            return b.setBody((InputStream)object).execute();
        }
        if (Reader.class.isAssignableFrom(object.getClass())) {
            return b.setBody(new ReaderInputStream((Reader)object)).execute();
        }
        if (String.class.isAssignableFrom(object.getClass())) {
            return b.setBody((String)object).execute();
        }
        if (byte[].class.isAssignableFrom(object.getClass())) {
            return b.setBody((byte[])object).execute();
        }
        throw new IllegalStateException("No Encoder for " + data);
    }
}

