/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.wasync.decoder;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.atmosphere.wasync.Event;
import org.atmosphere.wasync.ReplayDecoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrackMessageSizeDecoder
implements ReplayDecoder {
    private final Logger logger = LoggerFactory.getLogger(TrackMessageSizeDecoder.class);
    private final String delimiter;
    private final StringBuffer messagesBuffer = new StringBuffer();
    private final AtomicBoolean skipFirstMessage = new AtomicBoolean();
    private final List<String> empty = Collections.emptyList();

    public TrackMessageSizeDecoder() {
        this.delimiter = "|";
    }

    public TrackMessageSizeDecoder(boolean protocolEnabled) {
        this.delimiter = "|";
        this.skipFirstMessage.set(protocolEnabled);
    }

    public TrackMessageSizeDecoder(String delimiter, boolean protocolEnabled) {
        this.delimiter = delimiter;
        this.skipFirstMessage.set(protocolEnabled);
    }

    @Override
    public List<String> decode(Event type, String message) {
        if (type.equals((Object)Event.MESSAGE)) {
            if (this.skipFirstMessage.getAndSet(false)) {
                return this.empty;
            }
            ArrayList<String> messages = new ArrayList<String>();
            int messageLength = -1;
            int messageStartIndex = 0;
            int delimiterIndex = -1;
            String singleMessage = null;
            while ((delimiterIndex = message.indexOf(this.delimiter, messageStartIndex)) >= 0) {
                if (delimiterIndex == messageStartIndex) {
                    messageStartIndex = delimiterIndex + 1;
                    continue;
                }
                try {
                    messageLength = Integer.valueOf(message.substring(messageStartIndex, delimiterIndex));
                    if (messageLength <= 0) {
                        throw new Exception();
                    }
                }
                catch (Exception e) {
                    this.logger.error("", e);
                    this.messagesBuffer.setLength(0);
                    throw new Error("Message format is not as expected for tracking message size " + message);
                }
                messageStartIndex = delimiterIndex < message.length() - 1 ? delimiterIndex + 1 : message.length();
                int lenghtOfRemainingMessage = message.length() - messageStartIndex;
                singleMessage = message.substring(messageStartIndex, messageLength <= lenghtOfRemainingMessage ? messageStartIndex + messageLength : messageStartIndex + lenghtOfRemainingMessage);
                delimiterIndex = message.indexOf(this.delimiter, messageStartIndex + messageLength);
                if (delimiterIndex >= 0) {
                    int n = messageStartIndex = delimiterIndex < message.length() - 1 ? delimiterIndex + 1 : message.length() - 1;
                }
                if (singleMessage.length() == messageLength) {
                    messages.add(singleMessage);
                    if (delimiterIndex >= 0) continue;
                    this.messagesBuffer.setLength(0);
                    continue;
                }
                this.messagesBuffer.setLength(0);
                this.messagesBuffer.append(messageLength).append(this.delimiter).append(singleMessage);
            }
            return messages;
        }
        return this.empty;
    }
}

