/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.wasync.impl;

import com.ning.http.client.AsyncHandler;
import com.ning.http.client.FluentStringsMap;
import com.ning.http.client.ListenableFuture;
import com.ning.http.client.RequestBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.atmosphere.wasync.Event;
import org.atmosphere.wasync.Function;
import org.atmosphere.wasync.FunctionWrapper;
import org.atmosphere.wasync.Future;
import org.atmosphere.wasync.Options;
import org.atmosphere.wasync.Request;
import org.atmosphere.wasync.Socket;
import org.atmosphere.wasync.Transport;
import org.atmosphere.wasync.impl.DefaultFuture;
import org.atmosphere.wasync.impl.SocketRuntime;
import org.atmosphere.wasync.transport.LongPollingTransport;
import org.atmosphere.wasync.transport.SSETransport;
import org.atmosphere.wasync.transport.StreamTransport;
import org.atmosphere.wasync.transport.TransportNotSupported;
import org.atmosphere.wasync.transport.WebSocketTransport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSocket
implements Socket {
    private static final Logger logger = LoggerFactory.getLogger(DefaultSocket.class);
    protected Request request;
    protected SocketRuntime socketRuntime;
    protected final List<FunctionWrapper> functions = new ArrayList<FunctionWrapper>();
    protected Transport transportInUse;
    protected final Options options;

    public DefaultSocket(Options options) {
        this.options = options;
    }

    @Override
    public Future fire(Object data) throws IOException {
        this.checkState();
        if (this.transportInUse.status().equals((Object)Socket.STATUS.CLOSE) || this.transportInUse.status().equals((Object)Socket.STATUS.ERROR)) {
            this.transportInUse.error(new IOException("Invalid Socket Status " + this.transportInUse.status().name()));
            return this.socketRuntime.rootFuture;
        }
        return this.socketRuntime.write(this.request, data);
    }

    public Socket on(Function<? extends Object> function) {
        return this.on("", function);
    }

    public Socket on(String functionName, Function<? extends Object> function) {
        this.functions.add(new FunctionWrapper(functionName, function));
        return this;
    }

    @Override
    public Socket on(Event event, Function<?> function) {
        return this.on(event.name(), (Function<? extends Object>)function);
    }

    @Override
    public Socket open(Request request) throws IOException {
        return this.open(request, -1L, TimeUnit.MILLISECONDS);
    }

    @Override
    public Socket open(Request request, long timeout, TimeUnit tu) throws IOException {
        this.request = request;
        RequestBuilder r = new RequestBuilder();
        ((RequestBuilder)r.setUrl(request.uri()).setMethod(request.method().name()).setHeaders((Map)request.headers())).setQueryParameters(DefaultSocket.decodeQueryString(request));
        List<Transport> transports = this.getTransport(r, request);
        return this.connect(r, transports, timeout, tu);
    }

    static FluentStringsMap decodeQueryString(Request request) {
        Map<String, List<String>> c = request.queryString();
        FluentStringsMap f = new FluentStringsMap();
        f.putAll((Map<? extends String, ? extends List<String>>)c);
        return f;
    }

    protected Socket connect(RequestBuilder r, List<Transport> transports) throws IOException {
        return this.connect(r, transports, -1L, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Socket connect(RequestBuilder r, List<Transport> transports, long timeout, TimeUnit tu) throws IOException {
        if (transports.size() <= 0) {
            throw new IOException("No suitable transport supported");
        }
        this.transportInUse = transports.get(0);
        DefaultFuture f = new DefaultFuture(this);
        this.socketRuntime = this.createRuntime(f, this.options, this.functions);
        this.transportInUse.connectedFuture(f);
        this.addFunction(timeout, tu);
        if (this.transportInUse.name().equals((Object)Request.TRANSPORT.WEBSOCKET)) {
            r.setUrl(this.request.uri().replace("http", "ws"));
            try {
                ListenableFuture fw = this.options.runtime().prepareRequest(r.build()).execute((AsyncHandler)((Object)this.transportInUse));
                fw.get(timeout, tu);
            }
            catch (ExecutionException t) {
                Throwable e = t.getCause();
                if (TransportNotSupported.class.isAssignableFrom(e.getClass())) {
                    return this;
                }
                this.transportInUse.close();
                this.closeRuntime(true);
                if (!this.transportInUse.errorHandled() && TimeoutException.class.isAssignableFrom(e.getClass())) {
                    this.transportInUse.error(new IOException("Invalid state: " + e.getMessage()));
                }
                return new VoidSocket();
            }
            catch (Throwable t) {
                this.transportInUse.onThrowable(t);
                return new VoidSocket();
            }
        }
        r.setUrl(this.request.uri().replace("ws", "http"));
        this.transportInUse.future(this.options.runtime().prepareRequest(r.build()).execute((AsyncHandler)((Object)this.transportInUse)));
        try {
            if (this.options.waitBeforeUnlocking() > 0L) {
                logger.info("Waiting {}, allowing the http connection to get handled by the server. To reduce the delay, make sure some bytes get written when the connection is suspendeded on the server", (Object)this.options.waitBeforeUnlocking());
            }
            if (this.request.queryString().containsKey("X-atmo-protocol")) {
                f.get();
            } else {
                f.get(this.options.waitBeforeUnlocking(), TimeUnit.MILLISECONDS);
            }
        }
        catch (Throwable t) {
            logger.trace("", t);
        }
        finally {
            f.done();
        }
        return this;
    }

    protected void addFunction(final long timeout, final TimeUnit tu) {
        this.functions.add(new FunctionWrapper("", new Function<TransportNotSupported>(){

            @Override
            public void on(TransportNotSupported transportNotSupported) {
                DefaultSocket.this.request.transport().remove(0);
                if (DefaultSocket.this.request.transport().size() > 0) {
                    try {
                        DefaultSocket.this.open(DefaultSocket.this.request, timeout, tu);
                    }
                    catch (IOException e) {
                        logger.error("", e);
                    }
                } else {
                    throw new Error("No suitable transport supported by the server");
                }
            }
        }));
    }

    @Override
    public void close() {
        if (this.transportInUse == null) {
            this.closeRuntime(false);
        } else if (this.socketRuntime != null && !this.transportInUse.status().equals((Object)Socket.STATUS.CLOSE)) {
            this.transportInUse.close();
            this.closeRuntime(true);
        }
    }

    protected void closeRuntime(boolean async) {
        if (!this.options.runtimeShared() && !this.options.runtime().isClosed()) {
            if (async) {
                final ExecutorService e = Executors.newSingleThreadExecutor();
                e.submit(new Runnable(){

                    @Override
                    public void run() {
                        DefaultSocket.this.options.runtime().close();
                        e.shutdown();
                    }
                });
            } else {
                this.options.runtime().close();
            }
        } else if (this.options.runtimeShared()) {
            logger.warn("Cannot close underlying AsyncHttpClient because it is shared. Make sure you close it manually.");
        }
    }

    @Override
    public Socket.STATUS status() {
        if (this.transportInUse == null) {
            return Socket.STATUS.CLOSE;
        }
        return this.transportInUse.status();
    }

    protected SocketRuntime internalSocket() {
        return this.socketRuntime;
    }

    protected List<Transport> getTransport(RequestBuilder r, Request request) throws IOException {
        ArrayList<Transport> transports = new ArrayList<Transport>();
        if (request.transport().size() == 0) {
            transports.add(new WebSocketTransport(r, this.options, request, this.functions));
            transports.add(new LongPollingTransport(r, this.options, request, this.functions));
        }
        for (Request.TRANSPORT t : request.transport()) {
            if (t.equals((Object)Request.TRANSPORT.WEBSOCKET)) {
                transports.add(new WebSocketTransport(r, this.options, request, this.functions));
                continue;
            }
            if (t.equals((Object)Request.TRANSPORT.SSE)) {
                transports.add(new SSETransport(r, this.options, request, this.functions));
                continue;
            }
            if (t.equals((Object)Request.TRANSPORT.LONG_POLLING)) {
                transports.add(new LongPollingTransport(r, this.options, request, this.functions));
                continue;
            }
            if (!t.equals((Object)Request.TRANSPORT.STREAMING)) continue;
            transports.add(new StreamTransport(r, this.options, request, this.functions));
        }
        return transports;
    }

    protected Request request() {
        return this.request;
    }

    void checkState() {
        if (this.transportInUse == null) {
            throw new IllegalStateException("Invalid Socket Status : Not Connected");
        }
    }

    public SocketRuntime createRuntime(DefaultFuture future, Options options, List<FunctionWrapper> functions) {
        return new SocketRuntime(this.transportInUse, options, future, functions);
    }

    private static final class VoidSocket
    implements Socket {
        private VoidSocket() {
        }

        @Override
        public Future fire(Object data) throws IOException {
            throw new IllegalStateException("An error occurred during connection. Please add a Function(Throwable) to debug.");
        }

        public Socket on(Function<? extends Object> function) {
            throw new IllegalStateException("An error occurred during connection. Please add a Function(Throwable) to debug.");
        }

        public Socket on(String functionMessage, Function<? extends Object> function) {
            throw new IllegalStateException("An error occurred during connection. Please add a Function(Throwable) to debug.");
        }

        @Override
        public Socket on(Event event, Function<?> function) {
            throw new IllegalStateException("An error occurred during connection. Please add a Function(Throwable) to debug.");
        }

        @Override
        public Socket open(Request request) throws IOException {
            throw new IllegalStateException("An error occurred during connection. Please add a Function(Throwable) to debug.");
        }

        @Override
        public void close() {
            throw new IllegalStateException("An error occurred during connection. Please add a Function(Throwable) to debug.");
        }

        @Override
        public Socket.STATUS status() {
            return Socket.STATUS.ERROR;
        }

        @Override
        public Socket open(Request request, long timeout, TimeUnit tu) throws IOException {
            throw new IllegalStateException("An error occured during connection. Please add a Function(Throwable) to debug.");
        }
    }
}

