/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.wasync;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.atmosphere.wasync.Decoder;
import org.atmosphere.wasync.Encoder;
import org.atmosphere.wasync.FunctionResolver;
import org.atmosphere.wasync.Request;
import org.atmosphere.wasync.impl.DefaultFunctionResolver;

public abstract class RequestBuilder {
    public final List<Request.TRANSPORT> transports = new ArrayList<Request.TRANSPORT>();
    public Request.METHOD method = Request.METHOD.GET;
    public String uri = "http://localhost:8080";
    public final List<Encoder<?, ?>> encoders = new ArrayList();
    public final List<Decoder<?, ?>> decoders = new ArrayList();
    public final Map<String, Collection<String>> headers = new HashMap<String, Collection<String>>();
    public final Map<String, Collection<String>> queryString = new HashMap<String, Collection<String>>();
    public FunctionResolver resolver = new DefaultFunctionResolver();

    public RequestBuilder transport(Request.TRANSPORT t) {
        this.transports.add(t);
        return this;
    }

    public RequestBuilder method(Request.METHOD method) {
        this.method = method;
        return this;
    }

    public RequestBuilder uri(String uri) {
        this.uri = uri;
        return this;
    }

    public RequestBuilder encoder(Encoder e) {
        this.encoders.add(e);
        return this;
    }

    public RequestBuilder decoder(Decoder d) {
        this.decoders.add(d);
        return this;
    }

    public RequestBuilder header(String name, String value) {
        Collection<String> l = this.headers.get(name);
        if (l == null) {
            l = new ArrayList<String>();
        }
        l.add(value);
        this.headers.put(name, l);
        return this;
    }

    public RequestBuilder queryString(String name, String value) {
        Collection<String> l = this.queryString.get(name);
        if (l == null) {
            l = new ArrayList<String>();
        }
        l.add(value);
        this.queryString.put(name, l);
        return this;
    }

    public RequestBuilder resolver(FunctionResolver resolver) {
        this.resolver = resolver;
        return this;
    }

    public abstract Request build();
}

