/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.providers.netty;

import com.ning.http.client.Body;
import java.nio.ByteBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.handler.stream.ChunkedInput;

class BodyChunkedInput
implements ChunkedInput {
    private static final int DEFAULT_CHUNK_SIZE = 8192;
    private final Body body;
    private final int contentLength;
    private final int chunkSize;
    private boolean endOfInput;

    public BodyChunkedInput(Body body) {
        if (body == null) {
            throw new IllegalArgumentException("no body specified");
        }
        this.body = body;
        this.contentLength = (int)body.getContentLength();
        this.chunkSize = this.contentLength <= 0 ? 8192 : Math.min(this.contentLength, 8192);
    }

    public boolean hasNextChunk() throws Exception {
        throw new UnsupportedOperationException();
    }

    public Object nextChunk() throws Exception {
        if (this.endOfInput) {
            return null;
        }
        ByteBuffer buffer = ByteBuffer.allocate(this.chunkSize);
        long r = this.body.read(buffer);
        if (r < 0L) {
            this.endOfInput = true;
            return null;
        }
        this.endOfInput = r == (long)this.contentLength || r < (long)this.chunkSize && this.contentLength > 0;
        buffer.flip();
        return ChannelBuffers.wrappedBuffer(buffer);
    }

    public boolean isEndOfInput() throws Exception {
        return this.endOfInput;
    }

    public void close() throws Exception {
        this.body.close();
    }
}

