/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.providers.netty.timeout;

import com.ning.http.client.providers.netty.NettyAsyncHttpProvider;
import com.ning.http.client.providers.netty.NettyResponseFuture;
import com.ning.http.client.providers.netty.timeout.TimeoutsHolder;
import java.util.concurrent.TimeoutException;
import org.jboss.netty.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TimeoutTimerTask
implements TimerTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(TimeoutTimerTask.class);
    protected final NettyResponseFuture<?> nettyResponseFuture;
    protected final NettyAsyncHttpProvider provider;
    protected final TimeoutsHolder timeoutsHolder;

    public TimeoutTimerTask(NettyResponseFuture<?> nettyResponseFuture, NettyAsyncHttpProvider provider, TimeoutsHolder timeoutsHolder) {
        this.nettyResponseFuture = nettyResponseFuture;
        this.provider = provider;
        this.timeoutsHolder = timeoutsHolder;
    }

    protected void expire(String message) {
        LOGGER.debug("{} for {}", (Object)message, (Object)this.nettyResponseFuture);
        this.provider.abort(this.nettyResponseFuture, new TimeoutException(message));
    }
}

