/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.wasync.impl;

import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.providers.netty.NettyAsyncHttpProviderConfig;
import org.atmosphere.wasync.Options;
import org.atmosphere.wasync.Socket;
import org.atmosphere.wasync.impl.DefaultOptionsBuilder;
import org.atmosphere.wasync.impl.DefaultSocket;

public class ClientUtil {
    private static final String WASYNC_USER_AGENT = "wAsync/1.0";

    public static final AsyncHttpClient createDefaultAsyncHttpClient(Options o) {
        AsyncHttpClientConfig.Builder b = new AsyncHttpClientConfig.Builder();
        int t = o.requestTimeoutInSeconds();
        b.setFollowRedirects(true).setIdleConnectionTimeoutInMs(-1).setRequestTimeoutInMs(t == -1 ? t : t * 1000).setUserAgent(WASYNC_USER_AGENT);
        NettyAsyncHttpProviderConfig nettyConfig = new NettyAsyncHttpProviderConfig();
        nettyConfig.addProperty("child.tcpNoDelay", (Object)"true");
        nettyConfig.addProperty("child.keepAlive", (Object)"true");
        AsyncHttpClientConfig config = b.setAsyncHttpClientProviderConfig(nettyConfig).build();
        return new AsyncHttpClient(config);
    }

    public static Socket create(Options options) {
        return ClientUtil.create(options, DefaultSocket.class);
    }

    public static Socket create(Options options, Class<? extends Socket> socket) {
        AsyncHttpClient asyncHttpClient = options.runtime();
        if (asyncHttpClient == null || asyncHttpClient.isClosed()) {
            asyncHttpClient = ClientUtil.createDefaultAsyncHttpClient(options);
            options.runtime(asyncHttpClient);
        }
        return ClientUtil.getSocket(options, socket);
    }

    public static final Socket getSocket(Options options, Class<? extends Socket> socket) {
        try {
            return socket.getConstructor(Options.class).newInstance(options);
        }
        catch (Exception e) {
            return new DefaultSocket(options);
        }
    }

    public static Socket create(Class<? extends Socket> socket) {
        AsyncHttpClient asyncHttpClient = ClientUtil.createDefaultAsyncHttpClient(((DefaultOptionsBuilder)new DefaultOptionsBuilder().reconnect(true)).build());
        return ClientUtil.getSocket(((DefaultOptionsBuilder)new DefaultOptionsBuilder().runtime(asyncHttpClient, false)).build(), socket);
    }

    public static Socket create() {
        AsyncHttpClient asyncHttpClient = ClientUtil.createDefaultAsyncHttpClient(((DefaultOptionsBuilder)new DefaultOptionsBuilder().reconnect(true)).build());
        return ClientUtil.getSocket(((DefaultOptionsBuilder)new DefaultOptionsBuilder().runtime(asyncHttpClient, false)).build(), DefaultSocket.class);
    }
}

