/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.wasync.transport;

import com.ning.http.client.AsyncHandler;
import com.ning.http.client.HttpResponseBodyPart;
import com.ning.http.client.HttpResponseHeaders;
import com.ning.http.client.HttpResponseStatus;
import com.ning.http.client.RequestBuilder;
import com.ning.http.client.websocket.WebSocket;
import com.ning.http.client.websocket.WebSocketByteListener;
import com.ning.http.client.websocket.WebSocketListener;
import com.ning.http.client.websocket.WebSocketTextListener;
import com.ning.http.client.websocket.WebSocketUpgradeHandler;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.atmosphere.wasync.Decoder;
import org.atmosphere.wasync.Event;
import org.atmosphere.wasync.FunctionResolver;
import org.atmosphere.wasync.FunctionWrapper;
import org.atmosphere.wasync.Future;
import org.atmosphere.wasync.Options;
import org.atmosphere.wasync.Request;
import org.atmosphere.wasync.Socket;
import org.atmosphere.wasync.Transport;
import org.atmosphere.wasync.transport.TransportNotSupported;
import org.atmosphere.wasync.transport.TransportsUtil;
import org.atmosphere.wasync.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebSocketTransport
extends WebSocketUpgradeHandler
implements Transport {
    private final Logger logger = LoggerFactory.getLogger(WebSocketTransport.class);
    private WebSocket webSocket;
    private final AtomicBoolean ok = new AtomicBoolean(false);
    private final List<FunctionWrapper> functions;
    private final List<Decoder<?, ?>> decoders;
    private final FunctionResolver resolver;
    private final Options options;
    private final RequestBuilder requestBuilder;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private Socket.STATUS status = Socket.STATUS.INIT;
    private final AtomicBoolean errorHandled = new AtomicBoolean();
    private Future underlyingFuture;
    private Future connectOperationFuture;
    protected final boolean protocolEnabled;
    protected boolean supportBinary = false;
    protected final ScheduledExecutorService timer;

    public WebSocketTransport(RequestBuilder requestBuilder, Options options, Request request, List<FunctionWrapper> functions) {
        super(new WebSocketUpgradeHandler.Builder());
        this.decoders = request.decoders();
        if (this.decoders.size() == 0) {
            this.decoders.add(new Decoder<String, Object>(){

                @Override
                public Object decode(Event e, String s) {
                    return s;
                }
            });
        }
        this.functions = functions;
        this.resolver = request.functionResolver();
        this.options = options;
        this.requestBuilder = requestBuilder;
        this.supportBinary = options.binary() || request.headers().get("Content-Type") != null && request.headers().get("Content-Type").contains("application/octet-stream");
        this.protocolEnabled = request.queryString().get("X-atmo-protocol") != null;
        this.timer = Executors.newSingleThreadScheduledExecutor();
    }

    @Override
    public void onThrowable(Throwable t) {
        this.logger.debug("", t);
        this.status = Socket.STATUS.ERROR;
        this.onFailure(t);
    }

    @Override
    public void close() {
        this.status = Socket.STATUS.CLOSE;
        if (this.closed.getAndSet(true)) {
            return;
        }
        this.timer.shutdown();
        TransportsUtil.invokeFunction(Event.CLOSE, this.decoders, this.functions, String.class, Event.CLOSE.name(), Event.CLOSE.name(), this.resolver);
        if (this.webSocket != null && this.webSocket.isOpen()) {
            this.webSocket.close();
        }
        this.futureDone();
    }

    @Override
    public Socket.STATUS status() {
        return this.status;
    }

    void futureDone() {
        if (this.underlyingFuture != null) {
            this.underlyingFuture.done();
        }
    }

    @Override
    public boolean errorHandled() {
        return this.errorHandled.get();
    }

    @Override
    public void error(Throwable t) {
        this.logger.warn("", t);
        this.connectFutureException(t);
        TransportsUtil.invokeFunction(Event.ERROR, this.decoders, this.functions, t.getClass(), t, Event.ERROR.name(), this.resolver);
    }

    @Override
    public void future(Future f) {
        this.underlyingFuture = f;
    }

    @Override
    public void connectedFuture(Future f) {
        this.connectOperationFuture = f;
    }

    @Override
    public AsyncHandler.STATE onBodyPartReceived(HttpResponseBodyPart bodyPart) throws Exception {
        this.logger.trace("Body received {}", (Object)new String(bodyPart.getBodyPartBytes()));
        return AsyncHandler.STATE.CONTINUE;
    }

    @Override
    public AsyncHandler.STATE onStatusReceived(HttpResponseStatus responseStatus) throws Exception {
        this.logger.trace("Status received {}", (Object)responseStatus);
        TransportsUtil.invokeFunction(Event.STATUS, this.decoders, this.functions, Integer.class, new Integer(responseStatus.getStatusCode()), Event.STATUS.name(), this.resolver);
        if (responseStatus.getStatusCode() == 101) {
            return AsyncHandler.STATE.UPGRADE;
        }
        this.logger.debug("Invalid status code {} for WebSocket Handshake", (Object)responseStatus.getStatusCode());
        this.status = Socket.STATUS.ERROR;
        throw new TransportNotSupported(responseStatus.getStatusCode(), responseStatus.getStatusText());
    }

    @Override
    public AsyncHandler.STATE onHeadersReceived(HttpResponseHeaders headers) throws Exception {
        this.logger.trace("Headers received {}", (Object)headers);
        TransportsUtil.invokeFunction(Event.HEADERS, this.decoders, this.functions, Map.class, headers.getHeaders(), Event.HEADERS.name(), this.resolver);
        return AsyncHandler.STATE.CONTINUE;
    }

    @Override
    public WebSocket onCompleted() throws Exception {
        this.logger.trace("onCompleted {}", (Object)this.webSocket);
        if (this.webSocket == null) {
            this.logger.error("WebSocket Handshake Failed");
            this.status = Socket.STATUS.ERROR;
            return null;
        }
        TransportsUtil.invokeFunction(Event.TRANSPORT, this.decoders, this.functions, Request.TRANSPORT.class, (Object)this.name(), Event.TRANSPORT.name(), this.resolver);
        return this.webSocket;
    }

    void unlockFuture() {
        try {
            this.connectOperationFuture.finishOrThrowException();
        }
        catch (IOException e) {
            this.logger.warn("", e);
        }
    }

    @Override
    public void onSuccess(WebSocket webSocket) {
        this.logger.trace("onSuccess {}", (Object)webSocket);
        this.webSocket = webSocket;
        if (this.connectOperationFuture != null && !this.protocolEnabled) {
            this.unlockFuture();
        }
        this.ok.set(true);
        WebSocketListener l = new TextListener();
        if (this.supportBinary) {
            l = new BinaryListener(l);
        }
        webSocket.addWebSocketListener(l);
        l.onOpen(webSocket);
    }

    void connectFutureException(Throwable t) {
        IOException e = IOException.class.isAssignableFrom(t.getClass()) ? (IOException)IOException.class.cast(t) : new IOException(t);
        this.connectOperationFuture.ioException(e).done();
    }

    void reconnect() {
        try {
            this.options.runtime().executeRequest(this.requestBuilder.build(), this);
        }
        catch (IOException e) {
            this.logger.error("", e);
        }
    }

    @Override
    public Request.TRANSPORT name() {
        return Request.TRANSPORT.WEBSOCKET;
    }

    @Override
    public Transport registerF(FunctionWrapper function) {
        this.functions.add(function);
        return this;
    }

    @Override
    public final void onFailure(Throwable t) {
        this.logger.trace("onFailure {}", t);
        this.connectFutureException(t);
        this.errorHandled.set(TransportsUtil.invokeFunction(Event.ERROR, this.decoders, this.functions, t.getClass(), t, Event.ERROR.name(), this.resolver));
    }

    public WebSocketTransport sendMessage(String message) {
        if (this.webSocket != null && !this.status.equals((Object)Socket.STATUS.ERROR) && !this.status.equals((Object)Socket.STATUS.CLOSE)) {
            this.webSocket.sendTextMessage(message);
        }
        return this;
    }

    public WebSocketTransport sendMessage(byte[] message) {
        if (this.webSocket != null && !this.status.equals((Object)Socket.STATUS.ERROR) && !this.status.equals((Object)Socket.STATUS.CLOSE)) {
            this.webSocket.sendMessage(message);
        }
        return this;
    }

    private final class BinaryListener
    implements WebSocketByteListener {
        private final WebSocketListener l;

        private BinaryListener(WebSocketListener l) {
            this.l = l;
        }

        @Override
        public void onMessage(byte[] message) {
            WebSocketTransport.this.logger.trace("{} received {}", (Object)WebSocketTransport.this.name(), (Object)message);
            if (message.length > 0 && !Utils.whiteSpace(message)) {
                TransportsUtil.invokeFunction(Event.MESSAGE, WebSocketTransport.this.decoders, WebSocketTransport.this.functions, message.getClass(), message, Event.MESSAGE.name(), WebSocketTransport.this.resolver);
                if (WebSocketTransport.this.connectOperationFuture != null && WebSocketTransport.this.protocolEnabled) {
                    WebSocketTransport.this.unlockFuture();
                }
            }
        }

        @Override
        public void onFragment(byte[] fragment, boolean last) {
        }

        @Override
        public void onOpen(WebSocket websocket) {
            this.l.onOpen(websocket);
        }

        @Override
        public void onClose(WebSocket websocket) {
            this.l.onClose(websocket);
        }

        @Override
        public void onError(Throwable t) {
            this.l.onError(t);
        }
    }

    private final class TextListener
    implements WebSocketTextListener {
        private TextListener() {
        }

        @Override
        public void onMessage(String message) {
            WebSocketTransport.this.logger.trace("onMessage {} for {}", (Object)message, (Object)WebSocketTransport.this.webSocket);
            message = message.trim();
            WebSocketTransport.this.logger.trace("{} received {}", (Object)WebSocketTransport.this.name(), (Object)message);
            if (message.length() > 0) {
                TransportsUtil.invokeFunction(Event.MESSAGE, WebSocketTransport.this.decoders, WebSocketTransport.this.functions, message.getClass(), message, Event.MESSAGE.name(), WebSocketTransport.this.resolver);
                if (WebSocketTransport.this.connectOperationFuture != null && WebSocketTransport.this.protocolEnabled) {
                    WebSocketTransport.this.unlockFuture();
                }
            }
        }

        @Override
        public void onFragment(String fragment, boolean last) {
        }

        @Override
        public void onOpen(WebSocket websocket) {
            WebSocketTransport.this.logger.trace("onOpen for {}", (Object)WebSocketTransport.this.webSocket);
            if (WebSocketTransport.this.status.equals((Object)Socket.STATUS.CLOSE) || WebSocketTransport.this.status.equals((Object)Socket.STATUS.ERROR)) {
                return;
            }
            WebSocketTransport.this.closed.set(false);
            Event newStatus = WebSocketTransport.this.status.equals((Object)Socket.STATUS.INIT) ? Event.OPEN : Event.REOPENED;
            WebSocketTransport.this.status = Socket.STATUS.OPEN;
            TransportsUtil.invokeFunction(newStatus, WebSocketTransport.this.decoders, WebSocketTransport.this.functions, String.class, newStatus.name(), newStatus.name(), WebSocketTransport.this.resolver);
        }

        @Override
        public void onClose(WebSocket websocket) {
            WebSocketTransport.this.logger.trace("onClose for {}", (Object)WebSocketTransport.this.webSocket);
            if (WebSocketTransport.this.closed.get()) {
                return;
            }
            WebSocketTransport.this.close();
            if (WebSocketTransport.this.options.reconnect()) {
                WebSocketTransport.this.status = Socket.STATUS.REOPENED;
                if (WebSocketTransport.this.options.reconnectInSeconds() > 0) {
                    WebSocketTransport.this.timer.schedule(new Runnable(){

                        @Override
                        public void run() {
                            WebSocketTransport.this.reconnect();
                        }
                    }, (long)WebSocketTransport.this.options.reconnectInSeconds(), TimeUnit.SECONDS);
                } else {
                    WebSocketTransport.this.reconnect();
                }
            }
        }

        @Override
        public void onError(Throwable t) {
            WebSocketTransport.this.logger.trace("onError for {}", t);
            WebSocketTransport.this.status = Socket.STATUS.ERROR;
            WebSocketTransport.this.logger.debug("", t);
            WebSocketTransport.this.onFailure(t);
        }
    }
}

