/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.providers.grizzly;

import com.ning.http.client.AsyncHttpProvider;
import com.ning.http.client.HttpResponseBodyPart;
import com.ning.http.client.providers.grizzly.GrizzlyAsyncHttpProvider;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicReference;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.http.HttpContent;

public class GrizzlyResponseBodyPart
extends HttpResponseBodyPart {
    private final HttpContent content;
    private final Connection connection;
    private final AtomicReference<byte[]> contentBytes = new AtomicReference();

    public GrizzlyResponseBodyPart(HttpContent content, URI uri, Connection connection, AsyncHttpProvider provider) {
        super(uri, provider);
        this.content = content;
        this.connection = connection;
    }

    public byte[] getBodyPartBytes() {
        byte[] bytes = this.contentBytes.get();
        if (bytes != null) {
            return bytes;
        }
        Buffer b = this.content.getContent();
        int origPos = b.position();
        bytes = new byte[b.remaining()];
        b.get(bytes);
        b.flip();
        b.position(origPos);
        this.contentBytes.compareAndSet(null, bytes);
        return bytes;
    }

    public int writeTo(OutputStream outputStream) throws IOException {
        byte[] bytes = this.getBodyPartBytes();
        outputStream.write(this.getBodyPartBytes());
        return bytes.length;
    }

    public ByteBuffer getBodyByteBuffer() {
        return ByteBuffer.wrap(this.getBodyPartBytes());
    }

    public boolean isLast() {
        return this.content.isLast();
    }

    public void markUnderlyingConnectionAsClosed() {
        GrizzlyAsyncHttpProvider.ConnectionManager.markConnectionAsDoNotCache(this.connection);
    }

    public boolean closeUnderlyingConnection() {
        return !GrizzlyAsyncHttpProvider.ConnectionManager.isConnectionCacheable(this.connection);
    }

    Buffer getBodyBuffer() {
        return this.content.getContent();
    }

    public int length() {
        return this.content.getContent().remaining();
    }
}

