/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.multipart;

import com.ning.http.client.multipart.AbstractFilePart;
import com.ning.http.client.multipart.FilePartStallHandler;
import com.ning.http.client.multipart.FileUploadStalledException;
import com.ning.http.client.multipart.MultipartUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilePart
extends AbstractFilePart {
    private static final Logger LOGGER = LoggerFactory.getLogger(FilePart.class);
    private final File file;

    public FilePart(String name, File file) {
        this(name, file, null);
    }

    public FilePart(String name, File file, String contentType) {
        this(name, file, contentType, null);
    }

    public FilePart(String name, File file, String contentType, Charset charset) {
        this(name, file, contentType, charset, null);
    }

    public FilePart(String name, File file, String contentType, Charset charset, String fileName) {
        this(name, file, contentType, charset, fileName, null);
    }

    public FilePart(String name, File file, String contentType, Charset charset, String fileName, String contentId) {
        this(name, file, contentType, charset, fileName, contentId, null);
    }

    public FilePart(String name, File file, String contentType, Charset charset, String fileName, String contentId, String transferEncoding) {
        super(name, contentType, charset, contentId, transferEncoding);
        if (file == null) {
            throw new NullPointerException("file");
        }
        if (!file.isFile()) {
            throw new IllegalArgumentException("File is not a normal file " + file.getAbsolutePath());
        }
        if (!file.canRead()) {
            throw new IllegalArgumentException("File is not readable " + file.getAbsolutePath());
        }
        this.file = file;
        this.setFileName(fileName != null ? fileName : file.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void sendData(OutputStream out) throws IOException {
        if (this.getDataLength() == 0L) {
            return;
        }
        byte[] tmp = new byte[4096];
        try (FileInputStream instream = new FileInputStream(this.file);){
            int len;
            while ((len = ((InputStream)instream).read(tmp)) >= 0) {
                out.write(tmp, 0, len);
            }
        }
    }

    @Override
    protected long getDataLength() {
        return this.file.length();
    }

    public File getFile() {
        return this.file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long write(WritableByteChannel target, byte[] boundary) throws IOException {
        FilePartStallHandler handler = new FilePartStallHandler(this.getStalledTime(), this);
        handler.start();
        int length = 0;
        length = (int)((long)length + MultipartUtils.writeBytesToChannel(target, this.generateFileStart(boundary)));
        RandomAccessFile raf = new RandomAccessFile(this.file, "r");
        FileChannel fc = raf.getChannel();
        long l = this.file.length();
        int fileLength = 0;
        long nWrite = 0L;
        try {
            FileChannel fileChannel = fc;
            synchronized (fileChannel) {
                while ((long)fileLength != l) {
                    if (handler.isFailed()) {
                        LOGGER.debug("Stalled error");
                        throw new FileUploadStalledException();
                    }
                    try {
                        nWrite = fc.transferTo(fileLength, l, target);
                        if (nWrite == 0L) {
                            LOGGER.info("Waiting for writing...");
                            try {
                                fc.wait(50L);
                            }
                            catch (InterruptedException e) {
                                LOGGER.trace(e.getMessage(), e);
                            }
                        } else {
                            handler.writeHappened();
                        }
                    }
                    catch (IOException ex) {
                        String message = ex.getMessage();
                        if (message != null && message.equalsIgnoreCase("Resource temporarily unavailable")) {
                            try {
                                fc.wait(1000L);
                            }
                            catch (InterruptedException e) {
                                LOGGER.trace(e.getMessage(), e);
                            }
                            LOGGER.warn("Experiencing NIO issue http://bugs.sun.com/view_bug.do?bug_id=5103988. Retrying");
                            continue;
                        }
                        throw ex;
                    }
                    fileLength = (int)((long)fileLength + nWrite);
                }
            }
        }
        finally {
            handler.completed();
            raf.close();
        }
        length = (int)((long)length + MultipartUtils.writeBytesToChannel(target, this.generateFileEnd()));
        return length;
    }
}

