/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.providers.netty.request.body;

import com.ning.http.util.MiscUtils;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import org.jboss.netty.channel.FileRegion;

public class OptimizedFileRegion
implements FileRegion {
    private final FileChannel file;
    private final RandomAccessFile raf;
    private final long position;
    private final long count;
    private long byteWritten;

    public OptimizedFileRegion(RandomAccessFile raf, long position, long count) {
        this.raf = raf;
        this.file = raf.getChannel();
        this.position = position;
        this.count = count;
    }

    @Override
    public long getPosition() {
        return this.position;
    }

    @Override
    public long getCount() {
        return this.count;
    }

    @Override
    public long transferTo(WritableByteChannel target, long position) throws IOException {
        long count = this.count - position;
        if (count < 0L || position < 0L) {
            throw new IllegalArgumentException("position out of range: " + position + " (expected: 0 - " + (this.count - 1L) + ")");
        }
        if (count == 0L) {
            return 0L;
        }
        long bw = this.file.transferTo(this.position + position, count, target);
        this.byteWritten += bw;
        if (this.byteWritten == this.raf.length()) {
            this.releaseExternalResources();
        }
        return bw;
    }

    @Override
    public void releaseExternalResources() {
        MiscUtils.closeSilently(this.file);
        MiscUtils.closeSilently(this.raf);
    }
}

