/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.providers.netty.request;

import com.ning.http.client.AsyncHandler;
import com.ning.http.client.AsyncHandlerExtensions;
import com.ning.http.client.providers.netty.channel.ChannelManager;
import com.ning.http.client.providers.netty.channel.Channels;
import com.ning.http.client.providers.netty.future.NettyResponseFuture;
import com.ning.http.client.providers.netty.future.StackTraceInspector;
import com.ning.http.client.providers.netty.request.NettyRequestSender;
import com.ning.http.util.AsyncHttpProviderUtils;
import java.net.ConnectException;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.handler.ssl.SslHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NettyConnectListener<T>
implements ChannelFutureListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(NettyConnectListener.class);
    private final NettyResponseFuture<T> future;
    private final NettyRequestSender requestSender;
    private final ChannelManager channelManager;
    private final boolean channelPreempted;
    private final String partition;

    public NettyConnectListener(NettyResponseFuture<T> future, NettyRequestSender requestSender, ChannelManager channelManager, boolean channelPreempted, String partition) {
        this.future = future;
        this.requestSender = requestSender;
        this.channelManager = channelManager;
        this.channelPreempted = channelPreempted;
        this.partition = partition;
    }

    public NettyResponseFuture<T> future() {
        return this.future;
    }

    private void abortChannelPreemption(String partition) {
        if (this.channelPreempted) {
            this.channelManager.abortChannelPreemption(partition);
        }
    }

    private void writeRequest(Channel channel) {
        LOGGER.debug("Request using non cached Channel '{}':\n{}\n", (Object)channel, (Object)this.future.getNettyRequest().getHttpRequest());
        Channels.setAttribute(channel, this.future);
        if (this.future.isDone()) {
            this.abortChannelPreemption(this.partition);
            return;
        }
        if (this.future.getAsyncHandler() instanceof AsyncHandlerExtensions) {
            ((AsyncHandlerExtensions)AsyncHandlerExtensions.class.cast(this.future.getAsyncHandler())).onConnectionOpen();
        }
        this.channelManager.registerOpenChannel(channel, this.partition);
        this.future.attachChannel(channel, false);
        this.requestSender.writeRequest(this.future, channel);
    }

    private void onFutureSuccess(final Channel channel) throws ConnectException {
        SslHandler sslHandler = channel.getPipeline().get(SslHandler.class);
        if (sslHandler != null) {
            sslHandler.handshake().addListener(new ChannelFutureListener(){

                @Override
                public void operationComplete(ChannelFuture handshakeFuture) throws Exception {
                    if (handshakeFuture.isSuccess()) {
                        AsyncHandler asyncHandler = NettyConnectListener.this.future.getAsyncHandler();
                        if (asyncHandler instanceof AsyncHandlerExtensions) {
                            ((AsyncHandlerExtensions)AsyncHandlerExtensions.class.cast(asyncHandler)).onSslHandshakeCompleted();
                        }
                        NettyConnectListener.this.writeRequest(channel);
                    } else {
                        NettyConnectListener.this.onFutureFailure(channel, handshakeFuture.getCause());
                    }
                }
            });
        } else {
            this.writeRequest(channel);
        }
    }

    private void onFutureFailure(Channel channel, Throwable cause) {
        this.abortChannelPreemption(this.partition);
        boolean canRetry = this.future.canRetry();
        LOGGER.debug("Trying to recover from failing to connect channel {} with a retry value of {} ", (Object)channel, (Object)canRetry);
        if (canRetry && cause != null && (this.future.getState() != NettyResponseFuture.STATE.NEW || StackTraceInspector.recoverOnDisconnectException(cause)) && this.requestSender.retry(this.future)) {
            return;
        }
        LOGGER.debug("Failed to recover from connect exception: {} with channel {}", (Object)cause, (Object)channel);
        boolean printCause = cause != null && cause.getMessage() != null;
        String printedCause = printCause ? cause.getMessage() : AsyncHttpProviderUtils.getBaseUrl(this.future.getUri());
        ConnectException e = new ConnectException(printedCause);
        if (cause != null) {
            e.initCause(cause);
        }
        this.future.abort(e);
    }

    @Override
    public final void operationComplete(ChannelFuture f) throws Exception {
        Channel channel = f.getChannel();
        if (f.isSuccess()) {
            this.onFutureSuccess(channel);
        } else {
            this.onFutureFailure(channel, f.getCause());
        }
    }
}

