/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.wasync.transport;

import com.ning.http.client.AsyncHandler;
import com.ning.http.client.FluentStringsMap;
import com.ning.http.client.HttpResponseBodyPart;
import com.ning.http.client.HttpResponseHeaders;
import com.ning.http.client.HttpResponseStatus;
import com.ning.http.client.RequestBuilder;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.atmosphere.wasync.Decoder;
import org.atmosphere.wasync.Event;
import org.atmosphere.wasync.FunctionResolver;
import org.atmosphere.wasync.FunctionWrapper;
import org.atmosphere.wasync.Future;
import org.atmosphere.wasync.Options;
import org.atmosphere.wasync.Request;
import org.atmosphere.wasync.Socket;
import org.atmosphere.wasync.Transport;
import org.atmosphere.wasync.transport.TransportsUtil;
import org.atmosphere.wasync.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamTransport
implements AsyncHandler<String>,
Transport {
    private static final String DEFAULT_CHARSET = "UTF-8";
    private final Logger logger = LoggerFactory.getLogger(StreamTransport.class);
    protected final List<FunctionWrapper> functions;
    protected final List<Decoder<? extends Object, ?>> decoders;
    protected String charSet = "UTF-8";
    protected final FunctionResolver resolver;
    protected final Options options;
    protected final RequestBuilder requestBuilder;
    protected final Request request;
    protected final AtomicBoolean closed = new AtomicBoolean(false);
    protected final boolean isBinary;
    protected Socket.STATUS status = Socket.STATUS.INIT;
    protected final AtomicBoolean errorHandled = new AtomicBoolean();
    protected Future underlyingFuture;
    protected Future connectOperationFuture;
    protected final boolean protocolEnabled;
    protected final ScheduledExecutorService timer;

    public StreamTransport(RequestBuilder requestBuilder, Options options, Request request, List<FunctionWrapper> functions) {
        this.decoders = request.decoders();
        if (this.decoders.size() == 0) {
            this.decoders.add(new Decoder<String, Object>(){

                @Override
                public Object decode(Event e, String s) {
                    return s;
                }
            });
        }
        this.functions = functions;
        this.resolver = request.functionResolver();
        this.options = options;
        this.requestBuilder = requestBuilder;
        this.request = request;
        this.protocolEnabled = request.queryString().get("X-atmo-protocol") != null;
        this.isBinary = options.binary() || request.headers().get("Content-Type") != null && request.headers().get("Content-Type").contains("application/octet-stream");
        this.timer = Executors.newSingleThreadScheduledExecutor();
    }

    @Override
    public Transport registerF(FunctionWrapper function) {
        this.functions.add(function);
        return this;
    }

    @Override
    public void onThrowable(Throwable t) {
        if (CancellationException.class.isAssignableFrom(t.getClass())) {
            return;
        }
        if (this.request != null) {
            this.logger.warn("StreamTransport notified with exception {} for request : {}", (Object)t, (Object)this.request.uri());
        }
        this.logger.warn("", t);
        this.status = Socket.STATUS.ERROR;
        this.connectFutureException(t);
        this.errorHandled.set(TransportsUtil.invokeFunction(Event.ERROR, this.decoders, this.functions, t.getClass(), t, Event.ERROR.name(), this.resolver));
    }

    @Override
    public AsyncHandler.STATE onBodyPartReceived(HttpResponseBodyPart bodyPart) throws Exception {
        if (this.isBinary) {
            byte[] payload = bodyPart.getBodyPartBytes();
            if (!Utils.whiteSpace(payload)) {
                TransportsUtil.invokeFunction(this.decoders, this.functions, payload.getClass(), payload, Event.MESSAGE.name(), this.resolver);
                this.unlockFuture();
            }
        } else {
            String m = new String(bodyPart.getBodyPartBytes(), this.charSet).trim();
            if (m.length() > 0) {
                TransportsUtil.invokeFunction(this.decoders, this.functions, m.getClass(), m, Event.MESSAGE.name(), this.resolver);
                this.unlockFuture();
            }
        }
        return AsyncHandler.STATE.CONTINUE;
    }

    void unlockFuture() {
        if (this.connectOperationFuture != null && this.protocolEnabled) {
            this.triggerOpen();
            try {
                this.connectOperationFuture.finishOrThrowException();
            }
            catch (IOException e) {
                this.logger.warn("", e);
            }
        }
    }

    @Override
    public AsyncHandler.STATE onHeadersReceived(HttpResponseHeaders headers) throws Exception {
        TransportsUtil.invokeFunction(Event.HEADERS, this.decoders, this.functions, Map.class, headers.getHeaders(), Event.HEADERS.name(), this.resolver);
        return AsyncHandler.STATE.CONTINUE;
    }

    void futureDone() {
        if (this.underlyingFuture != null) {
            this.underlyingFuture.done();
        }
    }

    @Override
    public AsyncHandler.STATE onStatusReceived(HttpResponseStatus responseStatus) throws Exception {
        if (this.connectOperationFuture != null && !this.protocolEnabled) {
            this.connectOperationFuture.finishOrThrowException();
        }
        TransportsUtil.invokeFunction(Event.TRANSPORT, this.decoders, this.functions, Request.TRANSPORT.class, (Object)this.name(), Event.TRANSPORT.name(), this.resolver);
        this.errorHandled.set(false);
        this.closed.set(false);
        if (!this.protocolEnabled) {
            this.triggerOpen();
        }
        TransportsUtil.invokeFunction(Event.MESSAGE, this.decoders, this.functions, Integer.class, new Integer(responseStatus.getStatusCode()), Event.STATUS.name(), this.resolver);
        return AsyncHandler.STATE.CONTINUE;
    }

    void triggerOpen() {
        Event newStatus = this.status.equals((Object)Socket.STATUS.INIT) ? Event.OPEN : Event.REOPENED;
        this.status = Socket.STATUS.OPEN;
        TransportsUtil.invokeFunction(newStatus, this.decoders, this.functions, String.class, newStatus.name(), newStatus.name(), this.resolver);
    }

    @Override
    public String onCompleted() throws Exception {
        this.futureDone();
        if (this.closed.get()) {
            return "";
        }
        if (this.status == Socket.STATUS.ERROR) {
            return "";
        }
        if (this.options.reconnect()) {
            this.close(false);
            if (this.options.reconnectTimeoutInMilliseconds() > 0) {
                this.timer.schedule(new Runnable(){

                    @Override
                    public void run() {
                        StreamTransport.this.status = Socket.STATUS.REOPENED;
                        StreamTransport.this.reconnect();
                    }
                }, (long)this.options.reconnectTimeoutInMilliseconds(), TimeUnit.MILLISECONDS);
            } else {
                this.status = Socket.STATUS.REOPENED;
                this.reconnect();
            }
        } else {
            this.close();
        }
        return "";
    }

    void reconnect() {
        Map<String, List<String>> c = this.request.queryString();
        FluentStringsMap f = new FluentStringsMap();
        f.putAll((Map<? extends String, ? extends List<String>>)c);
        this.options.runtime().executeRequest(((RequestBuilder)this.requestBuilder.setQueryParams((Map)f)).build(), this);
    }

    @Override
    public Request.TRANSPORT name() {
        return Request.TRANSPORT.STREAMING;
    }

    @Override
    public void close() {
        this.close(true);
    }

    private void close(boolean force) {
        if (force && this.closed.getAndSet(true)) {
            return;
        }
        this.status = Socket.STATUS.CLOSE;
        if (force) {
            this.timer.shutdown();
        }
        TransportsUtil.invokeFunction(Event.CLOSE, this.decoders, this.functions, String.class, Event.CLOSE.name(), Event.CLOSE.name(), this.resolver);
        if (this.underlyingFuture != null) {
            this.underlyingFuture.cancel(false);
        }
    }

    @Override
    public Socket.STATUS status() {
        return this.status;
    }

    @Override
    public boolean errorHandled() {
        return this.errorHandled.get();
    }

    void connectFutureException(Throwable t) {
        IOException e = IOException.class.isAssignableFrom(t.getClass()) ? (IOException)IOException.class.cast(t) : new IOException(t);
        this.connectOperationFuture.ioException(e);
    }

    @Override
    public void error(Throwable t) {
        this.logger.warn("", t);
        this.connectFutureException(t);
        TransportsUtil.invokeFunction(Event.ERROR, this.decoders, this.functions, t.getClass(), t, Event.ERROR.name(), this.resolver);
    }

    @Override
    public void future(Future f) {
        this.underlyingFuture = f;
    }

    @Override
    public void connectedFuture(Future f) {
        this.connectOperationFuture = f;
    }
}

