/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.wasync.transport;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.atmosphere.wasync.Decoder;
import org.atmosphere.wasync.Event;
import org.atmosphere.wasync.Function;
import org.atmosphere.wasync.FunctionResolver;
import org.atmosphere.wasync.FunctionWrapper;
import org.atmosphere.wasync.ReplayDecoder;
import org.atmosphere.wasync.util.TypeResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransportsUtil {
    private static final Logger logger = LoggerFactory.getLogger(TransportsUtil.class);

    public static boolean invokeFunction(List<Decoder<? extends Object, ?>> decoders, List<FunctionWrapper> functions, Class<?> implementedType, Object instanceType, String functionName, FunctionResolver resolver) {
        return TransportsUtil.invokeFunction(Event.MESSAGE, decoders, functions, implementedType, instanceType, functionName, resolver);
    }

    public static boolean invokeFunction(Event e, List<Decoder<? extends Object, ?>> decoders, List<FunctionWrapper> functions, Class<?> implementedType, Object instanceType, String functionName, FunctionResolver resolver) {
        Function<?> f;
        boolean hasMatch = false;
        String originalMessage = instanceType == null ? "" : instanceType.toString();
        List<Object> decodedObjects = new CopyOnWriteArrayList<Object>();
        if (instanceType != null) {
            decodedObjects = TransportsUtil.matchDecoder(e, instanceType, decoders, decodedObjects);
        }
        for (FunctionWrapper wrapper : functions) {
            f = wrapper.function();
            Class[] typeArguments = TypeResolver.resolveArguments(f.getClass(), Function.class);
            if (typeArguments == null) {
                logger.trace("Lambda function should not be used. Inferring type as String.class");
                typeArguments = new Class[]{String.class};
            }
            if (typeArguments.length <= 0 || instanceType == null) continue;
            boolean b = false;
            if (decodedObjects.isEmpty()) {
                implementedType = instanceType.getClass();
                b = TransportsUtil.matchFunction(instanceType, typeArguments, implementedType, resolver, originalMessage, functionName, wrapper, f);
            } else {
                for (Object o : decodedObjects) {
                    if (Decoder.Decoded.class.isAssignableFrom(o.getClass())) continue;
                    b = TransportsUtil.matchFunction(o, typeArguments, o.getClass(), resolver, originalMessage, functionName, wrapper, f);
                }
            }
            if (!b) continue;
            hasMatch = true;
        }
        if (!hasMatch && !e.equals((Object)Event.MESSAGE)) {
            for (FunctionWrapper wrapper : functions) {
                f = wrapper.function();
                if (!wrapper.functionName().equalsIgnoreCase(functionName)) continue;
                hasMatch = true;
                logger.trace("{} .on {}", (Object)functionName, instanceType);
                f.on(originalMessage);
            }
        }
        return hasMatch;
    }

    public static boolean matchFunction(Object instanceType, Class[] typeArguments, Class<?> implementedType, FunctionResolver resolver, String originalMessage, Object functionName, FunctionWrapper wrapper, Function f) {
        boolean hasMatch = false;
        if (instanceType != null && typeArguments.length > 0 && typeArguments[0].isAssignableFrom(implementedType) && resolver.resolve(originalMessage, functionName, wrapper)) {
            hasMatch = true;
            logger.trace("{} .on {}", functionName, instanceType);
            try {
                f.on(instanceType);
            }
            catch (Exception e) {
                logger.warn("Function {} thrown an exception", functionName, (Object)e);
            }
        }
        return hasMatch;
    }

    public static List<Object> matchDecoder(Event e, Object instanceType, List<Decoder<? extends Object, ?>> decoders, List<Object> decodedObjects) {
        for (Decoder<Object, ?> d : decoders) {
            Class<?>[] typeArguments = TypeResolver.resolveArguments(d.getClass(), Decoder.class);
            if (instanceType == null || typeArguments.length <= 0 || !typeArguments[0].isAssignableFrom(instanceType.getClass())) continue;
            boolean replay = ReplayDecoder.class.isAssignableFrom(d.getClass());
            logger.trace("{} is trying to decode {}", (Object)d, instanceType);
            Object decoded = null;
            try {
                decoded = d.decode(e, instanceType);
            }
            catch (Exception ex) {
                logger.warn("Decoder exception", ex);
            }
            if (decoded != null && Decoder.Decoded.class.isAssignableFrom(decoded.getClass())) {
                Decoder.Decoded o = (Decoder.Decoded)Decoder.Decoded.class.cast(decoded);
                if (o.action().equals((Object)Decoder.Decoded.ACTION.ABORT)) {
                    logger.trace("Decoder {} fully decoded {}", (Object)d, instanceType);
                    decodedObjects.add(o);
                    break;
                }
                decoded = o.decoded();
            }
            if (replay && decoded != null && List.class.isAssignableFrom(decoded.getClass())) {
                List l = (List)List.class.cast(decoded);
                if (l.isEmpty()) continue;
                ArrayList nd = new ArrayList();
                boolean add = false;
                for (Decoder<Object, ?> d2 : decoders) {
                    if (d2.equals(d)) {
                        add = true;
                        continue;
                    }
                    if (!add) continue;
                    nd.add(d2);
                }
                if (nd.isEmpty()) {
                    return l;
                }
                Iterator<Decoder<Object, Object>> iterator = l.iterator();
                if (!iterator.hasNext()) continue;
                Decoder<Object, Object> m = iterator.next();
                return TransportsUtil.matchDecoder(e, m, nd, decodedObjects);
            }
            if (decoded == null) continue;
            logger.trace("Decoder {} match {}", (Object)d, instanceType);
            decodedObjects.add(decoded);
        }
        return decodedObjects;
    }
}

