/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.providers.grizzly;

import com.ning.http.client.AsyncHandler;
import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.AsyncHttpProvider;
import com.ning.http.client.FluentCaseInsensitiveStringsMap;
import com.ning.http.client.ListenableFuture;
import com.ning.http.client.ProxyServer;
import com.ning.http.client.Realm;
import com.ning.http.client.Request;
import com.ning.http.client.SSLEngineFactory;
import com.ning.http.client.UpgradeHandler;
import com.ning.http.client.cookie.Cookie;
import com.ning.http.client.listener.TransferCompletionHandler;
import com.ning.http.client.ntlm.NTLMEngine;
import com.ning.http.client.providers.grizzly.AhcEventFilter;
import com.ning.http.client.providers.grizzly.AhcHttpContext;
import com.ning.http.client.providers.grizzly.AhcSSLEngineConfigurator;
import com.ning.http.client.providers.grizzly.ConnectionManager;
import com.ning.http.client.providers.grizzly.GrizzlyAsyncHttpProviderConfig;
import com.ning.http.client.providers.grizzly.GrizzlyResponseFuture;
import com.ning.http.client.providers.grizzly.HostnameVerifierListener;
import com.ning.http.client.providers.grizzly.HttpTransactionContext;
import com.ning.http.client.providers.grizzly.PayloadGenFactory;
import com.ning.http.client.providers.grizzly.PayloadGenerator;
import com.ning.http.client.providers.grizzly.SwitchingSSLFilter;
import com.ning.http.client.providers.grizzly.TransportCustomizer;
import com.ning.http.client.providers.grizzly.Utils;
import com.ning.http.client.providers.grizzly.events.ContinueEvent;
import com.ning.http.client.providers.grizzly.events.SSLSwitchingEvent;
import com.ning.http.client.uri.Uri;
import com.ning.http.util.AsyncHttpProviderUtils;
import com.ning.http.util.AuthenticatorUtils;
import com.ning.http.util.MiscUtils;
import com.ning.http.util.ProxyUtils;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.SecureRandom;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.net.ssl.SSLContext;
import org.glassfish.grizzly.Closeable;
import org.glassfish.grizzly.CompletionHandler;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.IOStrategy;
import org.glassfish.grizzly.OutputSink;
import org.glassfish.grizzly.Processor;
import org.glassfish.grizzly.WriteResult;
import org.glassfish.grizzly.attributes.AttributeStorage;
import org.glassfish.grizzly.filterchain.BaseFilter;
import org.glassfish.grizzly.filterchain.Filter;
import org.glassfish.grizzly.filterchain.FilterChainBuilder;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.filterchain.FilterChainEvent;
import org.glassfish.grizzly.filterchain.NextAction;
import org.glassfish.grizzly.filterchain.TransportFilter;
import org.glassfish.grizzly.http.ContentEncoding;
import org.glassfish.grizzly.http.EncodingFilter;
import org.glassfish.grizzly.http.GZipContentEncoding;
import org.glassfish.grizzly.http.HttpContext;
import org.glassfish.grizzly.http.HttpHeader;
import org.glassfish.grizzly.http.HttpRequestPacket;
import org.glassfish.grizzly.http.HttpResponsePacket;
import org.glassfish.grizzly.http.Method;
import org.glassfish.grizzly.http.Protocol;
import org.glassfish.grizzly.http.util.CookieSerializerUtils;
import org.glassfish.grizzly.http.util.DataChunk;
import org.glassfish.grizzly.http.util.Header;
import org.glassfish.grizzly.http.util.MimeHeaders;
import org.glassfish.grizzly.nio.NIOChannelDistributor;
import org.glassfish.grizzly.nio.NIOTransport;
import org.glassfish.grizzly.nio.RoundRobinConnectionDistributor;
import org.glassfish.grizzly.nio.transport.TCPNIOTransport;
import org.glassfish.grizzly.nio.transport.TCPNIOTransportBuilder;
import org.glassfish.grizzly.strategies.SameThreadIOStrategy;
import org.glassfish.grizzly.strategies.WorkerThreadIOStrategy;
import org.glassfish.grizzly.threadpool.ThreadPoolConfig;
import org.glassfish.grizzly.utils.DelayedExecutor;
import org.glassfish.grizzly.utils.IdleTimeoutFilter;
import org.glassfish.grizzly.websockets.Version;
import org.glassfish.grizzly.websockets.WebSocketFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrizzlyAsyncHttpProvider
implements AsyncHttpProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(GrizzlyAsyncHttpProvider.class);
    private final TCPNIOTransport clientTransport;
    private final AsyncHttpClientConfig clientConfig;
    private final GrizzlyAsyncHttpProviderConfig providerConfig;
    private final ConnectionManager connectionManager;
    DelayedExecutor.Resolver<Connection> resolver;
    private DelayedExecutor timeoutExecutor;

    public GrizzlyAsyncHttpProvider(AsyncHttpClientConfig clientConfig) {
        this.clientConfig = clientConfig;
        this.providerConfig = clientConfig.getAsyncHttpProviderConfig() instanceof GrizzlyAsyncHttpProviderConfig ? (GrizzlyAsyncHttpProviderConfig)clientConfig.getAsyncHttpProviderConfig() : new GrizzlyAsyncHttpProviderConfig();
        TCPNIOTransportBuilder builder = TCPNIOTransportBuilder.newInstance();
        this.clientTransport = builder.build();
        this.initializeTransport(clientConfig);
        this.connectionManager = new ConnectionManager(this, this.clientTransport, this.providerConfig);
        try {
            this.clientTransport.start();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    AsyncHttpClientConfig getClientConfig() {
        return this.clientConfig;
    }

    ConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    @Override
    public <T> ListenableFuture<T> execute(final Request request, AsyncHandler<T> asyncHandler) {
        if (this.clientTransport.isStopped()) {
            IOException e = new IOException("AsyncHttpClient has been closed.");
            asyncHandler.onThrowable(e);
            return new ListenableFuture.CompletedFailure(e);
        }
        final GrizzlyResponseFuture future = new GrizzlyResponseFuture(asyncHandler);
        CompletionHandler<Connection> connectHandler = new CompletionHandler<Connection>(){

            public void cancelled() {
                future.cancel(true);
            }

            public void failed(Throwable throwable) {
                future.abort(throwable);
            }

            public void completed(Connection c) {
                block7: {
                    try {
                        HttpTransactionContext tx = HttpTransactionContext.startTransaction(c, GrizzlyAsyncHttpProvider.this, request, future);
                        if (future.setHttpTransactionCtx(tx)) {
                            GrizzlyAsyncHttpProvider.this.execute(tx);
                        } else {
                            tx.closeConnection();
                        }
                    }
                    catch (Exception e) {
                        if (e instanceof RuntimeException) {
                            this.failed(e);
                        } else if (e instanceof IOException) {
                            this.failed(e);
                        }
                        if (!LOGGER.isWarnEnabled()) break block7;
                        LOGGER.warn(e.toString(), e);
                    }
                }
            }

            public void updated(Connection c) {
            }
        };
        try {
            this.connectionManager.getConnectionAsync(request, future, connectHandler);
        }
        catch (IOException ioe) {
            this.abort(future, ioe);
        }
        catch (RuntimeException re) {
            this.abort(future, re);
        }
        catch (Exception e) {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn(e.toString(), e);
            }
            this.abort(future, e);
        }
        return future;
    }

    private void abort(GrizzlyResponseFuture<?> future, Throwable t) {
        if (!future.isDone()) {
            LOGGER.debug("Aborting Future {}\n", (Object)future);
            LOGGER.debug(t.getMessage(), t);
            future.abort(t);
        }
    }

    @Override
    public void close() {
        try {
            this.connectionManager.destroy();
            this.clientTransport.shutdownNow();
            ExecutorService service = this.clientConfig.executorService();
            if (service != null) {
                service.shutdown();
            }
            if (this.timeoutExecutor != null) {
                this.timeoutExecutor.stop();
                this.timeoutExecutor.getThreadPool().shutdownNow();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    void execute(HttpTransactionContext transactionCtx) throws IOException {
        block4: {
            try {
                transactionCtx.getConnection().write((Object)transactionCtx, this.createWriteCompletionHandler(transactionCtx.future));
            }
            catch (Exception e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                if (!LOGGER.isWarnEnabled()) break block4;
                LOGGER.warn(e.toString(), e);
            }
        }
    }

    protected void initializeTransport(final AsyncHttpClientConfig clientConfig) {
        FilterChainBuilder fcb = FilterChainBuilder.stateless();
        fcb.add((Filter)new TransportFilter());
        final int timeout = clientConfig.getRequestTimeout();
        if (timeout > 0) {
            int delay = 500;
            if (timeout < delay) {
                delay = timeout - 10;
            }
            this.timeoutExecutor = IdleTimeoutFilter.createDefaultIdleDelayedExecutor((long)delay, (TimeUnit)TimeUnit.MILLISECONDS);
            this.timeoutExecutor.start();
            IdleTimeoutFilter.TimeoutResolver timeoutResolver = new IdleTimeoutFilter.TimeoutResolver(){

                public long getTimeout(FilterChainContext ctx) {
                    HttpTransactionContext context = HttpTransactionContext.currentTransaction((AttributeStorage)ctx.getConnection());
                    if (context != null) {
                        if (context.isWSRequest) {
                            return clientConfig.getWebSocketTimeout();
                        }
                        long timeout2 = context.getAhcRequest().getRequestTimeout();
                        if (timeout2 > 0L) {
                            return timeout2;
                        }
                    }
                    return timeout;
                }
            };
            IdleTimeoutFilter timeoutFilter = new IdleTimeoutFilter(this.timeoutExecutor, timeoutResolver, new IdleTimeoutFilter.TimeoutHandler(){

                public void onTimeout(Connection connection) {
                    GrizzlyAsyncHttpProvider.this.timeout(connection);
                }
            });
            fcb.add((Filter)timeoutFilter);
            this.resolver = timeoutFilter.getResolver();
        }
        boolean defaultSecState = clientConfig.getSSLContext() != null;
        AhcSSLEngineConfigurator configurator = new AhcSSLEngineConfigurator(this.providerConfig.getSslEngineFactory() != null ? this.providerConfig.getSslEngineFactory() : new SSLEngineFactory.DefaultSSLEngineFactory(clientConfig));
        SwitchingSSLFilter sslFilter = new SwitchingSSLFilter(configurator, defaultSecState);
        if (clientConfig.getHostnameVerifier() != null) {
            sslFilter.addHandshakeListener(new HostnameVerifierListener());
        }
        fcb.add((Filter)sslFilter);
        AhcEventFilter eventFilter = new AhcEventFilter(this, (Integer)this.providerConfig.getProperty(GrizzlyAsyncHttpProviderConfig.Property.MAX_HTTP_PACKET_HEADER_SIZE));
        AsyncHttpClientFilter clientFilter = new AsyncHttpClientFilter(clientConfig);
        ContentEncoding[] encodings = eventFilter.getContentEncodings();
        if (encodings.length > 0) {
            for (ContentEncoding encoding : encodings) {
                eventFilter.removeContentEncoding(encoding);
            }
        }
        eventFilter.addContentEncoding((ContentEncoding)new GZipContentEncoding(512, 512, (EncodingFilter)new ClientEncodingFilter()));
        fcb.add((Filter)eventFilter);
        fcb.add((Filter)clientFilter);
        this.clientTransport.getAsyncQueueIO().getWriter().setMaxPendingBytesPerConnection(-2);
        this.clientTransport.setNIOChannelDistributor((NIOChannelDistributor)new RoundRobinConnectionDistributor((NIOTransport)this.clientTransport, false, false));
        int kernelThreadsCount = clientConfig.getIoThreadMultiplier() * Runtime.getRuntime().availableProcessors();
        this.clientTransport.setSelectorRunnersCount(kernelThreadsCount);
        this.clientTransport.setKernelThreadPoolConfig(ThreadPoolConfig.defaultConfig().setCorePoolSize(kernelThreadsCount).setMaxPoolSize(kernelThreadsCount).setPoolName("grizzly-ahc-kernel"));
        TransportCustomizer customizer = (TransportCustomizer)this.providerConfig.getProperty(GrizzlyAsyncHttpProviderConfig.Property.TRANSPORT_CUSTOMIZER);
        if (customizer != null) {
            customizer.customize(this.clientTransport, fcb);
        } else {
            this.doDefaultTransportConfig();
        }
        fcb.add((Filter)new WebSocketFilter());
        this.clientTransport.setProcessor((Processor)fcb.build());
    }

    void touchConnection(Connection c, Request request) {
        long timeOut;
        long l = timeOut = request.getRequestTimeout() > 0 ? (long)request.getRequestTimeout() : (long)this.clientConfig.getRequestTimeout();
        if (timeOut > 0L && this.resolver != null) {
            this.resolver.setTimeoutMillis((Object)c, System.currentTimeMillis() + timeOut);
        }
    }

    private static boolean configSendFileSupport() {
        return (!System.getProperty("os.name").equalsIgnoreCase("linux") || GrizzlyAsyncHttpProvider.linuxSendFileSupported()) && !System.getProperty("os.name").equalsIgnoreCase("HP-UX");
    }

    private static boolean linuxSendFileSupported() {
        String version = System.getProperty("java.version");
        if (version.startsWith("1.6")) {
            int idx = version.indexOf(95);
            if (idx == -1) {
                return false;
            }
            int patchRev = Integer.parseInt(version.substring(idx + 1));
            return patchRev >= 18;
        }
        return version.startsWith("1.7") || version.startsWith("1.8");
    }

    private void doDefaultTransportConfig() {
        ExecutorService service = this.clientConfig.executorService();
        if (service != null) {
            this.clientTransport.setIOStrategy((IOStrategy)WorkerThreadIOStrategy.getInstance());
            this.clientTransport.setWorkerThreadPool(service);
        } else {
            this.clientTransport.setIOStrategy((IOStrategy)SameThreadIOStrategy.getInstance());
        }
    }

    private <T> CompletionHandler<WriteResult> createWriteCompletionHandler(final GrizzlyResponseFuture<T> future) {
        return new CompletionHandler<WriteResult>(){

            public void cancelled() {
                future.cancel(true);
            }

            public void failed(Throwable throwable) {
                future.abort(throwable);
            }

            public void completed(WriteResult result) {
            }

            public void updated(WriteResult result) {
            }
        };
    }

    void timeout(Connection c) {
        HttpTransactionContext tx = HttpTransactionContext.currentTransaction((AttributeStorage)c);
        TimeoutException te = new TimeoutException("Timeout exceeded");
        if (tx != null) {
            tx.abort(te);
        }
        c.closeWithReason(new IOException("Timeout exceeded", te));
    }

    boolean sendRequest(HttpTransactionContext httpTxCtx, FilterChainContext ctx, HttpRequestPacket requestPacket, PayloadGenerator payloadGenerator) throws IOException {
        Connection connection = httpTxCtx.getConnection();
        Request request = httpTxCtx.getAhcRequest();
        AsyncHandler h = httpTxCtx.getAsyncHandler();
        AhcHttpContext httpCtx = new AhcHttpContext((AttributeStorage)connection, (OutputSink)connection, (Closeable)connection, requestPacket, httpTxCtx);
        HttpTransactionContext.bind(httpCtx, httpTxCtx);
        requestPacket.getProcessingState().setHttpContext((HttpContext)httpCtx);
        httpCtx.attach(ctx);
        if (h instanceof TransferCompletionHandler) {
            FluentCaseInsensitiveStringsMap map = new FluentCaseInsensitiveStringsMap(request.getHeaders());
            ((TransferCompletionHandler)TransferCompletionHandler.class.cast(h)).headers(map);
        }
        requestPacket.setConnection(ctx.getConnection());
        boolean isWriteComplete = true;
        if (payloadGenerator != null) {
            httpTxCtx.payloadGenerator = payloadGenerator;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("REQUEST: " + requestPacket.toString());
            }
            isWriteComplete = payloadGenerator.generate(ctx, request, requestPacket);
        } else {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("REQUEST: " + requestPacket.toString());
            }
            ctx.write((Object)requestPacket, ctx.getTransportContext().getCompletionHandler());
        }
        return isWriteComplete;
    }

    public static void main(String[] args) {
        SecureRandom secureRandom = new SecureRandom();
        SSLContext sslContext = null;
        try {
            sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, null, secureRandom);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        AsyncHttpClientConfig config = new AsyncHttpClientConfig.Builder().setConnectTimeout(5000).setSSLContext(sslContext).build();
        AsyncHttpClient client = new AsyncHttpClient(new GrizzlyAsyncHttpProvider(config), config);
        long start = System.currentTimeMillis();
        try {
            client.executeRequest(client.prepareGet("http://www.google.com").build()).get();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        LOGGER.debug("COMPLETE: " + (System.currentTimeMillis() - start) + "ms");
    }

    private static final class ClientEncodingFilter
    implements EncodingFilter {
        private ClientEncodingFilter() {
        }

        public boolean applyEncoding(HttpHeader httpPacket) {
            return false;
        }

        public boolean applyDecoding(HttpHeader httpPacket) {
            HttpResponsePacket httpResponse = (HttpResponsePacket)httpPacket;
            DataChunk bc = httpResponse.getHeaders().getValue(Header.ContentEncoding);
            return bc != null && bc.indexOf("gzip", 0) != -1;
        }
    }

    private final class AsyncHttpClientFilter
    extends BaseFilter {
        private final AsyncHttpClientConfig config;

        AsyncHttpClientFilter(AsyncHttpClientConfig config) {
            this.config = config;
        }

        public NextAction handleWrite(FilterChainContext ctx) throws IOException {
            Object message = ctx.getMessage();
            if (message instanceof HttpTransactionContext) {
                ctx.setMessage(null);
                if (!this.sendAsGrizzlyRequest((HttpTransactionContext)message, ctx)) {
                    return ctx.getSuspendAction();
                }
                return ctx.getStopAction();
            }
            return ctx.getInvokeAction();
        }

        public NextAction handleEvent(FilterChainContext ctx, FilterChainEvent event) throws IOException {
            Object type = event.type();
            if (type == ContinueEvent.class) {
                ContinueEvent continueEvent = (ContinueEvent)event;
                continueEvent.getContext().payloadGenerator.continueConfirmed(ctx);
            }
            return ctx.getStopAction();
        }

        private boolean sendAsGrizzlyRequest(HttpTransactionContext httpTxCtx, FilterChainContext ctx) throws IOException {
            HttpRequestPacket requestPacket;
            PayloadGenerator payloadGenerator;
            boolean isEstablishingConnectTunnel;
            Connection connection = ctx.getConnection();
            Request ahcRequest = httpTxCtx.getAhcRequest();
            if (this.isUpgradeRequest(httpTxCtx.getAsyncHandler()) && this.isWSRequest(httpTxCtx.requestUri)) {
                httpTxCtx.isWSRequest = true;
                this.convertToUpgradeRequest(httpTxCtx);
            }
            Request req = httpTxCtx.getAhcRequest();
            Method method = Method.valueOf((String)ahcRequest.getMethod());
            Uri uri = req.getUri();
            boolean secure = "https".equals(uri.getScheme());
            ProxyServer proxy = ProxyUtils.getProxyServer(this.config, ahcRequest);
            boolean useProxy = proxy != null;
            boolean bl = isEstablishingConnectTunnel = useProxy && (secure || httpTxCtx.isWSRequest) && !httpTxCtx.isTunnelEstablished(connection);
            if (isEstablishingConnectTunnel) {
                return this.establishConnectTunnel(proxy, httpTxCtx, uri, ctx);
            }
            HttpRequestPacket.Builder builder = ((HttpRequestPacket.Builder)HttpRequestPacket.builder().protocol(Protocol.HTTP_1_1)).method(method);
            if (useProxy) {
                if (secure || httpTxCtx.isWSRequest) {
                    if (this.config.isUseRelativeURIsWithConnectProxies()) {
                        builder.uri(AsyncHttpProviderUtils.getNonEmptyPath(uri));
                        builder.query(uri.getQuery());
                    } else {
                        builder.uri(uri.toUrl());
                    }
                } else {
                    builder.uri(uri.toUrl());
                }
            } else {
                builder.uri(AsyncHttpProviderUtils.getNonEmptyPath(uri));
                builder.query(uri.getQuery());
            }
            PayloadGenerator payloadGenerator2 = payloadGenerator = this.isPayloadAllowed(method) ? PayloadGenFactory.getPayloadGenerator(ahcRequest) : null;
            if (payloadGenerator != null) {
                long contentLength = ahcRequest.getContentLength();
                if (contentLength >= 0L) {
                    builder.contentLength(contentLength);
                    builder.chunked(false);
                } else {
                    builder.chunked(true);
                }
            }
            if (httpTxCtx.isWSRequest) {
                try {
                    URI wsURI = httpTxCtx.wsRequestURI.toJavaNetURI();
                    secure = "wss".equalsIgnoreCase(wsURI.getScheme());
                    httpTxCtx.protocolHandler = Version.RFC6455.createHandler(true);
                    httpTxCtx.handshake = httpTxCtx.protocolHandler.createClientHandShake(wsURI);
                    requestPacket = (HttpRequestPacket)httpTxCtx.handshake.composeHeaders().getHttpHeader();
                }
                catch (URISyntaxException e) {
                    throw new IllegalArgumentException("Invalid WS URI: " + httpTxCtx.wsRequestURI);
                }
            } else {
                requestPacket = builder.build();
            }
            requestPacket.setSecure(secure);
            ctx.notifyDownstream((FilterChainEvent)new SSLSwitchingEvent(secure, connection));
            this.copyHeaders(ahcRequest, requestPacket);
            this.addCookies(ahcRequest, requestPacket);
            this.addHostHeaderIfNeeded(ahcRequest, uri, requestPacket);
            this.addServiceHeaders(requestPacket);
            this.addAcceptHeaders(requestPacket);
            this.addAuthorizationHeader(connection, this.getRealm(ahcRequest), requestPacket);
            if (useProxy) {
                this.addProxyHeaders(proxy, requestPacket);
            }
            return GrizzlyAsyncHttpProvider.this.sendRequest(httpTxCtx, ctx, requestPacket, this.wrapWithExpectHandlerIfNeeded(payloadGenerator, requestPacket));
        }

        private boolean establishConnectTunnel(ProxyServer proxy, HttpTransactionContext httpCtx, Uri uri, FilterChainContext ctx) throws IOException {
            Connection connection = ctx.getConnection();
            HttpRequestPacket requestPacket = ((HttpRequestPacket.Builder)HttpRequestPacket.builder().protocol(Protocol.HTTP_1_0)).method(Method.CONNECT).uri(AsyncHttpProviderUtils.getAuthority(uri)).build();
            httpCtx.establishingTunnel = true;
            ctx.notifyDownstream((FilterChainEvent)new SSLSwitchingEvent(false, connection));
            Request request = httpCtx.getAhcRequest();
            this.addHostHeaderIfNeeded(request, uri, requestPacket);
            this.addServiceHeaders(requestPacket);
            this.addAuthorizationHeader(connection, this.getRealm(request), requestPacket);
            this.addProxyHeaders(proxy, requestPacket);
            return GrizzlyAsyncHttpProvider.this.sendRequest(httpCtx, ctx, requestPacket, null);
        }

        private PayloadGenerator wrapWithExpectHandlerIfNeeded(PayloadGenerator payloadGenerator, HttpRequestPacket requestPacket) {
            if (payloadGenerator == null) {
                return null;
            }
            MimeHeaders headers = requestPacket.getHeaders();
            int expectHeaderIdx = headers.indexOf(Header.Expect, 0);
            return expectHeaderIdx != -1 && headers.getValue(expectHeaderIdx).equalsIgnoreCase("100-Continue") ? PayloadGenFactory.wrapWithExpect(payloadGenerator) : payloadGenerator;
        }

        private boolean isPayloadAllowed(Method method) {
            return method.getPayloadExpectation() != Method.PayloadExpectation.NOT_ALLOWED;
        }

        private void addAuthorizationHeader(Connection c, Realm realm, HttpRequestPacket requestPacket) {
            String authHeaderValue;
            if (realm != null && realm.getUsePreemptiveAuth() && (authHeaderValue = this.generateAuthHeader(c, realm)) != null) {
                requestPacket.addHeader(Header.Authorization, authHeaderValue);
            }
        }

        private void addProxyHeaders(ProxyServer proxy, HttpRequestPacket requestPacket) {
            if (!requestPacket.getHeaders().contains(Header.ProxyConnection)) {
                requestPacket.setHeader(Header.ProxyConnection, "keep-alive");
            }
            if (proxy.getPrincipal() != null) {
                requestPacket.setHeader(Header.ProxyAuthorization, AuthenticatorUtils.computeBasicAuthentication(proxy));
            }
        }

        private void addHostHeaderIfNeeded(Request request, Uri uri, HttpRequestPacket requestPacket) {
            if (!requestPacket.containsHeader(Header.Host)) {
                String host = request.getVirtualHost();
                if (host != null) {
                    requestPacket.addHeader(Header.Host, host);
                } else if (uri.getPort() == -1) {
                    requestPacket.addHeader(Header.Host, uri.getHost());
                } else {
                    requestPacket.addHeader(Header.Host, uri.getHost() + ':' + uri.getPort());
                }
            }
        }

        private Realm getRealm(Request request) {
            return request.getRealm() != null ? request.getRealm() : this.config.getRealm();
        }

        private String generateAuthHeader(Connection c, Realm realm) {
            try {
                switch (realm.getScheme()) {
                    case BASIC: {
                        return AuthenticatorUtils.computeBasicAuthentication(realm);
                    }
                    case DIGEST: {
                        return AuthenticatorUtils.computeDigestAuthentication(realm);
                    }
                    case NTLM: {
                        return !Utils.getAndSetNtlmAttempted(c) ? "NTLM " + NTLM_INSTANCE_HOLDER.ntlmEngine.generateType1Msg() : null;
                    }
                }
                return null;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        private boolean isUpgradeRequest(AsyncHandler handler) {
            return handler instanceof UpgradeHandler;
        }

        private boolean isWSRequest(Uri requestUri) {
            return requestUri.getScheme().startsWith("ws");
        }

        private void convertToUpgradeRequest(HttpTransactionContext ctx) {
            Uri requestUri;
            ctx.wsRequestURI = requestUri = ctx.requestUri;
            ctx.requestUri = requestUri.withNewScheme("ws".equals(requestUri.getScheme()) ? "http" : "https");
        }

        private void copyHeaders(Request request, HttpRequestPacket requestPacket) {
            FluentCaseInsensitiveStringsMap map = request.getHeaders();
            if (MiscUtils.isNonEmpty(map)) {
                for (Map.Entry<String, List<String>> entry : map.entrySet()) {
                    String headerName = entry.getKey();
                    List<String> headerValues = entry.getValue();
                    if (!MiscUtils.isNonEmpty(headerValues)) continue;
                    for (String headerValue : headerValues) {
                        requestPacket.addHeader(headerName, headerValue);
                    }
                }
            }
        }

        private void addServiceHeaders(HttpRequestPacket requestPacket) {
            MimeHeaders headers = requestPacket.getHeaders();
            if (!headers.contains(Header.Connection)) {
                requestPacket.addHeader(Header.Connection, "keep-alive");
            }
            if (!headers.contains(Header.UserAgent)) {
                requestPacket.addHeader(Header.UserAgent, this.config.getUserAgent());
            }
        }

        private void addAcceptHeaders(HttpRequestPacket requestPacket) {
            MimeHeaders headers = requestPacket.getHeaders();
            if (GrizzlyAsyncHttpProvider.this.clientConfig.isCompressionEnforced() && !headers.contains(Header.AcceptEncoding)) {
                requestPacket.addHeader(Header.AcceptEncoding, "gzip");
            }
            if (!headers.contains(Header.Accept)) {
                requestPacket.addHeader(Header.Accept, "*/*");
            }
        }

        private void addCookies(Request request, HttpRequestPacket requestPacket) {
            Collection<Cookie> cookies = request.getCookies();
            if (MiscUtils.isNonEmpty(cookies)) {
                StringBuilder sb = new StringBuilder(128);
                org.glassfish.grizzly.http.Cookie[] gCookies = new org.glassfish.grizzly.http.Cookie[cookies.size()];
                this.convertCookies(cookies, gCookies);
                CookieSerializerUtils.serializeClientCookies((StringBuilder)sb, (org.glassfish.grizzly.http.Cookie[])gCookies);
                requestPacket.addHeader(Header.Cookie, sb.toString());
            }
        }

        private void convertCookies(Collection<Cookie> cookies, org.glassfish.grizzly.http.Cookie[] gCookies) {
            int idx = 0;
            for (Cookie cookie : cookies) {
                gCookies[idx++] = new org.glassfish.grizzly.http.Cookie(cookie.getName(), cookie.getValue());
            }
        }
    }

    private static class NTLM_INSTANCE_HOLDER {
        private static final NTLMEngine ntlmEngine = new NTLMEngine();

        private NTLM_INSTANCE_HOLDER() {
        }
    }
}

