/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.wasync.impl;

import com.ning.http.client.FluentStringsMap;
import com.ning.http.client.RequestBuilder;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.atmosphere.wasync.Function;
import org.atmosphere.wasync.FunctionWrapper;
import org.atmosphere.wasync.Options;
import org.atmosphere.wasync.Request;
import org.atmosphere.wasync.Socket;
import org.atmosphere.wasync.impl.AtmosphereSocketRuntime;
import org.atmosphere.wasync.impl.DefaultFuture;
import org.atmosphere.wasync.impl.DefaultOptions;
import org.atmosphere.wasync.impl.DefaultSocket;
import org.atmosphere.wasync.impl.SocketRuntime;
import org.atmosphere.wasync.transport.TransportNotSupported;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AtmosphereSocket
extends DefaultSocket {
    private static final Logger logger = LoggerFactory.getLogger(AtmosphereSocket.class);
    private AtomicBoolean closedByProtocol = new AtomicBoolean();

    public AtmosphereSocket(Options options) {
        super(options);
    }

    @Override
    protected void closeRuntime(boolean async) {
        this.doCloseRequest();
        super.closeRuntime(async);
    }

    protected void doCloseRequest() {
        ((DefaultOptions)this.options).b.reconnect(false);
        Object uuid = AtmosphereSocket.decodeQueryString(this.request).get("X-Atmosphere-tracking-id");
        if (!this.closedByProtocol.getAndSet(true)) {
            RequestBuilder r = new RequestBuilder();
            FluentStringsMap f = new FluentStringsMap();
            f.add("X-Atmosphere-Transport", "close").add("X-Atmosphere-tracking-id", (Collection<String>)uuid);
            ((RequestBuilder)r.setUrl(this.request.uri()).setMethod("GET").setHeaders((Map)this.request.headers())).setQueryParams((Map)f);
            try {
                this.options.runtime().prepareRequest(r.build()).execute().get();
            }
            catch (Exception e) {
                logger.debug("Was unable to send the close request {}", uuid);
                logger.trace("", e);
            }
        }
    }

    @Override
    protected void addFunction(final long timeout, final TimeUnit tu) {
        this.functions.add(new FunctionWrapper("", new Function<TransportNotSupported>(){

            @Override
            public void on(TransportNotSupported transportNotSupported) {
                AtmosphereSocket.this.request.transport().remove(0);
                if (AtmosphereSocket.this.request.transport().size() > 0) {
                    try {
                        if (AtmosphereSocket.this.request.queryString().get("X-Atmosphere-Transport") != null) {
                            Request.TRANSPORT rt = AtmosphereSocket.this.request.transport().get(0);
                            String t = rt == Request.TRANSPORT.LONG_POLLING ? "long-polling" : rt.name();
                            AtmosphereSocket.this.request.queryString().put("X-Atmosphere-Transport", Arrays.asList(t));
                        }
                        AtmosphereSocket.this.open(AtmosphereSocket.this.request, timeout, tu);
                    }
                    catch (IOException e) {
                        logger.error("", e);
                    }
                } else {
                    throw new Error("No suitable transport supported by the server");
                }
            }
        }));
    }

    @Override
    public SocketRuntime createRuntime(DefaultFuture future, Options options, List<FunctionWrapper> functions) {
        return new AtmosphereSocketRuntime(this.transportInUse, options, future, functions);
    }

    @Override
    public void close() {
        if (this.request != null) {
            this.doCloseRequest();
        }
        if (this.transportInUse == null) {
            super.closeRuntime(false);
        } else if (this.socketRuntime != null && (this.closedByProtocol.get() || !this.transportInUse.status().equals((Object)Socket.STATUS.CLOSE))) {
            this.transportInUse.close();
            super.closeRuntime(true);
        }
    }
}

