/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.providers.netty.request;

import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.ProxyServer;
import com.ning.http.client.Realm;
import com.ning.http.client.Request;
import com.ning.http.client.cookie.CookieEncoder;
import com.ning.http.client.generators.FileBodyGenerator;
import com.ning.http.client.generators.InputStreamBodyGenerator;
import com.ning.http.client.providers.netty.NettyAsyncHttpProviderConfig;
import com.ning.http.client.providers.netty.request.NettyRequest;
import com.ning.http.client.providers.netty.request.body.NettyBody;
import com.ning.http.client.providers.netty.request.body.NettyBodyBody;
import com.ning.http.client.providers.netty.request.body.NettyByteArrayBody;
import com.ning.http.client.providers.netty.request.body.NettyByteBufferBody;
import com.ning.http.client.providers.netty.request.body.NettyCompositeByteArrayBody;
import com.ning.http.client.providers.netty.request.body.NettyDirectBody;
import com.ning.http.client.providers.netty.request.body.NettyFileBody;
import com.ning.http.client.providers.netty.request.body.NettyInputStreamBody;
import com.ning.http.client.providers.netty.request.body.NettyMultipartBody;
import com.ning.http.client.providers.netty.ws.WebSocketUtils;
import com.ning.http.client.uri.Uri;
import com.ning.http.util.AsyncHttpProviderUtils;
import com.ning.http.util.AuthenticatorUtils;
import com.ning.http.util.MiscUtils;
import com.ning.http.util.StringUtils;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.handler.codec.http.DefaultHttpRequest;
import org.jboss.netty.handler.codec.http.HttpHeaders;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpVersion;

public final class NettyRequestFactory {
    public static final String GZIP_DEFLATE = "gzip,deflate";
    private final AsyncHttpClientConfig config;
    private final NettyAsyncHttpProviderConfig nettyConfig;

    public NettyRequestFactory(AsyncHttpClientConfig config, NettyAsyncHttpProviderConfig nettyConfig) {
        this.config = config;
        this.nettyConfig = nettyConfig;
    }

    private String requestUri(Uri uri, ProxyServer proxyServer, boolean connect) {
        if (connect) {
            return AsyncHttpProviderUtils.getAuthority(uri);
        }
        if (!(proxyServer == null || AsyncHttpProviderUtils.useProxyConnect(uri) && this.config.isUseRelativeURIsWithConnectProxies())) {
            return uri.toUrl();
        }
        String path = AsyncHttpProviderUtils.getNonEmptyPath(uri);
        if (MiscUtils.isNonEmpty(uri.getQuery())) {
            return path + "?" + uri.getQuery();
        }
        return path;
    }

    private String hostHeader(Request request, Uri uri) {
        String virtualHost = request.getVirtualHost();
        if (virtualHost != null) {
            return virtualHost;
        }
        String host = uri.getHost();
        int port = uri.getPort();
        return port == -1 || port == AsyncHttpProviderUtils.getSchemeDefaultPort(uri.getScheme()) ? host : host + ":" + port;
    }

    private NettyBody body(Request request, boolean connect) throws IOException {
        NettyBody nettyBody = null;
        if (!connect) {
            Charset bodyCharset;
            Charset charset = bodyCharset = request.getBodyEncoding() == null ? AsyncHttpProviderUtils.DEFAULT_CHARSET : Charset.forName(request.getBodyEncoding());
            if (request.getByteData() != null) {
                nettyBody = new NettyByteArrayBody(request.getByteData());
            } else if (request.getCompositeByteData() != null) {
                nettyBody = new NettyCompositeByteArrayBody(request.getCompositeByteData());
            } else if (request.getStringData() != null) {
                nettyBody = new NettyByteBufferBody(StringUtils.charSequence2ByteBuffer(request.getStringData(), bodyCharset));
            } else if (request.getStreamData() != null) {
                nettyBody = new NettyInputStreamBody(request.getStreamData());
            } else if (MiscUtils.isNonEmpty(request.getFormParams())) {
                String contentType = null;
                if (!request.getHeaders().containsKey("Content-Type")) {
                    contentType = "application/x-www-form-urlencoded";
                }
                nettyBody = new NettyByteBufferBody(AsyncHttpProviderUtils.urlEncodeFormParams(request.getFormParams(), bodyCharset), contentType);
            } else if (MiscUtils.isNonEmpty(request.getParts())) {
                nettyBody = new NettyMultipartBody(request.getParts(), request.getHeaders(), this.nettyConfig);
            } else if (request.getFile() != null) {
                nettyBody = new NettyFileBody(request.getFile(), this.nettyConfig);
            } else if (request.getBodyGenerator() instanceof FileBodyGenerator) {
                FileBodyGenerator fileBodyGenerator = (FileBodyGenerator)request.getBodyGenerator();
                nettyBody = new NettyFileBody(fileBodyGenerator.getFile(), fileBodyGenerator.getRegionSeek(), fileBodyGenerator.getRegionLength(), this.nettyConfig);
            } else if (request.getBodyGenerator() instanceof InputStreamBodyGenerator) {
                nettyBody = new NettyInputStreamBody(((InputStreamBodyGenerator)InputStreamBodyGenerator.class.cast(request.getBodyGenerator())).getInputStream());
            } else if (request.getBodyGenerator() != null) {
                nettyBody = new NettyBodyBody(request.getBodyGenerator().createBody(), this.nettyConfig);
            }
        }
        return nettyBody;
    }

    public void addAuthorizationHeader(HttpHeaders headers, String authorizationHeader) {
        if (authorizationHeader != null) {
            headers.add("Authorization", authorizationHeader);
        }
    }

    public void setProxyAuthorizationHeader(HttpHeaders headers, String proxyAuthorizationHeader) {
        if (proxyAuthorizationHeader != null) {
            headers.set("Proxy-Authorization", proxyAuthorizationHeader);
        }
    }

    public NettyRequest newNettyRequest(Request request, Uri uri, boolean forceConnect, ProxyServer proxyServer) throws IOException {
        String connectionHeaderValue;
        NettyRequest nettyRequest;
        DefaultHttpRequest httpRequest;
        HttpMethod method = forceConnect ? HttpMethod.CONNECT : HttpMethod.valueOf(request.getMethod());
        boolean connect = method == HttpMethod.CONNECT;
        boolean allowConnectionPooling = this.config.isAllowPoolingConnections() && (!AsyncHttpProviderUtils.isSecure(uri) || this.config.isAllowPoolingSslConnections());
        HttpVersion httpVersion = connect && proxyServer.isForceHttp10() ? HttpVersion.HTTP_1_0 : HttpVersion.HTTP_1_1;
        String requestUri = this.requestUri(uri, proxyServer, connect);
        NettyBody body = this.body(request, connect);
        if (body instanceof NettyDirectBody) {
            ChannelBuffer buffer = ((NettyDirectBody)NettyDirectBody.class.cast(body)).channelBuffer();
            httpRequest = new DefaultHttpRequest(httpVersion, method, requestUri);
            httpRequest.setContent(buffer);
            nettyRequest = new NettyRequest(httpRequest, null);
        } else {
            httpRequest = new DefaultHttpRequest(httpVersion, method, requestUri);
            nettyRequest = new NettyRequest(httpRequest, body);
        }
        HttpHeaders headers = httpRequest.headers();
        if (method != HttpMethod.CONNECT) {
            for (Map.Entry<String, List<String>> header : request.getHeaders()) {
                headers.set(header.getKey(), (Iterable)header.getValue());
            }
            if (MiscUtils.isNonEmpty(request.getCookies())) {
                headers.set("Cookie", CookieEncoder.encode(request.getCookies()));
            }
            if (this.config.isCompressionEnforced() && !headers.contains("Accept-Encoding")) {
                headers.set("Accept-Encoding", GZIP_DEFLATE);
            }
        }
        if (body != null) {
            if (body.getContentLength() < 0L) {
                headers.set("Transfer-Encoding", "chunked");
            } else {
                headers.set("Content-Length", body.getContentLength());
            }
            if (body.getContentType() != null) {
                headers.set("Content-Type", body.getContentType());
            }
        }
        boolean webSocket = AsyncHttpProviderUtils.isWebSocket(uri.getScheme());
        if (method != HttpMethod.CONNECT && webSocket) {
            String origin = "http://" + uri.getHost() + ":" + (uri.getPort() == -1 ? (AsyncHttpProviderUtils.isSecure(uri.getScheme()) ? 443 : 80) : uri.getPort());
            headers.set("Upgrade", "WebSocket").set("Connection", "Upgrade").set("Origin", origin).set("Sec-WebSocket-Key", WebSocketUtils.getKey()).set("Sec-WebSocket-Version", "13");
        } else if (!headers.contains("Connection") && (connectionHeaderValue = AsyncHttpProviderUtils.connectionHeader(allowConnectionPooling, httpVersion == HttpVersion.HTTP_1_1)) != null) {
            headers.set("Connection", connectionHeaderValue);
        }
        if (!headers.contains("Host")) {
            headers.set("Host", this.hostHeader(request, uri));
        }
        Realm realm = request.getRealm() != null ? request.getRealm() : this.config.getRealm();
        this.addAuthorizationHeader(headers, AuthenticatorUtils.perRequestAuthorizationHeader(request, uri, realm));
        this.setProxyAuthorizationHeader(headers, AuthenticatorUtils.perRequestProxyAuthorizationHeader(request, realm, proxyServer, connect));
        if (!headers.contains("Accept")) {
            headers.set("Accept", "*/*");
        }
        if (!headers.contains("User-Agent") && this.config.getUserAgent() != null) {
            headers.set("User-Agent", this.config.getUserAgent());
        }
        return nettyRequest;
    }
}

