/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.client.webdav;

import com.ning.http.client.AsyncCompletionHandlerBase;
import com.ning.http.client.AsyncHandler;
import com.ning.http.client.FluentCaseInsensitiveStringsMap;
import com.ning.http.client.HttpResponseBodyPart;
import com.ning.http.client.HttpResponseHeaders;
import com.ning.http.client.HttpResponseStatus;
import com.ning.http.client.Response;
import com.ning.http.client.cookie.Cookie;
import com.ning.http.client.uri.Uri;
import com.ning.http.client.webdav.WebDavResponse;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public abstract class WebDavCompletionHandlerBase<T>
implements AsyncHandler<T> {
    private final Logger logger = LoggerFactory.getLogger(AsyncCompletionHandlerBase.class);
    private final List<HttpResponseBodyPart> bodies = Collections.synchronizedList(new ArrayList());
    private HttpResponseStatus status;
    private HttpResponseHeaders headers;

    @Override
    public final AsyncHandler.STATE onBodyPartReceived(HttpResponseBodyPart content) throws Exception {
        this.bodies.add(content);
        return AsyncHandler.STATE.CONTINUE;
    }

    @Override
    public final AsyncHandler.STATE onStatusReceived(HttpResponseStatus status) throws Exception {
        this.status = status;
        return AsyncHandler.STATE.CONTINUE;
    }

    @Override
    public final AsyncHandler.STATE onHeadersReceived(HttpResponseHeaders headers) throws Exception {
        this.headers = headers;
        return AsyncHandler.STATE.CONTINUE;
    }

    @Override
    public final T onCompleted() throws Exception {
        if (this.status != null) {
            Response response = this.status.prepareResponse(this.headers, this.bodies);
            Document document = null;
            if (this.status.getStatusCode() == 207) {
                document = this.readXMLResponse(response.getResponseBodyAsStream());
            }
            return this.onCompleted(new WebDavResponse(this.status.prepareResponse(this.headers, this.bodies), document));
        }
        throw new IllegalStateException("Status is null");
    }

    @Override
    public void onThrowable(Throwable t) {
        this.logger.debug(t.getMessage(), t);
    }

    public abstract T onCompleted(WebDavResponse var1) throws Exception;

    private Document readXMLResponse(InputStream stream) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        Document document = null;
        try {
            document = factory.newDocumentBuilder().parse(stream);
            this.parse(document);
        }
        catch (SAXException e) {
            this.logger.error(e.getMessage(), e);
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            this.logger.error(e.getMessage(), e);
            throw new RuntimeException(e);
        }
        catch (ParserConfigurationException e) {
            this.logger.error(e.getMessage(), e);
            throw new RuntimeException(e);
        }
        return document;
    }

    private void parse(Document document) {
        Element element = document.getDocumentElement();
        NodeList statusNode = element.getElementsByTagName("status");
        for (int i = 0; i < statusNode.getLength(); ++i) {
            Node node = statusNode.item(i);
            String value = node.getFirstChild().getNodeValue();
            int statusCode = Integer.valueOf(value.substring(value.indexOf(" "), value.lastIndexOf(" ")).trim());
            String statusText = value.substring(value.lastIndexOf(" "));
            this.status = new HttpStatusWrapper(this.status, statusText, statusCode);
        }
    }

    private class HttpStatusWrapper
    extends HttpResponseStatus {
        private final HttpResponseStatus wrapped;
        private final String statusText;
        private final int statusCode;

        public HttpStatusWrapper(HttpResponseStatus wrapper, String statusText, int statusCode) {
            super(wrapper.getUri(), wrapper.getConfig());
            this.wrapped = wrapper;
            this.statusText = statusText;
            this.statusCode = statusCode;
        }

        @Override
        public Response prepareResponse(HttpResponseHeaders headers, List<HttpResponseBodyPart> bodyParts) {
            final Response wrappedResponse = this.wrapped.prepareResponse(headers, bodyParts);
            return new Response(){

                @Override
                public int getStatusCode() {
                    return HttpStatusWrapper.this.statusCode;
                }

                @Override
                public String getStatusText() {
                    return HttpStatusWrapper.this.statusText;
                }

                @Override
                public byte[] getResponseBodyAsBytes() throws IOException {
                    return wrappedResponse.getResponseBodyAsBytes();
                }

                @Override
                public ByteBuffer getResponseBodyAsByteBuffer() throws IOException {
                    return wrappedResponse.getResponseBodyAsByteBuffer();
                }

                @Override
                public InputStream getResponseBodyAsStream() throws IOException {
                    return wrappedResponse.getResponseBodyAsStream();
                }

                @Override
                public String getResponseBodyExcerpt(int maxLength, String charset) throws IOException {
                    return wrappedResponse.getResponseBodyExcerpt(maxLength, charset);
                }

                @Override
                public String getResponseBody(String charset) throws IOException {
                    return wrappedResponse.getResponseBody(charset);
                }

                @Override
                public String getResponseBodyExcerpt(int maxLength) throws IOException {
                    return wrappedResponse.getResponseBodyExcerpt(maxLength);
                }

                @Override
                public String getResponseBody() throws IOException {
                    return wrappedResponse.getResponseBody();
                }

                @Override
                public Uri getUri() {
                    return wrappedResponse.getUri();
                }

                @Override
                public String getContentType() {
                    return wrappedResponse.getContentType();
                }

                @Override
                public String getHeader(String name) {
                    return wrappedResponse.getHeader(name);
                }

                @Override
                public List<String> getHeaders(String name) {
                    return wrappedResponse.getHeaders(name);
                }

                @Override
                public FluentCaseInsensitiveStringsMap getHeaders() {
                    return wrappedResponse.getHeaders();
                }

                @Override
                public boolean isRedirected() {
                    return wrappedResponse.isRedirected();
                }

                @Override
                public List<Cookie> getCookies() {
                    return wrappedResponse.getCookies();
                }

                @Override
                public boolean hasResponseStatus() {
                    return wrappedResponse.hasResponseStatus();
                }

                @Override
                public boolean hasResponseHeaders() {
                    return wrappedResponse.hasResponseHeaders();
                }

                @Override
                public boolean hasResponseBody() {
                    return wrappedResponse.hasResponseBody();
                }
            };
        }

        @Override
        public int getStatusCode() {
            return this.statusText == null ? this.wrapped.getStatusCode() : this.statusCode;
        }

        @Override
        public String getStatusText() {
            return this.statusText == null ? this.wrapped.getStatusText() : this.statusText;
        }

        @Override
        public String getProtocolName() {
            return this.wrapped.getProtocolName();
        }

        @Override
        public int getProtocolMajorVersion() {
            return this.wrapped.getProtocolMajorVersion();
        }

        @Override
        public int getProtocolMinorVersion() {
            return this.wrapped.getProtocolMinorVersion();
        }

        @Override
        public String getProtocolText() {
            return this.wrapped.getStatusText();
        }
    }
}

