/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.wasync.impl;

import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.FluentStringsMap;
import com.ning.http.client.ListenableFuture;
import com.ning.http.client.Response;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import org.atmosphere.wasync.Encoder;
import org.atmosphere.wasync.Event;
import org.atmosphere.wasync.FunctionWrapper;
import org.atmosphere.wasync.Future;
import org.atmosphere.wasync.Options;
import org.atmosphere.wasync.Request;
import org.atmosphere.wasync.Socket;
import org.atmosphere.wasync.Transport;
import org.atmosphere.wasync.impl.DefaultFuture;
import org.atmosphere.wasync.impl.DefaultSocket;
import org.atmosphere.wasync.transport.TransportsUtil;
import org.atmosphere.wasync.transport.WebSocketTransport;
import org.atmosphere.wasync.util.ReaderInputStream;
import org.atmosphere.wasync.util.TypeResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SocketRuntime {
    private static final Logger logger = LoggerFactory.getLogger(SocketRuntime.class);
    protected Transport transport;
    protected final Options options;
    protected final DefaultFuture rootFuture;
    protected final List<FunctionWrapper> functions;

    public SocketRuntime(Transport transport, Options options, DefaultFuture rootFuture, List<FunctionWrapper> functions) {
        this.transport = transport;
        this.options = options;
        this.rootFuture = rootFuture;
        this.functions = functions;
    }

    public DefaultFuture future() {
        return this.rootFuture;
    }

    protected Object invokeEncoder(List<Encoder<? extends Object, ?>> encoders, Object instanceType) {
        for (Encoder<Object, ?> e : encoders) {
            Class<?>[] typeArguments = TypeResolver.resolveArguments(e.getClass(), Encoder.class);
            if (typeArguments.length <= 0 || !typeArguments[0].isAssignableFrom(instanceType.getClass())) continue;
            instanceType = e.encode(instanceType);
        }
        return instanceType;
    }

    public Future write(Request request, Object data) throws IOException {
        Object object = this.invokeEncoder(request.encoders(), data);
        boolean webSocket = this.transport.name().equals((Object)Request.TRANSPORT.WEBSOCKET);
        if (webSocket && (this.transport.status().equals((Object)Socket.STATUS.CLOSE) || this.transport.status().equals((Object)Socket.STATUS.ERROR))) {
            this.transport.error(new IOException("Invalid Socket Status " + this.transport.status().name()));
        } else if (webSocket) {
            this.webSocketWrite(request, object, data);
        } else {
            try {
                Response r = (Response)this.httpWrite(request, object, data).get(this.rootFuture.time(), this.rootFuture.timeUnit());
                String m = r.getResponseBody();
                if (m.length() > 0) {
                    TransportsUtil.invokeFunction(request.decoders(), this.functions, String.class, m, Event.MESSAGE.name(), request.functionResolver());
                }
            }
            catch (TimeoutException t) {
                logger.trace("AHC Timeout", t);
                this.rootFuture.timeoutException(t);
            }
            catch (Throwable t) {
                logger.error("", t);
            }
        }
        return this.rootFuture.finishOrThrowException();
    }

    public void webSocketWrite(Request request, Object object, Object data) throws IOException {
        WebSocketTransport webSocketTransport = (WebSocketTransport)WebSocketTransport.class.cast(this.transport);
        if (InputStream.class.isAssignableFrom(object.getClass())) {
            InputStream is = (InputStream)object;
            ByteArrayOutputStream bs = new ByteArrayOutputStream();
            byte[] buffer = new byte[8192];
            int n = 0;
            while (-1 != (n = is.read(buffer))) {
                bs.write(buffer, 0, n);
            }
            webSocketTransport.sendMessage(bs.toByteArray());
        } else if (Reader.class.isAssignableFrom(object.getClass())) {
            Reader is = (Reader)object;
            StringWriter bs = new StringWriter();
            char[] chars = new char[8192];
            int n = 0;
            while (-1 != (n = is.read(chars))) {
                bs.write(chars, 0, n);
            }
            webSocketTransport.sendMessage(bs.getBuffer().toString());
        } else if (String.class.isAssignableFrom(object.getClass())) {
            webSocketTransport.sendMessage(object.toString());
        } else if (byte[].class.isAssignableFrom(object.getClass())) {
            webSocketTransport.sendMessage((byte[])object);
        } else {
            throw new IllegalStateException("No Encoder for " + data);
        }
    }

    public ListenableFuture<Response> httpWrite(Request request, Object object, Object data) throws IOException {
        AsyncHttpClient.BoundRequestBuilder b = this.configureAHC(request);
        if (InputStream.class.isAssignableFrom(object.getClass())) {
            return b.setBody((InputStream)object).execute();
        }
        if (Reader.class.isAssignableFrom(object.getClass())) {
            return b.setBody(new ReaderInputStream((Reader)object)).execute();
        }
        if (String.class.isAssignableFrom(object.getClass())) {
            return b.setBody((String)object).execute();
        }
        if (byte[].class.isAssignableFrom(object.getClass())) {
            return b.setBody((byte[])object).execute();
        }
        throw new IllegalStateException("No Encoder for " + data);
    }

    protected AsyncHttpClient.BoundRequestBuilder configureAHC(Request request) {
        FluentStringsMap m = DefaultSocket.decodeQueryString(request);
        return (AsyncHttpClient.BoundRequestBuilder)((AsyncHttpClient.BoundRequestBuilder)this.options.runtime().preparePost(request.uri()).setHeaders((Map)request.headers()).setQueryParams(m)).setMethod(Request.METHOD.POST.name());
    }
}

