/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.wasync.transport;

import io.netty.handler.codec.http.HttpHeaders;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.asynchttpclient.AsyncHandler;
import org.asynchttpclient.HttpResponseBodyPart;
import org.asynchttpclient.HttpResponseStatus;
import org.asynchttpclient.RequestBuilder;
import org.atmosphere.wasync.Event;
import org.atmosphere.wasync.FunctionWrapper;
import org.atmosphere.wasync.Options;
import org.atmosphere.wasync.Request;
import org.atmosphere.wasync.Socket;
import org.atmosphere.wasync.transport.StreamTransport;
import org.atmosphere.wasync.transport.TransportsUtil;
import org.atmosphere.wasync.util.Utils;

public class LongPollingTransport
extends StreamTransport {
    private final AtomicBoolean handshakeOccurred = new AtomicBoolean(true);
    private int count = 0;

    public LongPollingTransport(RequestBuilder requestBuilder, Options options, Request request, List<FunctionWrapper> functions) {
        super(requestBuilder, options, request, functions);
        List<String> protocol = request.queryString().get("X-atmo-protocol");
        List<String> transport = request.queryString().get("X-Atmosphere-Transport");
        if (protocol != null && transport != null && protocol.get(0).equals("true") && transport.get(0).equals("long-polling")) {
            this.handshakeOccurred.set(false);
        }
    }

    @Override
    public AsyncHandler.State onHeadersReceived(HttpHeaders headers) throws Exception {
        if (this.handshakeOccurred.get()) {
            return super.onHeadersReceived(headers);
        }
        return AsyncHandler.State.CONTINUE;
    }

    @Override
    public AsyncHandler.State onStatusReceived(HttpResponseStatus responseStatus) throws Exception {
        if (this.handshakeOccurred.get()) {
            if (this.protocolEnabled && ++this.count == 1) {
                this.status = Socket.STATUS.INIT;
            }
            return super.onStatusReceived(responseStatus);
        }
        return AsyncHandler.State.CONTINUE;
    }

    @Override
    public AsyncHandler.State onBodyPartReceived(HttpResponseBodyPart bodyPart) throws Exception {
        this.handshakeOccurred.set(true);
        if (this.isBinary) {
            byte[] payload = bodyPart.getBodyPartBytes();
            if (this.protocolEnabled && !this.protocolReceived) {
                if (!Utils.whiteSpace(payload)) {
                    TransportsUtil.invokeFunction(this.decoders, this.functions, payload.getClass(), payload, Event.MESSAGE.name(), this.resolver);
                    this.protocolReceived = true;
                }
                return AsyncHandler.State.CONTINUE;
            }
            if (!bodyPart.isLast()) {
                TransportsUtil.invokeFunction(this.decoders, this.functions, payload.getClass(), payload, Event.MESSAGE.name(), this.resolver);
            }
            this.unlockFuture();
        } else {
            String m = new String(bodyPart.getBodyPartBytes(), this.charSet);
            if (this.protocolEnabled && !this.protocolReceived) {
                if ((m = m.trim()).length() > 0) {
                    TransportsUtil.invokeFunction(this.decoders, this.functions, m.getClass(), m, Event.MESSAGE.name(), this.resolver);
                    this.protocolReceived = true;
                }
                return AsyncHandler.State.CONTINUE;
            }
            if (!bodyPart.isLast()) {
                TransportsUtil.invokeFunction(this.decoders, this.functions, m.getClass(), m, Event.MESSAGE.name(), this.resolver);
            }
            this.unlockFuture();
        }
        return AsyncHandler.State.CONTINUE;
    }

    @Override
    public Request.TRANSPORT name() {
        return Request.TRANSPORT.LONG_POLLING;
    }
}

