/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.wasync.transport;

import io.netty.handler.codec.http.HttpHeaders;
import java.util.List;
import org.asynchttpclient.AsyncHandler;
import org.asynchttpclient.HttpResponseBodyPart;
import org.asynchttpclient.RequestBuilder;
import org.atmosphere.wasync.Event;
import org.atmosphere.wasync.FunctionWrapper;
import org.atmosphere.wasync.Options;
import org.atmosphere.wasync.Request;
import org.atmosphere.wasync.Socket;
import org.atmosphere.wasync.transport.StreamTransport;
import org.atmosphere.wasync.transport.TransportNotSupported;
import org.atmosphere.wasync.transport.TransportsUtil;

public class SSETransport
extends StreamTransport {
    public SSETransport(RequestBuilder requestBuilder, Options options, Request request, List<FunctionWrapper> functions) {
        super(requestBuilder, options, request, functions);
    }

    @Override
    public Request.TRANSPORT name() {
        return Request.TRANSPORT.SSE;
    }

    @Override
    public AsyncHandler.State onHeadersReceived(HttpHeaders headers) throws Exception {
        String ct = headers.get("Content-Type");
        if (ct == null || ct.length() == 0 || !ct.contains("text/event-stream")) {
            this.status = Socket.STATUS.ERROR;
            throw new TransportNotSupported(500, "Invalid Content-Type" + ct);
        }
        return super.onHeadersReceived(headers);
    }

    @Override
    public AsyncHandler.State onBodyPartReceived(HttpResponseBodyPart bodyPart) throws Exception {
        String m;
        if (!bodyPart.isLast() && (m = new String(bodyPart.getBodyPartBytes(), this.charSet).trim()).length() > 0) {
            String[] data;
            for (String d : data = m.split("data:")) {
                if (d.length() > 0) {
                    TransportsUtil.invokeFunction(this.decoders, this.functions, d.getClass(), d, Event.MESSAGE.name(), this.resolver);
                }
                this.unlockFuture();
            }
        }
        return AsyncHandler.State.CONTINUE;
    }
}

