/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.wasync.impl;

import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.DefaultAsyncHttpClient;
import org.asynchttpclient.DefaultAsyncHttpClientConfig;
import org.atmosphere.wasync.Options;
import org.atmosphere.wasync.Socket;
import org.atmosphere.wasync.impl.DefaultOptionsBuilder;
import org.atmosphere.wasync.impl.DefaultSocket;

public class ClientUtil {
    private static final String WASYNC_USER_AGENT = "wAsync/2.0";

    public static final AsyncHttpClient createDefaultAsyncHttpClient(Options o) {
        return ClientUtil.createDefaultAsyncHttpClient(o.requestTimeoutInSeconds());
    }

    public static final AsyncHttpClient createDefaultAsyncHttpClient(int requestTimeoutInSeconds) {
        DefaultAsyncHttpClientConfig.Builder b = new DefaultAsyncHttpClientConfig.Builder();
        b.setFollowRedirect(true).setTcpNoDelay(true).setKeepAlive(true).setConnectTimeout(-1).setReadTimeout(requestTimeoutInSeconds == -1 ? requestTimeoutInSeconds : requestTimeoutInSeconds * 1000).setUserAgent(WASYNC_USER_AGENT);
        return new DefaultAsyncHttpClient(b.build());
    }

    public static Socket create(Options options) {
        return ClientUtil.create(options, DefaultSocket.class);
    }

    public static Socket create(Options options, Class<? extends Socket> socket) {
        AsyncHttpClient asyncHttpClient = options.runtime();
        if (asyncHttpClient == null || asyncHttpClient.isClosed()) {
            asyncHttpClient = ClientUtil.createDefaultAsyncHttpClient(options);
            options.runtime(asyncHttpClient);
        }
        return ClientUtil.getSocket(options, socket);
    }

    public static final Socket getSocket(Options options, Class<? extends Socket> socket) {
        try {
            return socket.getConstructor(Options.class).newInstance(options);
        }
        catch (Exception e) {
            return new DefaultSocket(options);
        }
    }

    public static Socket create(Class<? extends Socket> socket) {
        AsyncHttpClient asyncHttpClient = ClientUtil.createDefaultAsyncHttpClient(((DefaultOptionsBuilder)new DefaultOptionsBuilder().reconnect(true)).build());
        return ClientUtil.getSocket(((DefaultOptionsBuilder)new DefaultOptionsBuilder().runtime(asyncHttpClient, false)).build(), socket);
    }

    public static Socket create() {
        AsyncHttpClient asyncHttpClient = ClientUtil.createDefaultAsyncHttpClient(((DefaultOptionsBuilder)new DefaultOptionsBuilder().reconnect(true)).build());
        return ClientUtil.getSocket(((DefaultOptionsBuilder)new DefaultOptionsBuilder().runtime(asyncHttpClient, false)).build(), DefaultSocket.class);
    }
}

