/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.wasync.andoid;

import android.app.Activity;
import android.os.Bundle;
import android.os.Handler;
import android.os.StrictMode;
import android.util.Log;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.TextView;
import java.io.IOException;
import java.util.Date;
import org.atmosphere.wasync.ClientFactory;
import org.atmosphere.wasync.Decoder;
import org.atmosphere.wasync.Encoder;
import org.atmosphere.wasync.Event;
import org.atmosphere.wasync.Function;
import org.atmosphere.wasync.Request;
import org.atmosphere.wasync.Socket;
import org.atmosphere.wasync.andoid.Message;
import org.atmosphere.wasync.impl.AtmosphereClient;
import org.atmosphere.wasync.impl.AtmosphereRequest;
import org.codehaus.jackson.map.ObjectMapper;

public class wAsyncChat
extends Activity {
    private Button bt;
    private TextView tv;
    private String serverIpAddress = "http://10.0.2.2:8080";
    private static final ObjectMapper mapper = new ObjectMapper();
    private final Handler uiHandler = new Handler();

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        StrictMode.ThreadPolicy policy = new StrictMode.ThreadPolicy.Builder().permitAll().build();
        StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)policy);
        this.setContentView(2130903040);
        this.bt = (Button)this.findViewById(2131034114);
        this.tv = (TextView)this.findViewById(2131034112);
        try {
            AtmosphereClient client = (AtmosphereClient)ClientFactory.getDefault().newClient(AtmosphereClient.class);
            AtmosphereRequest.AtmosphereRequestBuilder request = ((AtmosphereRequest.AtmosphereRequestBuilder)((AtmosphereRequest.AtmosphereRequestBuilder)((AtmosphereRequest.AtmosphereRequestBuilder)((AtmosphereRequest.AtmosphereRequestBuilder)client.newRequestBuilder().method(Request.METHOD.GET)).uri(this.serverIpAddress + "/chat")).trackMessageLength(true).encoder((Encoder)new Encoder<Message, String>(){

                public String encode(Message data) {
                    try {
                        return mapper.writeValueAsString((Object)data);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            })).decoder((Decoder)new Decoder<String, Message>(){

                public Message decode(Event type, String data) {
                    if ((data = data.trim()).length() == 0) {
                        return null;
                    }
                    if (type.equals((Object)Event.MESSAGE)) {
                        try {
                            return (Message)mapper.readValue(data, Message.class);
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                            return null;
                        }
                    }
                    return null;
                }
            })).transport(Request.TRANSPORT.WEBSOCKET);
            final Socket socket = client.create();
            socket.on("message", (Function)new Function<Message>(){

                public void on(final Message t) {
                    wAsyncChat.this.uiHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            Date d = new Date(t.getTime());
                            wAsyncChat.this.tv.append((CharSequence)("Author " + t.getAuthor() + "@ " + d.getHours() + ":" + d.getMinutes() + ": " + t.getMessage() + "\n"));
                        }
                    });
                }
            }).on((Function)new Function<Throwable>(){

                public void on(Throwable t) {
                    wAsyncChat.this.tv.setText((CharSequence)("ERROR 3: " + t.getMessage()));
                    t.printStackTrace();
                }
            }).open(request.build());
            this.bt.setOnClickListener(new View.OnClickListener(){
                String name = null;

                public void onClick(View v) {
                    try {
                        EditText et = (EditText)wAsyncChat.this.findViewById(2131034113);
                        String str = et.getText().toString();
                        if (this.name == null) {
                            this.name = str;
                        }
                        socket.fire((Object)new Message(this.name, str));
                        et.setText((CharSequence)"");
                        Log.d((String)"Client", (String)"Client sent message");
                    }
                    catch (Throwable e) {
                        wAsyncChat.this.tv.setText((CharSequence)("ERROR 3: " + e.getMessage()));
                        e.printStackTrace();
                    }
                }
            });
        }
        catch (Throwable e) {
            this.tv.setText((CharSequence)("Unable to connect: " + e.getMessage()));
            e.printStackTrace();
        }
    }
}

