/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.wasync.samples;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Date;
import org.atmosphere.wasync.Client;
import org.atmosphere.wasync.ClientFactory;
import org.atmosphere.wasync.Decoder;
import org.atmosphere.wasync.Encoder;
import org.atmosphere.wasync.Function;
import org.atmosphere.wasync.Options;
import org.atmosphere.wasync.Request;
import org.atmosphere.wasync.RequestBuilder;
import org.atmosphere.wasync.Socket;
import org.atmosphere.wasync.Transport;
import org.atmosphere.wasync.samples.Data;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class wAsyncNodeChat {
    private static final Logger logger = LoggerFactory.getLogger(wAsyncNodeChat.class);
    private static final ObjectMapper mapper = new ObjectMapper();

    public static void main(String[] args) throws IOException {
        if (args.length == 0) {
            args = new String[]{"http://127.0.0.1:8080"};
        }
        Options options = new Options.OptionsBuilder().build();
        Client client = ClientFactory.getDefault().newClient();
        RequestBuilder request = client.newRequestBuilder().method(Request.METHOD.GET).uri(args[0] + "/chat").encoder((Encoder)new Encoder<Data, String>(){

            public String encode(Data data) {
                try {
                    return mapper.writeValueAsString((Object)data);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }).decoder((Decoder)new Decoder<String, Data>(){

            public Data decode(Transport.EVENT_TYPE type, String data) {
                if ((data = data.trim()).length() == 0) {
                    return null;
                }
                if (type.equals((Object)Transport.EVENT_TYPE.MESSAGE)) {
                    try {
                        return (Data)mapper.readValue(data, Data.class);
                    }
                    catch (IOException e) {
                        logger.debug("Invalid message {}", (Object)data);
                        return null;
                    }
                }
                return null;
            }
        }).transport(Request.TRANSPORT.WEBSOCKET).transport(Request.TRANSPORT.LONG_POLLING);
        Socket socket = client.create(options);
        socket.on("message", (Function)new Function<Data>(){

            public void on(Data t) {
                Date d = new Date(t.getTime());
                logger.info("Author {}: {}", (Object)(t.getAuthor() + "@ " + d.getHours() + ":" + d.getMinutes()), (Object)t.getMessage());
            }
        }).on((Function)new Function<Throwable>(){

            public void on(Throwable t) {
                t.printStackTrace();
            }
        }).open(request.build());
        logger.info("Choose Name: ");
        String name = null;
        String a = "";
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        while (!a.equals("quit")) {
            a = br.readLine();
            if (name == null) {
                name = a;
            }
            socket.fire((Object)new Data(name, a));
        }
        socket.close();
    }
}

