/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.wasync;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.atmosphere.wasync.Decoder;
import org.atmosphere.wasync.Encoder;
import org.atmosphere.wasync.FunctionResolver;
import org.atmosphere.wasync.Request;
import org.atmosphere.wasync.impl.DefaultFunctionResolver;

public abstract class RequestBuilder<T extends RequestBuilder<T>> {
    protected final List<Request.TRANSPORT> transports = new ArrayList<Request.TRANSPORT>();
    protected Request.METHOD method = Request.METHOD.GET;
    protected String uri = "http://localhost:8080";
    protected final List<Encoder<?, ?>> encoders = new ArrayList();
    protected final List<Decoder<?, ?>> decoders = new ArrayList();
    protected final Map<String, Collection<String>> headers = new HashMap<String, Collection<String>>();
    protected final Map<String, List<String>> queryString = new HashMap<String, List<String>>();
    protected FunctionResolver resolver = new DefaultFunctionResolver();
    protected final Class<T> derived;

    protected RequestBuilder(Class<T> derived) {
        this.derived = derived;
    }

    public T transport(Request.TRANSPORT t) {
        this.transports.add(t);
        return (T)((RequestBuilder)this.derived.cast(this));
    }

    public T method(Request.METHOD method) {
        this.method = method;
        return (T)((RequestBuilder)this.derived.cast(this));
    }

    public T uri(String uri) {
        this.uri = uri;
        return (T)((RequestBuilder)this.derived.cast(this));
    }

    public T encoder(Encoder e) {
        this.encoders.add(e);
        return (T)((RequestBuilder)this.derived.cast(this));
    }

    public T decoder(Decoder d) {
        this.decoders.add(d);
        return (T)((RequestBuilder)this.derived.cast(this));
    }

    public T header(String name, String value) {
        Collection<String> l = this.headers.get(name);
        if (l == null) {
            l = new ArrayList<String>();
        }
        l.add(value);
        this.headers.put(name, l);
        return (T)((RequestBuilder)this.derived.cast(this));
    }

    public T queryString(String name, String value) {
        List<String> l = this.queryString.get(name);
        if (l == null) {
            l = new ArrayList<String>();
        }
        l.add(value);
        this.queryString.put(name, l);
        return (T)((RequestBuilder)this.derived.cast(this));
    }

    public T resolver(FunctionResolver resolver) {
        this.resolver = resolver;
        return (T)((RequestBuilder)this.derived.cast(this));
    }

    public abstract Request build();

    public List<Request.TRANSPORT> transports() {
        return this.transports;
    }

    public Request.METHOD method() {
        return this.method;
    }

    public Map<String, Collection<String>> headers() {
        return this.headers;
    }

    public Map<String, List<String>> queryString() {
        return this.queryString;
    }

    public List<Encoder<?, ?>> encoders() {
        return this.encoders;
    }

    public List<Decoder<?, ?>> decoders() {
        return this.decoders;
    }

    public String uri() {
        return this.uri;
    }

    public FunctionResolver resolver() {
        return this.resolver;
    }
}

