/*
 * Decompiled with CFR 0.152.
 */
package com.ning.http.multipart;

import com.ning.http.client.ByteArrayPart;
import com.ning.http.client.RandomAccessBody;
import com.ning.http.multipart.ByteArrayPartSource;
import com.ning.http.multipart.FilePart;
import com.ning.http.multipart.FilePartSource;
import com.ning.http.multipart.FilePartStallHandler;
import com.ning.http.multipart.FileUploadStalledException;
import com.ning.http.multipart.MultipartEncodingUtil;
import com.ning.http.multipart.Part;
import com.ning.http.multipart.PartSource;
import com.ning.http.multipart.StringPart;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultipartBody
implements RandomAccessBody {
    private byte[] boundary;
    private long contentLength;
    private List<com.ning.http.client.Part> parts;
    private List<RandomAccessFile> files;
    private int startPart;
    private static final Logger logger = LoggerFactory.getLogger(MultipartBody.class);
    ByteArrayInputStream currentStream;
    int currentStreamPosition;
    boolean endWritten;
    boolean doneWritingParts;
    FileLocation fileLocation;
    FilePart currentFilePart;
    FileChannel currentFileChannel;

    public MultipartBody(List<com.ning.http.client.Part> parts, String boundary, String contentLength) {
        this.boundary = MultipartEncodingUtil.getAsciiBytes(boundary.substring("multipart/form-data; boundary=".length()));
        this.contentLength = Long.parseLong(contentLength);
        this.parts = parts;
        this.files = new ArrayList<RandomAccessFile>();
        this.startPart = 0;
        this.currentStreamPosition = -1;
        this.endWritten = false;
        this.doneWritingParts = false;
        this.fileLocation = FileLocation.NONE;
        this.currentFilePart = null;
    }

    @Override
    public void close() throws IOException {
        for (RandomAccessFile file : this.files) {
            file.close();
        }
    }

    @Override
    public long getContentLength() {
        return this.contentLength;
    }

    @Override
    public long read(ByteBuffer buffer) throws IOException {
        try {
            int overallLength = 0;
            int maxLength = buffer.capacity();
            if (this.startPart == this.parts.size() && this.endWritten) {
                return -1L;
            }
            boolean full = false;
            while (!full && !this.doneWritingParts) {
                StringPart currentPart;
                com.ning.http.client.Part part = null;
                if (this.startPart < this.parts.size()) {
                    part = this.parts.get(this.startPart);
                }
                if (this.currentFileChannel != null) {
                    overallLength += this.currentFileChannel.read(buffer);
                    if (this.currentFileChannel.position() == this.currentFileChannel.size()) {
                        this.currentFileChannel.close();
                        this.currentFileChannel = null;
                    }
                    if (overallLength != maxLength) continue;
                    full = true;
                    continue;
                }
                if (this.currentStreamPosition > -1) {
                    if ((overallLength += this.writeToBuffer(buffer, maxLength - overallLength)) == maxLength) {
                        full = true;
                    }
                    if (this.startPart != this.parts.size() || this.currentStream.available() != 0) continue;
                    this.doneWritingParts = true;
                    continue;
                }
                if (part instanceof StringPart) {
                    currentPart = (StringPart)part;
                    this.initializeStringPart(currentPart);
                    ++this.startPart;
                    continue;
                }
                if (part instanceof com.ning.http.client.StringPart) {
                    currentPart = this.generateClientStringpart(part);
                    this.initializeStringPart(currentPart);
                    ++this.startPart;
                    continue;
                }
                if (part instanceof FilePart) {
                    if (this.fileLocation == FileLocation.NONE) {
                        this.currentFilePart = (FilePart)part;
                        this.initializeFilePart(this.currentFilePart);
                        continue;
                    }
                    if (this.fileLocation == FileLocation.START) {
                        this.initializeFileBody(this.currentFilePart);
                        continue;
                    }
                    if (this.fileLocation == FileLocation.MIDDLE) {
                        this.initializeFileEnd(this.currentFilePart);
                        continue;
                    }
                    if (this.fileLocation != FileLocation.END) continue;
                    ++this.startPart;
                    if (this.startPart != this.parts.size() || this.currentStream.available() != 0) continue;
                    this.doneWritingParts = true;
                    continue;
                }
                if (part instanceof com.ning.http.client.FilePart) {
                    if (this.fileLocation == FileLocation.NONE) {
                        this.currentFilePart = this.generateClientFilePart(part);
                        this.initializeFilePart(this.currentFilePart);
                        continue;
                    }
                    if (this.fileLocation == FileLocation.START) {
                        this.initializeFileBody(this.currentFilePart);
                        continue;
                    }
                    if (this.fileLocation == FileLocation.MIDDLE) {
                        this.initializeFileEnd(this.currentFilePart);
                        continue;
                    }
                    if (this.fileLocation != FileLocation.END) continue;
                    ++this.startPart;
                    if (this.startPart != this.parts.size() || this.currentStream.available() != 0) continue;
                    this.doneWritingParts = true;
                    continue;
                }
                if (!(part instanceof ByteArrayPart)) continue;
                ByteArrayPart bytePart = (ByteArrayPart)part;
                if (this.fileLocation == FileLocation.NONE) {
                    this.currentFilePart = this.generateClientByteArrayPart(bytePart);
                    this.initializeFilePart(this.currentFilePart);
                    continue;
                }
                if (this.fileLocation == FileLocation.START) {
                    this.initializeByteArrayBody(this.currentFilePart);
                    continue;
                }
                if (this.fileLocation == FileLocation.MIDDLE) {
                    this.initializeFileEnd(this.currentFilePart);
                    continue;
                }
                if (this.fileLocation != FileLocation.END) continue;
                ++this.startPart;
                if (this.startPart != this.parts.size() || this.currentStream.available() != 0) continue;
                this.doneWritingParts = true;
            }
            if (this.doneWritingParts) {
                if (this.currentStreamPosition == -1) {
                    ByteArrayOutputStream endWriter = new ByteArrayOutputStream();
                    Part.sendMessageEnd(endWriter, this.boundary);
                    this.initializeBuffer(endWriter);
                }
                if (this.currentStreamPosition > -1) {
                    overallLength += this.writeToBuffer(buffer, maxLength - overallLength);
                    if (this.currentStream.available() == 0) {
                        this.currentStream.close();
                        this.currentStreamPosition = -1;
                        this.endWritten = true;
                    }
                }
            }
            return overallLength;
        }
        catch (Exception e) {
            logger.info("read exception", (Throwable)e);
            return 0L;
        }
    }

    private void initializeByteArrayBody(FilePart filePart) throws IOException {
        ByteArrayOutputStream output = this.generateByteArrayBody(filePart);
        this.initializeBuffer(output);
        this.fileLocation = FileLocation.MIDDLE;
    }

    private void initializeFileEnd(FilePart currentPart) throws IOException {
        ByteArrayOutputStream output = this.generateFileEnd(currentPart);
        this.initializeBuffer(output);
        this.fileLocation = FileLocation.END;
    }

    private void initializeFileBody(FilePart currentPart) throws IOException {
        if (FilePartSource.class.isAssignableFrom(currentPart.getSource().getClass())) {
            FilePartSource source = (FilePartSource)currentPart.getSource();
            File file = source.getFile();
            RandomAccessFile raf = new RandomAccessFile(file, "r");
            this.files.add(raf);
            this.currentFileChannel = raf.getChannel();
        } else {
            PartSource partSource = currentPart.getSource();
            InputStream stream = partSource.createInputStream();
            byte[] bytes = new byte[(int)partSource.getLength()];
            stream.read(bytes);
            this.currentStream = new ByteArrayInputStream(bytes);
            this.currentStreamPosition = 0;
        }
        this.fileLocation = FileLocation.MIDDLE;
    }

    private void initializeFilePart(FilePart filePart) throws IOException {
        filePart.setPartBoundary(this.boundary);
        ByteArrayOutputStream output = this.generateFileStart(filePart);
        this.initializeBuffer(output);
        this.fileLocation = FileLocation.START;
    }

    private void initializeStringPart(StringPart currentPart) throws IOException {
        currentPart.setPartBoundary(this.boundary);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        Part.sendPart(outputStream, currentPart, this.boundary);
        this.initializeBuffer(outputStream);
    }

    private int writeToBuffer(ByteBuffer buffer, int length) throws IOException {
        int available = this.currentStream.available();
        int writeLength = Math.min(available, length);
        byte[] bytes = new byte[writeLength];
        this.currentStream.read(bytes);
        buffer.put(bytes);
        if (available <= length) {
            this.currentStream.close();
            this.currentStreamPosition = -1;
        } else {
            this.currentStreamPosition += writeLength;
        }
        return writeLength;
    }

    private void initializeBuffer(ByteArrayOutputStream outputStream) throws IOException {
        this.currentStream = new ByteArrayInputStream(outputStream.toByteArray());
        this.currentStreamPosition = 0;
    }

    @Override
    public long transferTo(long position, long count, WritableByteChannel target) throws IOException {
        long overallLength = 0L;
        if (this.startPart == this.parts.size()) {
            return this.contentLength;
        }
        int tempPart = this.startPart;
        for (com.ning.http.client.Part part : this.parts) {
            overallLength = part instanceof Part ? (overallLength += this.handleMultiPart(target, (Part)part)) : (overallLength += this.handleClientPart(target, part));
            ++tempPart;
        }
        ByteArrayOutputStream endWriter = new ByteArrayOutputStream();
        Part.sendMessageEnd(endWriter, this.boundary);
        this.startPart = tempPart;
        return overallLength += this.writeToTarget(target, endWriter);
    }

    private long handleClientPart(WritableByteChannel target, com.ning.http.client.Part part) throws IOException {
        if (part.getClass().equals(com.ning.http.client.StringPart.class)) {
            StringPart currentPart = this.generateClientStringpart(part);
            return this.handleStringPart(target, currentPart);
        }
        if (part.getClass().equals(com.ning.http.client.FilePart.class)) {
            FilePart filePart = this.generateClientFilePart(part);
            return this.handleFilePart(target, filePart);
        }
        if (part.getClass().equals(ByteArrayPart.class)) {
            ByteArrayPart bytePart = (ByteArrayPart)part;
            FilePart filePart = this.generateClientByteArrayPart(bytePart);
            return this.handleByteArrayPart(target, filePart, bytePart.getData());
        }
        return 0L;
    }

    private FilePart generateClientByteArrayPart(ByteArrayPart bytePart) {
        ByteArrayPartSource source = new ByteArrayPartSource(bytePart.getFileName(), bytePart.getData());
        FilePart filePart = new FilePart(bytePart.getName(), source, bytePart.getMimeType(), bytePart.getCharSet());
        return filePart;
    }

    private FilePart generateClientFilePart(com.ning.http.client.Part part) throws FileNotFoundException {
        com.ning.http.client.FilePart currentPart = (com.ning.http.client.FilePart)part;
        FilePart filePart = new FilePart(currentPart.getName(), currentPart.getFile(), currentPart.getMimeType(), currentPart.getCharSet());
        return filePart;
    }

    private StringPart generateClientStringpart(com.ning.http.client.Part part) {
        com.ning.http.client.StringPart stringPart = (com.ning.http.client.StringPart)part;
        StringPart currentPart = new StringPart(stringPart.getName(), stringPart.getValue(), stringPart.getCharset());
        return currentPart;
    }

    private long handleByteArrayPart(WritableByteChannel target, FilePart filePart, byte[] data) throws IOException {
        ByteArrayOutputStream output = this.generateByteArrayBody(filePart);
        return this.writeToTarget(target, output);
    }

    private ByteArrayOutputStream generateByteArrayBody(FilePart filePart) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        Part.sendPart(output, filePart, this.boundary);
        return output;
    }

    private long handleFileEnd(WritableByteChannel target, FilePart filePart) throws IOException {
        ByteArrayOutputStream endOverhead = this.generateFileEnd(filePart);
        return this.writeToTarget(target, endOverhead);
    }

    private ByteArrayOutputStream generateFileEnd(FilePart filePart) throws IOException {
        ByteArrayOutputStream endOverhead = new ByteArrayOutputStream();
        filePart.sendEnd(endOverhead);
        return endOverhead;
    }

    private long handleFileHeaders(WritableByteChannel target, FilePart filePart) throws IOException {
        filePart.setPartBoundary(this.boundary);
        ByteArrayOutputStream overhead = this.generateFileStart(filePart);
        return this.writeToTarget(target, overhead);
    }

    private ByteArrayOutputStream generateFileStart(FilePart filePart) throws IOException {
        ByteArrayOutputStream overhead = new ByteArrayOutputStream();
        filePart.setPartBoundary(this.boundary);
        filePart.sendStart(overhead);
        filePart.sendDispositionHeader(overhead);
        filePart.sendContentTypeHeader(overhead);
        filePart.sendTransferEncodingHeader(overhead);
        filePart.sendEndOfHeader(overhead);
        return overhead;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long handleFilePart(WritableByteChannel target, FilePart filePart) throws IOException {
        FilePartStallHandler handler = new FilePartStallHandler(filePart.getStalledTime(), filePart);
        handler.start();
        if (FilePartSource.class.isAssignableFrom(filePart.getSource().getClass())) {
            int length = 0;
            length = (int)((long)length + this.handleFileHeaders(target, filePart));
            FilePartSource source = (FilePartSource)filePart.getSource();
            File file = source.getFile();
            RandomAccessFile raf = new RandomAccessFile(file, "r");
            this.files.add(raf);
            FileChannel fc = raf.getChannel();
            long l = file.length();
            int fileLength = 0;
            long nWrite = 0L;
            FileChannel fileChannel = fc;
            synchronized (fileChannel) {
                while ((long)fileLength != l) {
                    if (handler.isFailed()) {
                        logger.debug("Stalled error");
                        throw new FileUploadStalledException();
                    }
                    try {
                        nWrite = fc.transferTo(fileLength, l, target);
                        if (nWrite == 0L) {
                            logger.info("Waiting for writing...");
                            try {
                                fc.wait(50L);
                            }
                            catch (InterruptedException e) {
                                logger.trace(e.getMessage(), (Throwable)e);
                            }
                        } else {
                            handler.writeHappened();
                        }
                    }
                    catch (IOException ex) {
                        String message = ex.getMessage();
                        if (message != null && message.equalsIgnoreCase("Resource temporarily unavailable")) {
                            try {
                                fc.wait(1000L);
                            }
                            catch (InterruptedException e) {
                                logger.trace(e.getMessage(), (Throwable)e);
                            }
                            logger.warn("Experiencing NIO issue http://bugs.sun.com/view_bug.do?bug_id=5103988. Retrying");
                            continue;
                        }
                        throw ex;
                    }
                    fileLength = (int)((long)fileLength + nWrite);
                }
            }
            handler.completed();
            fc.close();
            length = (int)((long)length + this.handleFileEnd(target, filePart));
            return length;
        }
        return this.handlePartSource(target, filePart);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long handlePartSource(WritableByteChannel target, FilePart filePart) throws IOException {
        int length = 0;
        length = (int)((long)length + this.handleFileHeaders(target, filePart));
        PartSource partSource = filePart.getSource();
        InputStream stream = partSource.createInputStream();
        try {
            int nRead = 0;
            while (nRead != -1) {
                byte[] bytes = new byte[8192];
                nRead = stream.read(bytes);
                if (nRead <= 0) continue;
                ByteArrayOutputStream bos = new ByteArrayOutputStream(nRead);
                bos.write(bytes, 0, nRead);
                this.writeToTarget(target, bos);
            }
        }
        finally {
            stream.close();
        }
        length = (int)((long)length + this.handleFileEnd(target, filePart));
        return length;
    }

    private long handleStringPart(WritableByteChannel target, StringPart currentPart) throws IOException {
        currentPart.setPartBoundary(this.boundary);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        Part.sendPart(outputStream, currentPart, this.boundary);
        return this.writeToTarget(target, outputStream);
    }

    private long handleMultiPart(WritableByteChannel target, Part currentPart) throws IOException {
        currentPart.setPartBoundary(this.boundary);
        if (currentPart.getClass().equals(StringPart.class)) {
            return this.handleStringPart(target, (StringPart)currentPart);
        }
        if (currentPart.getClass().equals(FilePart.class)) {
            FilePart filePart = (FilePart)currentPart;
            return this.handleFilePart(target, filePart);
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long writeToTarget(WritableByteChannel target, ByteArrayOutputStream byteWriter) throws IOException {
        int written = 0;
        int maxSpin = 0;
        ByteArrayOutputStream byteArrayOutputStream = byteWriter;
        synchronized (byteArrayOutputStream) {
            block15: {
                ByteBuffer message = ByteBuffer.wrap(byteWriter.toByteArray());
                if (target instanceof SocketChannel) {
                    Selector selector = Selector.open();
                    try {
                        SocketChannel channel = (SocketChannel)target;
                        channel.register(selector, 4);
                        while (written < byteWriter.size() && selector.select() != 0) {
                            Set<SelectionKey> selectedKeys = selector.selectedKeys();
                            for (SelectionKey key : selectedKeys) {
                                if (!key.isWritable()) continue;
                                written += target.write(message);
                            }
                        }
                        if (written < byteWriter.size()) {
                            throw new IOException("Unable to write on channel " + target);
                        }
                        break block15;
                    }
                    finally {
                        selector.close();
                    }
                }
                while (target.isOpen() && written < byteWriter.size()) {
                    long nWrite = target.write(message);
                    written = (int)((long)written + nWrite);
                    if (nWrite == 0L && maxSpin++ < 10) {
                        logger.info("Waiting for writing...");
                        try {
                            byteWriter.wait(1000L);
                        }
                        catch (InterruptedException e) {
                            logger.trace(e.getMessage(), (Throwable)e);
                        }
                        continue;
                    }
                    if (maxSpin >= 10) {
                        throw new IOException("Unable to write on channel " + target);
                    }
                    maxSpin = 0;
                }
            }
        }
        return written;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum FileLocation {
        NONE,
        START,
        MIDDLE,
        END;

    }
}

