/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.container;

import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.atmosphere.container.Grizzly2CometSupport;
import org.atmosphere.container.version.Grizzly2WebSocket;
import org.atmosphere.cpr.Action;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResponse;
import org.atmosphere.cpr.WebSocketProcessorFactory;
import org.atmosphere.util.Utils;
import org.atmosphere.websocket.WebSocketProcessor;
import org.glassfish.grizzly.filterchain.Filter;
import org.glassfish.grizzly.filterchain.FilterChain;
import org.glassfish.grizzly.http.HttpRequestPacket;
import org.glassfish.grizzly.http.server.HttpServerFilter;
import org.glassfish.grizzly.http.server.Request;
import org.glassfish.grizzly.http.server.Response;
import org.glassfish.grizzly.http.server.util.DispatcherHelper;
import org.glassfish.grizzly.http.server.util.MappingData;
import org.glassfish.grizzly.http.util.DataChunk;
import org.glassfish.grizzly.servlet.HttpServletRequestImpl;
import org.glassfish.grizzly.servlet.HttpServletResponseImpl;
import org.glassfish.grizzly.servlet.WebappContext;
import org.glassfish.grizzly.websockets.DataFrame;
import org.glassfish.grizzly.websockets.DefaultWebSocket;
import org.glassfish.grizzly.websockets.ProtocolHandler;
import org.glassfish.grizzly.websockets.WebSocket;
import org.glassfish.grizzly.websockets.WebSocketApplication;
import org.glassfish.grizzly.websockets.WebSocketEngine;
import org.glassfish.grizzly.websockets.WebSocketException;
import org.glassfish.grizzly.websockets.WebSocketListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Grizzly2WebSocketSupport
extends Grizzly2CometSupport {
    private static final Logger LOGGER = LoggerFactory.getLogger(Grizzly2WebSocketSupport.class);
    private Grizzly2WebSocketApplication application;

    public Grizzly2WebSocketSupport(AtmosphereConfig config) {
        super(config);
        this.application = new Grizzly2WebSocketApplication(config);
        WebSocketEngine.getEngine().register((WebSocketApplication)this.application);
    }

    @Override
    public Action service(AtmosphereRequest req, AtmosphereResponse res) throws IOException, ServletException {
        if (Utils.webSocketEnabled((HttpServletRequest)req)) {
            return this.suspended(req, res);
        }
        return super.service(req, res);
    }

    @Override
    public String getContainerName() {
        return this.config.getServletConfig().getServletContext().getServerInfo() + " with WebSocket enabled.";
    }

    @Override
    public boolean supportWebSocket() {
        return true;
    }

    @Override
    public void shutdown() {
        WebSocketEngine.getEngine().unregister((WebSocketApplication)this.application);
        super.shutdown();
    }

    private static final class Grizzly2WebSocketApplication
    extends WebSocketApplication {
        private AtmosphereConfig config;
        private final String contextPath;
        private final WebSocketProcessor webSocketProcessor;

        public Grizzly2WebSocketApplication(AtmosphereConfig config) {
            this.config = config;
            this.contextPath = config.getServletContext().getContextPath();
            this.webSocketProcessor = WebSocketProcessorFactory.getDefault().getWebSocketProcessor(config.framework());
        }

        public boolean isApplicationRequest(HttpRequestPacket request) {
            return request.getRequestURI().startsWith(this.contextPath);
        }

        public WebSocket createSocket(ProtocolHandler handler, HttpRequestPacket requestPacket, WebSocketListener ... listeners) {
            return new G2WebSocket(handler, requestPacket, listeners);
        }

        public void onClose(WebSocket socket, DataFrame frame) {
            super.onClose(socket, frame);
            LOGGER.trace("onClose {} ", (Object)socket);
            G2WebSocket g2w = (G2WebSocket)((Object)G2WebSocket.class.cast(socket));
            org.atmosphere.websocket.WebSocket webSocket = (org.atmosphere.websocket.WebSocket)g2w.getRequest().getAttribute("grizzly.webSocket");
            if (webSocket != null) {
                this.webSocketProcessor.close(webSocket, 1000);
            }
        }

        public void onConnect(WebSocket socket) {
            super.onConnect(socket);
            LOGGER.trace("onConnect {} ", (Object)socket);
            if (!G2WebSocket.class.isAssignableFrom(socket.getClass())) {
                throw new IllegalStateException();
            }
            G2WebSocket g2WebSocket = (G2WebSocket)((Object)G2WebSocket.class.cast(socket));
            try {
                AtmosphereRequest r = AtmosphereRequest.wrap(g2WebSocket.getRequest());
                Grizzly2WebSocket webSocket = new Grizzly2WebSocket((WebSocket)g2WebSocket, this.config);
                g2WebSocket.getRequest().setAttribute("grizzly.webSocket", (Object)webSocket);
                this.webSocketProcessor.open(webSocket, r, AtmosphereResponse.newInstance(this.config, r, webSocket));
            }
            catch (Exception e) {
                LOGGER.warn("failed to connect to web socket", (Throwable)e);
            }
        }

        public void onMessage(WebSocket socket, String text) {
            super.onMessage(socket, text);
            LOGGER.trace("onMessage(String) {} ", (Object)socket);
            G2WebSocket g2w = (G2WebSocket)((Object)G2WebSocket.class.cast(socket));
            org.atmosphere.websocket.WebSocket webSocket = (org.atmosphere.websocket.WebSocket)g2w.getRequest().getAttribute("grizzly.webSocket");
            if (webSocket != null) {
                this.webSocketProcessor.invokeWebSocketProtocol(webSocket, text);
            }
        }

        public void onMessage(WebSocket socket, byte[] bytes) {
            super.onMessage(socket, bytes);
            LOGGER.trace("onMessage(byte[]) {} ", (Object)socket);
            G2WebSocket g2w = (G2WebSocket)((Object)G2WebSocket.class.cast(socket));
            org.atmosphere.websocket.WebSocket webSocket = (org.atmosphere.websocket.WebSocket)g2w.getRequest().getAttribute("grizzly.webSocket");
            if (webSocket != null) {
                this.webSocketProcessor.invokeWebSocketProtocol(webSocket, bytes, 0, bytes.length);
            }
        }

        public void onPing(WebSocket socket, byte[] bytes) {
            LOGGER.trace("onPing {} ", (Object)socket);
        }

        public void onPong(WebSocket socket, byte[] bytes) {
            LOGGER.trace("onPong {} ", (Object)socket);
        }

        public void onFragment(WebSocket socket, String fragment, boolean last) {
            LOGGER.trace("onFragment(String) {} ", (Object)socket);
        }

        public void onFragment(WebSocket socket, byte[] fragment, boolean last) {
            LOGGER.trace("onFragment(byte) {} ", (Object)socket);
        }

        private final class G2WebSocket
        extends DefaultWebSocket {
            private final HttpServletRequestImpl servletRequest;
            private final HttpServletResponseImpl servletResponse;

            public G2WebSocket(ProtocolHandler protocolHandler, HttpRequestPacket request, WebSocketListener ... listeners) {
                super(protocolHandler, request, listeners);
                Request req = Request.create();
                Response res = req.getResponse();
                req.initialize(request, protocolHandler.getFilterChainContext(), this.getHttpServerFilterFromChain(protocolHandler.getFilterChainContext().getFilterChain()));
                res.initialize(req, request.getResponse(), protocolHandler.getFilterChainContext(), null, null);
                this.servletRequest = HttpServletRequestImpl.create();
                this.servletResponse = HttpServletResponseImpl.create();
                try {
                    WebappContext context = (WebappContext)Grizzly2WebSocketApplication.this.config.getServletContext();
                    this.servletRequest.initialize(req, context);
                    this.servletResponse.initialize(res);
                    this.mapRequest(context, request, this.servletRequest);
                }
                catch (IOException e) {
                    throw new WebSocketException("Unable to initialize WebSocket instance", (Throwable)e);
                }
            }

            private HttpServerFilter getHttpServerFilterFromChain(FilterChain filterChain) {
                for (Filter candidate : filterChain) {
                    if (!(candidate instanceof HttpServerFilter)) continue;
                    return (HttpServerFilter)candidate;
                }
                return null;
            }

            public HttpServletRequest getRequest() {
                return this.servletRequest;
            }

            public HttpServletResponse getResponse() {
                return this.servletResponse;
            }

            private void mapRequest(WebappContext ctx, HttpRequestPacket request, HttpServletRequestImpl servletRequest) {
                try {
                    Field dispatcher = WebappContext.class.getDeclaredField("dispatcherHelper");
                    dispatcher.setAccessible(true);
                    MappingData data = new MappingData();
                    DispatcherHelper helper = (DispatcherHelper)dispatcher.get(ctx);
                    DataChunk host = DataChunk.newInstance();
                    host.setString(request.getHeader("host"));
                    helper.mapPath(host, request.getRequestURIRef().getDecodedRequestURIBC(), data);
                    servletRequest.setServletPath(data.wrapperPath.toString());
                    Method m = HttpServletRequestImpl.class.getDeclaredMethod("setPathInfo", String.class);
                    m.setAccessible(true);
                    m.invoke((Object)servletRequest, data.pathInfo.toString());
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }
}

