/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.wasync;

import com.ning.http.client.AsyncHttpClient;
import org.atmosphere.wasync.Transport;

public class Options {
    private final OptionsBuilder b;

    private Options(OptionsBuilder b) {
        this.b = b;
    }

    public Transport transport() {
        return this.b.transport;
    }

    public boolean reconnect() {
        return this.b.reconnect;
    }

    public int reconnectInSeconds() {
        return this.b.reconnectInSecond;
    }

    public long waitBeforeUnlocking() {
        return this.b.waitBeforeUnlocking;
    }

    public AsyncHttpClient runtime() {
        return this.b.client;
    }

    public void runtime(AsyncHttpClient client) {
        this.b.client = client;
    }

    public boolean isShared() {
        return this.b.runtimeShared;
    }

    public int requestTimeout() {
        return this.b.requestTimeout;
    }

    public static final class OptionsBuilder {
        private Transport transport;
        private boolean reconnect = true;
        private int reconnectInSecond = 0;
        private long waitBeforeUnlocking = 2500L;
        private AsyncHttpClient client;
        private boolean runtimeShared = false;
        private int requestTimeout = -1;

        public OptionsBuilder requestTimeout(int requestTimeout) {
            this.requestTimeout = requestTimeout * 1000;
            return this;
        }

        public OptionsBuilder registerTransport(Transport transport) {
            this.transport = transport;
            return this;
        }

        public OptionsBuilder reconnect(boolean reconnect) {
            this.reconnect = reconnect;
            return this;
        }

        public OptionsBuilder pauseBeforeReconnectInSeconds(int reconnectInSecond) {
            this.reconnectInSecond = reconnectInSecond;
            return this;
        }

        public OptionsBuilder waitBeforeUnlocking(long waitBeforeUnlocking) {
            this.waitBeforeUnlocking = waitBeforeUnlocking;
            return this;
        }

        public OptionsBuilder runtimeShared(boolean runtimeShared) {
            this.runtimeShared = runtimeShared;
            return this;
        }

        public OptionsBuilder runtime(AsyncHttpClient client) {
            return this.runtime(client, false);
        }

        public OptionsBuilder runtime(AsyncHttpClient client, boolean runtimeShared) {
            this.client = client;
            this.runtimeShared = runtimeShared;
            return this;
        }

        public Options build() {
            return new Options(this);
        }
    }
}

