/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.nettosphere;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.atmosphere.cpr.AsyncIOWriter;
import org.atmosphere.cpr.AtmosphereInterceptorWriter;
import org.atmosphere.cpr.AtmosphereResponse;
import org.atmosphere.util.ByteArrayAsyncWriter;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBufferOutputStream;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.handler.codec.http.DefaultHttpResponse;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.jboss.netty.handler.codec.http.HttpVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChannelAsyncIOWriter
extends AtmosphereInterceptorWriter {
    private static final Logger logger = LoggerFactory.getLogger(ChannelAsyncIOWriter.class);
    private final Channel channel;
    private final AtomicInteger pendingWrite = new AtomicInteger();
    private final AtomicBoolean asyncClose = new AtomicBoolean(false);
    private final ML listener = new ML();
    private boolean resumeOnBroadcast = false;
    private boolean byteWritten = false;
    private final AtomicBoolean isClosed = new AtomicBoolean(false);
    private boolean headerWritten = false;
    private static final String END = Integer.toHexString(0);
    private static final byte[] CHUNK_DELIMITER = "\r\n".getBytes();
    private static final byte[] ENDCHUNK = (END + "\r\n\r\n").getBytes();
    private long lastWrite = 0L;
    private final ByteArrayAsyncWriter buffer = new ByteArrayAsyncWriter();
    private final boolean writeHeader;

    public ChannelAsyncIOWriter(Channel channel) {
        this.channel = channel;
        this.writeHeader = false;
    }

    public ChannelAsyncIOWriter(Channel channel, boolean writeHeader) {
        this.channel = channel;
        this.writeHeader = writeHeader;
    }

    public boolean isClosed() {
        return this.isClosed.get();
    }

    public boolean byteWritten() {
        return this.byteWritten;
    }

    public void resumeOnBroadcast(boolean resumeOnBroadcast) {
        this.resumeOnBroadcast = resumeOnBroadcast;
    }

    public AsyncIOWriter writeError(AtmosphereResponse r, int errorCode, String message) throws IOException {
        if (!this.channel.isOpen()) {
            return this;
        }
        try {
            DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.valueOf((int)errorCode));
            this.channel.write((Object)response).addListener(ChannelFutureListener.CLOSE);
        }
        catch (Throwable ex) {
            logger.debug("", ex);
        }
        return this;
    }

    public AsyncIOWriter write(AtmosphereResponse r, String data) throws IOException {
        byte[] b = data.getBytes("ISO-8859-1");
        this.write(r, b);
        return this;
    }

    public AsyncIOWriter write(AtmosphereResponse r, byte[] data) throws IOException {
        this.write(r, data, 0, data.length);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] transform(AtmosphereResponse response, byte[] b, int offset, int length) throws IOException {
        AsyncIOWriter a = response.getAsyncIOWriter();
        try {
            response.asyncIOWriter((AsyncIOWriter)this.buffer);
            this.invokeInterceptor(response, b, offset, length);
            byte[] byArray = this.buffer.stream().toByteArray();
            return byArray;
        }
        finally {
            this.buffer.close(null);
            response.asyncIOWriter(a);
        }
    }

    public AsyncIOWriter write(AtmosphereResponse r, byte[] data, int offset, int length) throws IOException {
        ChannelBufferOutputStream c;
        boolean transform;
        boolean bl = transform = this.filters.size() > 0 && r.getStatus() < 400;
        if (transform) {
            data = this.transform(r, data, offset, length);
            offset = 0;
            length = data.length;
        }
        logger.trace("About to write to {}", (Object)(r.resource() != null ? r.resource().uuid() : "null"));
        if (this.channel.isOpen()) {
            ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
            this.pendingWrite.incrementAndGet();
            if (this.writeHeader && !this.headerWritten) {
                buffer.writeBytes(this.constructStatusAndHeaders(r).getBytes("UTF-8"));
                this.headerWritten = true;
            }
            c = new ChannelBufferOutputStream(buffer);
            if (this.headerWritten) {
                c.write(Integer.toHexString(length - offset).getBytes("UTF-8"));
                c.write(CHUNK_DELIMITER);
            }
            c.write(data, offset, length);
            if (this.headerWritten) {
                c.write(CHUNK_DELIMITER);
            }
        } else {
            logger.debug("Trying to write on a closed channel {}", (Object)this.channel);
            throw new IOException("Channel closed");
        }
        this.channel.write((Object)c.buffer()).addListener((ChannelFutureListener)this.listener);
        this.byteWritten = true;
        this.lastWrite = System.currentTimeMillis();
        this.headerWritten = true;
        return this;
    }

    public long lastTick() {
        return this.lastWrite == -1L ? System.currentTimeMillis() : this.lastWrite;
    }

    public void close(AtmosphereResponse r) throws IOException {
        if (!this.byteWritten && r != null && r.getOutputStream() != null) {
            r.getOutputStream().flush();
        }
        this.asyncClose.set(true);
        if (this.pendingWrite.get() == 0 && this.channel.isOpen()) {
            this._close();
        }
    }

    void _close() {
        if (!this.isClosed.getAndSet(true)) {
            this.headerWritten = false;
            ChannelBuffer buffer = ChannelBuffers.dynamicBuffer();
            ChannelBufferOutputStream c = new ChannelBufferOutputStream(buffer);
            try {
                c.write(ENDCHUNK);
                this.channel.write((Object)buffer).addListener(ChannelFutureListener.CLOSE);
            }
            catch (IOException e) {
                logger.trace("Close error", (Throwable)e);
            }
        }
    }

    private String constructStatusAndHeaders(AtmosphereResponse response) {
        StringBuffer b = new StringBuffer("HTTP/1.1").append(" ").append(response.getStatus()).append(" ").append(response.getStatusMessage()).append("\n");
        Map headers = response.headers();
        String contentType = response.getContentType();
        int contentLength = -1;
        b.append("Content-Type").append(":").append(headers.get("Content-Type") == null ? contentType : (String)headers.get("Content-Type")).append("\n");
        if (contentLength != -1) {
            b.append("Content-Length").append(":").append(contentLength).append("\n");
        }
        for (String s : headers.keySet()) {
            if (s.equalsIgnoreCase("Content-Type")) continue;
            b.append(s).append(":").append((String)headers.get(s)).append("\n");
        }
        b.deleteCharAt(b.length() - 1);
        b.append("\r\n\r\n");
        return b.toString();
    }

    private final class ML
    implements ChannelFutureListener {
        private ML() {
        }

        public void operationComplete(ChannelFuture future) throws Exception {
            if (ChannelAsyncIOWriter.this.channel.isOpen() && (!future.isSuccess() || ChannelAsyncIOWriter.this.pendingWrite.decrementAndGet() == 0 && (ChannelAsyncIOWriter.this.resumeOnBroadcast || ChannelAsyncIOWriter.this.asyncClose.get()))) {
                ChannelAsyncIOWriter.this._close();
            }
        }
    }
}

