/*
 * Decompiled with CFR 0.152.
 */
package eu.infomas.util;

import java.io.File;
import java.io.IOException;
import java.util.Deque;
import java.util.LinkedList;
import java.util.NoSuchElementException;

public final class FileIterator {
    private final Deque<File> stack = new LinkedList<File>();
    private int rootCount;
    private File current;

    public FileIterator(File ... filesOrDirectories) {
        this.addReverse(filesOrDirectories);
        this.rootCount = this.stack.size();
    }

    public File getFile() {
        return this.current;
    }

    public boolean isRootFile() {
        if (this.current == null) {
            throw new NoSuchElementException();
        }
        return this.stack.size() < this.rootCount;
    }

    public File next() throws IOException {
        if (this.stack.isEmpty()) {
            this.current = null;
            return null;
        }
        this.current = this.stack.removeLast();
        if (this.current.isDirectory()) {
            if (this.stack.size() < this.rootCount) {
                this.rootCount = this.stack.size();
            }
            this.addReverse(this.current.listFiles());
            return this.next();
        }
        return this.current;
    }

    private void addReverse(File[] files) {
        for (int i = files.length - 1; i >= 0; --i) {
            this.stack.add(files[i]);
        }
    }
}

