/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.wasync.samples;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Date;
import org.atmosphere.wasync.ClientFactory;
import org.atmosphere.wasync.Decoder;
import org.atmosphere.wasync.Encoder;
import org.atmosphere.wasync.Event;
import org.atmosphere.wasync.Function;
import org.atmosphere.wasync.Options;
import org.atmosphere.wasync.Request;
import org.atmosphere.wasync.Socket;
import org.atmosphere.wasync.impl.AtmosphereClient;
import org.atmosphere.wasync.impl.AtmosphereRequest;
import org.atmosphere.wasync.samples.Chat;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class wAsyncChat {
    private static final Logger logger = LoggerFactory.getLogger(wAsyncChat.class);
    private static final ObjectMapper mapper = new ObjectMapper();

    public static void main(String[] args) throws IOException {
        if (args.length == 0) {
            args = new String[]{"http://127.0.0.1:8080"};
        }
        Options options = new Options.OptionsBuilder().build();
        AtmosphereClient client = (AtmosphereClient)ClientFactory.getDefault().newClient(AtmosphereClient.class);
        AtmosphereRequest.AtmosphereRequestBuilder request = ((AtmosphereRequest.AtmosphereRequestBuilder)((AtmosphereRequest.AtmosphereRequestBuilder)((AtmosphereRequest.AtmosphereRequestBuilder)((AtmosphereRequest.AtmosphereRequestBuilder)client.newRequestBuilder().method(Request.METHOD.GET)).uri(args[0] + "/chat")).trackMessageLength(true).encoder((Encoder)new Encoder<Chat.Data, String>(){

            public String encode(Chat.Data data) {
                try {
                    return mapper.writeValueAsString((Object)data);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        })).decoder((Decoder)new Decoder<String, Chat.Data>(){

            public Chat.Data decode(Event type, String data) {
                if ((data = data.trim()).length() == 0) {
                    return null;
                }
                if (type.equals((Object)Event.MESSAGE)) {
                    try {
                        return (Chat.Data)mapper.readValue(data, Chat.Data.class);
                    }
                    catch (IOException e) {
                        logger.debug("Invalid message {}", (Object)data);
                        return null;
                    }
                }
                return null;
            }
        })).transport(Request.TRANSPORT.WEBSOCKET).transport(Request.TRANSPORT.LONG_POLLING);
        Socket socket = client.create(options);
        socket.on("message", (Function)new Function<Chat.Data>(){

            public void on(Chat.Data t) {
                Date d = new Date(t.getTime());
                logger.info("Author {}: {}", (Object)(t.getAuthor() + "@ " + d.getHours() + ":" + d.getMinutes()), (Object)t.getMessage());
            }
        }).on((Function)new Function<Throwable>(){

            public void on(Throwable t) {
                t.printStackTrace();
            }
        }).open(request.build());
        logger.info("Choose Name: ");
        String name = null;
        String a = "";
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        while (!a.equals("quit")) {
            a = br.readLine();
            if (name == null) {
                name = a;
            }
            socket.fire((Object)new Chat.Data(name, a));
        }
        socket.close();
    }
}

