/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.nettosphere;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpSession;
import org.atmosphere.container.NettyCometSupport;
import org.atmosphere.cpr.Action;
import org.atmosphere.cpr.AsyncIOWriter;
import org.atmosphere.cpr.AsyncSupport;
import org.atmosphere.cpr.AsynchronousProcessor;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereFramework;
import org.atmosphere.cpr.AtmosphereHandler;
import org.atmosphere.cpr.AtmosphereInterceptor;
import org.atmosphere.cpr.AtmosphereMappingException;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResponse;
import org.atmosphere.cpr.FrameworkConfig;
import org.atmosphere.cpr.WebSocketProcessorFactory;
import org.atmosphere.nettosphere.ChannelAsyncIOWriter;
import org.atmosphere.nettosphere.Config;
import org.atmosphere.nettosphere.Context;
import org.atmosphere.nettosphere.HttpStaticFileServerHandler;
import org.atmosphere.nettosphere.NettyWebSocket;
import org.atmosphere.util.FakeHttpSession;
import org.atmosphere.websocket.WebSocket;
import org.atmosphere.websocket.WebSocketProcessor;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBufferInputStream;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.handler.codec.http.DefaultHttpResponse;
import org.jboss.netty.handler.codec.http.HttpHeaders;
import org.jboss.netty.handler.codec.http.HttpMessage;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.HttpResponse;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.jboss.netty.handler.codec.http.HttpVersion;
import org.jboss.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import org.jboss.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import org.jboss.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import org.jboss.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import org.jboss.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import org.jboss.netty.handler.codec.http.websocketx.WebSocketFrame;
import org.jboss.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import org.jboss.netty.handler.codec.http.websocketx.WebSocketServerHandshakerFactory;
import org.jboss.netty.util.CharsetUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyAtmosphereHandler
extends HttpStaticFileServerHandler {
    private static final Logger logger = LoggerFactory.getLogger(NettyAtmosphereHandler.class);
    private final AtmosphereFramework framework;
    private final Config config;
    private final ScheduledExecutorService suspendTimer;
    private final ConcurrentHashMap<String, HttpSession> sessions = new ConcurrentHashMap();
    private final AtomicBoolean isShutdown = new AtomicBoolean();
    private final WebSocketProcessor webSocketProcessor;

    public NettyAtmosphereHandler(Config config) {
        super(config.path());
        this.config = config;
        this.framework = new AtmosphereFramework();
        if (config.broadcaster() != null) {
            this.framework.setDefaultBroadcasterClassName(config.broadcaster().getName());
        }
        this.framework.setAtmosphereDotXmlPath(config.configFile());
        this.framework.setAsyncSupport((AsyncSupport)new NettyCometSupport(this.framework.getAtmosphereConfig()){

            public Action suspended(AtmosphereRequest request, AtmosphereResponse response) throws IOException, ServletException {
                Action a = super.suspended(request, response);
                if (NettyAtmosphereHandler.this.framework.getAtmosphereConfig().isSupportSession()) {
                    AtmosphereResource r = request.resource();
                    HttpSession s = request.getSession(true);
                    if (s != null) {
                        NettyAtmosphereHandler.this.sessions.put(r.uuid(), request.getSession(true));
                    }
                }
                return a;
            }
        });
        try {
            if (config.broadcasterFactory() != null) {
                this.framework.setBroadcasterFactory(config.broadcasterFactory());
            }
        }
        catch (Throwable t) {
            logger.trace("", t);
        }
        if (config.broadcasterCache() != null) {
            try {
                this.framework.setBroadcasterCacheClassName(config.broadcasterCache().getName());
            }
            catch (Throwable t) {
                logger.trace("", t);
            }
        }
        Map<String, AtmosphereHandler> handlersMap = config.handlersMap();
        for (Map.Entry<String, AtmosphereHandler> entry : handlersMap.entrySet()) {
            this.framework.addAtmosphereHandler(entry.getKey(), entry.getValue());
        }
        if (config.webSocketProtocol() != null) {
            this.framework.setWebSocketProtocolClassName(config.webSocketProtocol().getName());
        }
        for (AtmosphereInterceptor atmosphereInterceptor : config.interceptors()) {
            this.framework.interceptor(atmosphereInterceptor);
        }
        if (!config.scanPackages().isEmpty()) {
            for (Class clazz : config.scanPackages()) {
                this.framework.addAnnotationPackage(clazz);
            }
        }
        final Context context = new Context.Builder().contextPath(config.mappingPath()).basePath(config.path()).build();
        ServletContext servletContext = (ServletContext)Proxy.newProxyInstance(NettyAtmosphereHandler.class.getClassLoader(), new Class[]{ServletContext.class}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                Method stub = Context.class.getMethod(method.getName(), method.getParameterTypes());
                if (stub != null) {
                    return stub.invoke((Object)context, args);
                }
                logger.trace("Method {} not supported", (Object)method.getName());
                return null;
            }
        });
        try {
            this.framework.init((ServletConfig)new NettyServletConfig(config.initParams(), servletContext));
        }
        catch (ServletException e) {
            throw new RuntimeException(e);
        }
        this.suspendTimer = new ScheduledThreadPoolExecutor(Runtime.getRuntime().availableProcessors());
        this.webSocketProcessor = WebSocketProcessorFactory.getDefault().getWebSocketProcessor(this.framework);
    }

    @Override
    public void messageReceived(ChannelHandlerContext ctx, MessageEvent messageEvent) throws URISyntaxException, IOException {
        Object msg = messageEvent.getMessage();
        if (this.isShutdown.get()) {
            ctx.getChannel().close().addListener(ChannelFutureListener.CLOSE);
            return;
        }
        if (msg instanceof HttpRequest) {
            HttpRequest r = (HttpRequest)HttpRequest.class.cast(msg);
            List c = r.getHeaders("Connection");
            String u = r.getHeader("Upgrade");
            boolean webSocket = false;
            if (u != null && u.equalsIgnoreCase("websocket")) {
                webSocket = true;
            }
            for (String connection : c) {
                if (connection == null || !connection.toLowerCase().equalsIgnoreCase("upgrade")) continue;
                webSocket = true;
            }
            logger.trace("Handling request {}", (Object)r);
            if (webSocket) {
                this.handleWebSocketHandshake(ctx, messageEvent);
            } else {
                this.handleHttp(ctx, messageEvent);
            }
        } else if (msg instanceof WebSocketFrame) {
            this.handleWebSocketFrame(ctx, messageEvent);
        }
    }

    private void handleWebSocketHandshake(ChannelHandlerContext ctx, MessageEvent messageEvent) throws IOException, URISyntaxException {
        HttpRequest request = (HttpRequest)messageEvent.getMessage();
        if (request.getMethod() != HttpMethod.GET) {
            this.sendHttpResponse(ctx, request, (HttpResponse)new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.FORBIDDEN));
            return;
        }
        WebSocketServerHandshakerFactory wsFactory = new WebSocketServerHandshakerFactory(this.getWebSocketLocation(request), null, false);
        WebSocketServerHandshaker handshaker = wsFactory.newHandshaker(request);
        if (handshaker == null) {
            wsFactory.sendUnsupportedWebSocketVersionResponse(ctx.getChannel());
        } else {
            handshaker.handshake(ctx.getChannel(), request);
        }
        AtmosphereRequest r = this.createAtmosphereRequest(ctx, request);
        NettyWebSocket webSocket = new NettyWebSocket(ctx.getChannel(), this.framework.getAtmosphereConfig());
        ctx.setAttachment((Object)webSocket);
        this.webSocketProcessor.open((WebSocket)webSocket, r, AtmosphereResponse.newInstance((AtmosphereConfig)this.framework.getAtmosphereConfig(), (AtmosphereRequest)r, (WebSocket)webSocket));
    }

    private void handleWebSocketFrame(ChannelHandlerContext ctx, MessageEvent messageEvent) throws URISyntaxException, IOException {
        WebSocketFrame frame = (WebSocketFrame)messageEvent.getMessage();
        if (frame instanceof CloseWebSocketFrame) {
            ctx.getChannel().write((Object)frame).addListener(ChannelFutureListener.CLOSE);
        } else if (frame instanceof PingWebSocketFrame) {
            ctx.getChannel().write((Object)new PongWebSocketFrame(frame.getBinaryData()));
        } else if (frame instanceof BinaryWebSocketFrame) {
            ChannelBuffer binaryData = frame.getBinaryData();
            this.webSocketProcessor.invokeWebSocketProtocol((WebSocket)ctx.getAttachment(), binaryData.array(), binaryData.arrayOffset(), binaryData.readableBytes());
        } else if (frame instanceof TextWebSocketFrame) {
            this.webSocketProcessor.invokeWebSocketProtocol((WebSocket)ctx.getAttachment(), ((TextWebSocketFrame)frame).getText());
        } else {
            throw new UnsupportedOperationException(String.format("%s frame types not supported", frame.getClass().getName()));
        }
    }

    private AtmosphereRequest createAtmosphereRequest(ChannelHandlerContext ctx, HttpRequest request) throws URISyntaxException, UnsupportedEncodingException, MalformedURLException {
        String[] uuid;
        String[] transport;
        String u;
        String base = this.getBaseUri(request);
        URI requestUri = new URI(base.substring(0, base.length() - 1) + request.getUri());
        String ct = request.getHeaders("Content-Type").size() > 0 ? (String)request.getHeaders("Content-Type").get(0) : "text/plain";
        long cl = HttpHeaders.getContentLength((HttpMessage)request);
        String method = request.getMethod().getName();
        String queryString = requestUri.getQuery();
        HashMap<String, String[]> qs = new HashMap<String, String[]>();
        if (queryString != null) {
            this.parseQueryString(qs, queryString);
        }
        if (ct.equalsIgnoreCase("application/x-www-form-urlencoded")) {
            this.parseQueryString(qs, new String(request.getContent().array(), "UTF-8"));
        }
        int last = (u = requestUri.toURL().toString()).indexOf("?") == -1 ? u.length() : u.indexOf("?");
        String url = u.substring(0, last);
        int l = url.contains(this.config.mappingPath()) ? requestUri.getAuthority().length() + requestUri.getScheme().length() + 3 + this.config.mappingPath().length() : requestUri.getAuthority().length() + requestUri.getScheme().length() + 3;
        HttpSession session = null;
        if (this.framework.getAtmosphereConfig().isSupportSession() && (transport = (String[])qs.get("X-Atmosphere-Transport")) != null && transport.length > 0 && (uuid = (String[])qs.get("X-Atmosphere-tracking-id")) != null && uuid.length > 0) {
            if (transport[0].equalsIgnoreCase("close")) {
                this.sessions.remove(uuid[0]);
            } else {
                session = this.sessions.get(uuid[0]);
                if (session == null) {
                    session = new FakeHttpSession("-1", null, System.currentTimeMillis(), -1);
                }
            }
        }
        HashMap attributes = new HashMap();
        AtmosphereRequest.Builder requestBuilder = new AtmosphereRequest.Builder();
        AtmosphereRequest r = requestBuilder.requestURI(url.substring(l)).requestURL(url).pathInfo(url.substring(l)).headers(this.getHeaders(request)).method(method).contentType(ct).contentLength(Long.valueOf(cl)).destroyable(false).attributes(attributes).servletPath(this.config.mappingPath()).session(session).queryStrings(qs).remotePort(((InetSocketAddress)ctx.getChannel().getRemoteAddress()).getPort()).remoteAddr(((InetSocketAddress)ctx.getChannel().getRemoteAddress()).getAddress().getHostAddress()).remoteHost(((InetSocketAddress)ctx.getChannel().getRemoteAddress()).getHostName()).localPort(((InetSocketAddress)ctx.getChannel().getLocalAddress()).getPort()).localAddr(((InetSocketAddress)ctx.getChannel().getLocalAddress()).getAddress().getHostAddress()).localName(((InetSocketAddress)ctx.getChannel().getLocalAddress()).getHostName()).inputStream((InputStream)new ChannelBufferInputStream(request.getContent())).build();
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleHttp(ChannelHandlerContext ctx, MessageEvent messageEvent) throws URISyntaxException, IOException {
        block27: {
            final ChannelAsyncIOWriter w = new ChannelAsyncIOWriter(ctx.getChannel(), true);
            boolean resumeOnBroadcast = false;
            boolean keptOpen = false;
            HttpRequest request = (HttpRequest)messageEvent.getMessage();
            String method = request.getMethod().getName();
            try {
                request.addHeader(STATIC_MAPPING, (Object)"true");
                super.messageReceived(ctx, messageEvent);
                if (request.getHeader(SERVICED) != null) {
                    return;
                }
            }
            catch (Exception e) {
                logger.debug("", (Throwable)e);
            }
            finally {
                request.addHeader(STATIC_MAPPING, (Object)"false");
            }
            boolean skipClose = false;
            try {
                Action action;
                AtmosphereRequest r = this.createAtmosphereRequest(ctx, request);
                AtmosphereResponse response = new AtmosphereResponse.Builder().writeHeader(true).asyncIOWriter((AsyncIOWriter)w).writeHeader(false).header("Connection", "Keep-Alive").header("Transfer-Encoding", "chunked").header("Server", "Nettosphere/2.0").request(r).build();
                r.setAttribute(NettyCometSupport.CHANNEL, (Object)w);
                Action a = this.framework.doCometSupport(r, response);
                final AsynchronousProcessor.AsynchronousProcessorHook hook = (AsynchronousProcessor.AsynchronousProcessorHook)r.getAttribute(FrameworkConfig.ASYNCHRONOUS_HOOK);
                String transport = (String)r.getAttribute(FrameworkConfig.TRANSPORT_IN_USE);
                if (transport == null) {
                    transport = r.getHeader("X-Atmosphere-Transport");
                }
                if (a.type() == Action.TYPE.SUSPEND) {
                    if (transport != null && (transport.equalsIgnoreCase("streaming") || transport.equalsIgnoreCase("sse"))) {
                        keptOpen = true;
                    } else if (transport != null && transport.equalsIgnoreCase("long-polling")) {
                        resumeOnBroadcast = true;
                    }
                }
                if ((action = (Action)r.getAttribute(NettyCometSupport.SUSPEND)) != null && action.type() == Action.TYPE.SUSPEND && action.timeout() != -1L) {
                    final AtomicReference f = new AtomicReference();
                    f.set(this.suspendTimer.scheduleAtFixedRate(new Runnable(){

                        @Override
                        public void run() {
                            if (!w.isClosed() && System.currentTimeMillis() - w.lastTick() > action.timeout()) {
                                hook.timedOut();
                                ((Future)f.get()).cancel(true);
                            }
                        }
                    }, action.timeout(), action.timeout(), TimeUnit.MILLISECONDS));
                } else if (action != null && action.type() == Action.TYPE.RESUME) {
                    resumeOnBroadcast = false;
                }
                w.resumeOnBroadcast(resumeOnBroadcast);
            }
            catch (AtmosphereMappingException ex) {
                if (!method.equalsIgnoreCase("GET")) break block27;
                logger.trace("Unable to map the request {}, trying static file", messageEvent.getMessage());
                try {
                    skipClose = true;
                    super.messageReceived(ctx, messageEvent);
                }
                catch (Exception e) {
                    logger.error("Unable to process request", (Throwable)e);
                    throw new IOException(e);
                }
            }
            catch (Throwable e) {
                logger.error("Unable to process request", e);
                throw new IOException(e);
            }
            finally {
                if (w != null && !resumeOnBroadcast && !keptOpen) {
                    if (!w.byteWritten()) {
                        w.writeError(null, 200, "OK");
                    }
                    if (!skipClose) {
                        w.close(null);
                    }
                }
            }
        }
    }

    @Override
    protected void sendError(ChannelHandlerContext ctx, HttpResponseStatus status, MessageEvent e) {
        if (e != null) {
            HttpRequest request = (HttpRequest)e.getMessage();
            if (request.getHeader(STATIC_MAPPING) == null || request.getHeader(STATIC_MAPPING).equalsIgnoreCase("false")) {
                super.sendError(ctx, status, e);
            }
        } else {
            super.sendError(ctx, status, e);
        }
    }

    public void destroy() {
        this.isShutdown.set(true);
        if (this.framework != null) {
            this.framework.destroy();
        }
        this.suspendTimer.shutdown();
    }

    public void channelClosed(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        super.channelClosed(ctx, e);
        WebSocket webSocket = (WebSocket)ctx.getAttachment();
        if (webSocket == null) {
            return;
        }
        this.webSocketProcessor.close(webSocket, 1000);
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        logger.debug("Exception", e.getCause());
        super.exceptionCaught(ctx, e);
    }

    private Map<String, String> getHeaders(HttpRequest request) {
        HashMap<String, String> headers = new HashMap<String, String>();
        for (String name : request.getHeaderNames()) {
            headers.put(name, (String)request.getHeaders(name).get(0));
        }
        return headers;
    }

    private String getBaseUri(HttpRequest request) {
        return "http://" + request.getHeader("Host") + "/";
    }

    private void parseQueryString(Map<String, String[]> qs, String queryString) {
        if (queryString != null) {
            String[] s;
            for (String a : s = queryString.split("&")) {
                String[] q = a.split("=");
                String[] z = new String[]{q.length > 1 ? q[1] : ""};
                qs.put(q[0], z);
            }
        }
    }

    Config config() {
        return this.config;
    }

    private void sendHttpResponse(ChannelHandlerContext ctx, HttpRequest req, HttpResponse res) {
        if (res.getStatus().getCode() != 200) {
            res.setContent(ChannelBuffers.copiedBuffer((CharSequence)res.getStatus().toString(), (Charset)CharsetUtil.UTF_8));
            HttpHeaders.setContentLength((HttpMessage)res, (long)res.getContent().readableBytes());
        }
        ChannelFuture f = ctx.getChannel().write((Object)res);
        if (!HttpHeaders.isKeepAlive((HttpMessage)req) || res.getStatus().getCode() != 200) {
            f.addListener(ChannelFutureListener.CLOSE);
        }
    }

    private String getWebSocketLocation(HttpRequest req) {
        return "ws://" + req.getHeader("Host") + req.getUri();
    }

    private static final class NettyServletConfig
    implements ServletConfig {
        private final Map<String, String> initParams;
        private final ServletContext ctx;

        public NettyServletConfig(Map<String, String> initParams, ServletContext ctx) {
            this.initParams = initParams;
            this.ctx = ctx;
        }

        public String getServletName() {
            return "Netty";
        }

        public ServletContext getServletContext() {
            return this.ctx;
        }

        public String getInitParameter(String name) {
            return this.initParams.get(name);
        }

        public Enumeration getInitParameterNames() {
            return Collections.enumeration(this.initParams.keySet());
        }
    }
}

