/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.container;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.atmosphere.container.Jetty9WebSocketHandler;
import org.atmosphere.container.Servlet30CometSupport;
import org.atmosphere.cpr.Action;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResponse;
import org.atmosphere.cpr.WebSocketProcessorFactory;
import org.atmosphere.util.Utils;
import org.atmosphere.websocket.WebSocket;
import org.atmosphere.websocket.WebSocketProcessor;
import org.eclipse.jetty.websocket.api.UpgradeRequest;
import org.eclipse.jetty.websocket.api.UpgradeResponse;
import org.eclipse.jetty.websocket.api.WebSocketBehavior;
import org.eclipse.jetty.websocket.api.WebSocketPolicy;
import org.eclipse.jetty.websocket.server.ServletWebSocketRequest;
import org.eclipse.jetty.websocket.server.WebSocketServerFactory;
import org.eclipse.jetty.websocket.servlet.WebSocketCreator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Jetty9AsyncSupportWithWebSocket
extends Servlet30CometSupport {
    private static final Logger logger = LoggerFactory.getLogger(Jetty9AsyncSupportWithWebSocket.class);
    private final WebSocketServerFactory webSocketFactory;

    public Jetty9AsyncSupportWithWebSocket(final AtmosphereConfig config) {
        super(config);
        String max;
        String bs = config.getInitParameter("org.atmosphere.websocket.bufferSize");
        WebSocketPolicy policy = new WebSocketPolicy(WebSocketBehavior.SERVER);
        if (bs != null) {
            policy.setInputBufferSize(Integer.parseInt(bs));
        }
        if ((max = config.getInitParameter("org.atmosphere.websocket.maxIdleTime")) != null) {
            policy.setIdleTimeout((long)Integer.parseInt(max));
        }
        if ((max = config.getInitParameter("org.atmosphere.websocket.maxTextMessageSize")) != null) {
            policy.setMaxMessageSize((long)Integer.parseInt(max));
        }
        if ((max = config.getInitParameter("org.atmosphere.websocket.maxBinaryMessageSize")) != null) {
            policy.setMaxMessageSize((long)Integer.parseInt(max));
        }
        final WebSocketProcessor webSocketProcessor = WebSocketProcessorFactory.getDefault().getWebSocketProcessor(config.framework());
        this.webSocketFactory = new WebSocketServerFactory(policy){

            public boolean acceptWebSocket(final HttpServletRequest request, HttpServletResponse response) throws IOException {
                this.setCreator(new WebSocketCreator(){

                    public Object createWebSocket(UpgradeRequest upgradeRequest, UpgradeResponse upgradeResponse) {
                        ServletWebSocketRequest r = (ServletWebSocketRequest)ServletWebSocketRequest.class.cast(upgradeRequest);
                        r.getExtensions().clear();
                        return new Jetty9WebSocketHandler(request, config.framework(), webSocketProcessor);
                    }
                });
                return super.acceptWebSocket(request, response);
            }
        };
        try {
            this.webSocketFactory.start();
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
        }
    }

    @Override
    public Action service(AtmosphereRequest req, AtmosphereResponse res) throws IOException, ServletException {
        Action action = null;
        Boolean b = (Boolean)req.getAttribute(WebSocket.WEBSOCKET_INITIATED);
        if (b == null) {
            b = Boolean.FALSE;
        }
        if (!Utils.webSocketEnabled((HttpServletRequest)req) && req.getAttribute(WebSocket.WEBSOCKET_ACCEPT_DONE) == null) {
            if (req.resource() != null && req.resource().transport() == AtmosphereResource.TRANSPORT.WEBSOCKET) {
                WebSocket.notSupported(req, res);
                return Action.CANCELLED;
            }
            return super.service(req, res);
        }
        if (this.webSocketFactory != null && !b.booleanValue()) {
            req.setAttribute(WebSocket.WEBSOCKET_INITIATED, true);
            this.webSocketFactory.acceptWebSocket((HttpServletRequest)req, (HttpServletResponse)res);
            req.setAttribute(WebSocket.WEBSOCKET_ACCEPT_DONE, true);
            return new Action();
        }
        action = this.suspended(req, res);
        if (action.type() != Action.TYPE.SUSPEND && action.type() == Action.TYPE.RESUME) {
            req.setAttribute(WebSocket.WEBSOCKET_RESUME, true);
        }
        return action == null ? super.service(req, res) : action;
    }

    @Override
    public String getContainerName() {
        return this.config.getServletConfig().getServletContext().getServerInfo() + " with WebSocket enabled.";
    }

    @Override
    public boolean supportWebSocket() {
        return true;
    }
}

